/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.Binder;

@Singleton
public class BindPartIdsAndETagsToRequest
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Map, "this binder is only valid for Map!");
        Preconditions.checkNotNull(request, "request");
        Map map = (Map)input;
        Preconditions.checkArgument(!map.isEmpty(), "Please send parts");
        StringBuilder content = new StringBuilder();
        content.append("<CompleteMultipartUpload>");
        for (Map.Entry entry : map.entrySet()) {
            content.append("<Part>");
            content.append("<PartNumber>").append(entry.getKey()).append("</PartNumber>");
            content.append("<ETag>").append((String)entry.getValue()).append("</ETag>");
            content.append("</Part>");
        }
        content.append("</CompleteMultipartUpload>");
        StringPayload payload = Payloads.newStringPayload(content.toString());
        payload.getContentMetadata().setContentType("text/xml");
        request.setPayload(payload);
        return request;
    }
}

