/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.CachedDNSToSwitchMapping;
import org.apache.pulsar.broker.BookKeeperClientFactoryImpl;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.zookeeper.ZkBookieRackAffinityMapping;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BookKeeperClientFactoryImplTest {
    @Test
    public void testSetDefaultEnsemblePlacementPolicyRackAwareDisabled() {
        AtomicReference rackawarePolicyZkCache = new AtomicReference();
        AtomicReference clientIsolationZkCache = new AtomicReference();
        ClientConfiguration bkConf = new ClientConfiguration();
        ServiceConfiguration conf = new ServiceConfiguration();
        ZooKeeper zkClient = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        Assert.assertNull((Object)bkConf.getProperty("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getProperty("reppRegionsToWrite"));
        Assert.assertNull((Object)bkConf.getProperty("reppMinimumRegionsForDurability"));
        Assert.assertNull((Object)bkConf.getProperty("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertNull((Object)bkConf.getProperty("reppDnsResolverClass"));
        BookKeeperClientFactoryImpl.setDefaultEnsemblePlacementPolicy(rackawarePolicyZkCache, clientIsolationZkCache, (ClientConfiguration)bkConf, (ServiceConfiguration)conf, (ZooKeeper)zkClient);
        Assert.assertNull((Object)bkConf.getProperty("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getProperty("reppRegionsToWrite"));
        Assert.assertNull((Object)bkConf.getProperty("reppMinimumRegionsForDurability"));
        Assert.assertNull((Object)bkConf.getProperty("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertEquals((Object)bkConf.getProperty("reppDnsResolverClass"), (Object)ZkBookieRackAffinityMapping.class.getName());
    }

    @Test
    public void testSetDefaultEnsemblePlacementPolicyRackAwareEnabled() {
        AtomicReference rackawarePolicyZkCache = new AtomicReference();
        AtomicReference clientIsolationZkCache = new AtomicReference();
        ClientConfiguration bkConf = new ClientConfiguration();
        ServiceConfiguration conf = new ServiceConfiguration();
        ZooKeeper zkClient = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        Assert.assertNull((Object)bkConf.getProperty("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getProperty("reppRegionsToWrite"));
        Assert.assertNull((Object)bkConf.getProperty("reppMinimumRegionsForDurability"));
        Assert.assertNull((Object)bkConf.getProperty("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertNull((Object)bkConf.getProperty("reppDnsResolverClass"));
        conf.setBookkeeperClientRegionawarePolicyEnabled(true);
        BookKeeperClientFactoryImpl.setDefaultEnsemblePlacementPolicy(rackawarePolicyZkCache, clientIsolationZkCache, (ClientConfiguration)bkConf, (ServiceConfiguration)conf, (ZooKeeper)zkClient);
        Assert.assertTrue((boolean)bkConf.getBoolean("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getString("reppRegionsToWrite"));
        Assert.assertEquals((int)2, (int)bkConf.getInt("reppMinimumRegionsForDurability"));
        Assert.assertTrue((boolean)bkConf.getBoolean("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertEquals((Object)bkConf.getProperty("reppDnsResolverClass"), (Object)ZkBookieRackAffinityMapping.class.getName());
    }

    @Test
    public void testSetDefaultEnsemblePlacementPolicyRackAwareEnabledChangedValues() {
        AtomicReference rackawarePolicyZkCache = new AtomicReference();
        AtomicReference clientIsolationZkCache = new AtomicReference();
        ClientConfiguration bkConf = new ClientConfiguration();
        ServiceConfiguration conf = new ServiceConfiguration();
        ZooKeeper zkClient = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        Assert.assertNull((Object)bkConf.getProperty("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getProperty("reppRegionsToWrite"));
        Assert.assertNull((Object)bkConf.getProperty("reppMinimumRegionsForDurability"));
        Assert.assertNull((Object)bkConf.getProperty("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertNull((Object)bkConf.getProperty("reppDnsResolverClass"));
        conf.setBookkeeperClientRegionawarePolicyEnabled(true);
        conf.getProperties().setProperty("reppEnableValidation", "false");
        conf.getProperties().setProperty("reppRegionsToWrite", "region1;region2");
        conf.getProperties().setProperty("reppMinimumRegionsForDurability", "4");
        conf.getProperties().setProperty("reppEnableDurabilityEnforcementInReplace", "false");
        conf.getProperties().setProperty("reppDnsResolverClass", CachedDNSToSwitchMapping.class.getName());
        BookKeeperClientFactoryImpl.setDefaultEnsemblePlacementPolicy(rackawarePolicyZkCache, clientIsolationZkCache, (ClientConfiguration)bkConf, (ServiceConfiguration)conf, (ZooKeeper)zkClient);
        Assert.assertFalse((boolean)bkConf.getBoolean("reppEnableValidation"));
        Assert.assertEquals((String)"region1;region2", (String)bkConf.getString("reppRegionsToWrite"));
        Assert.assertEquals((int)4, (int)bkConf.getInt("reppMinimumRegionsForDurability"));
        Assert.assertFalse((boolean)bkConf.getBoolean("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertEquals((Object)bkConf.getProperty("reppDnsResolverClass"), (Object)CachedDNSToSwitchMapping.class.getName());
    }
}

