/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.SubscribeRate;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlogQuotaMap(ServiceConfiguration configuration) {
        return Collections.singletonMap(BacklogQuota.BacklogQuotaType.destination_storage, ConfigHelper.backlogQuota(configuration));
    }

    public static BacklogQuota backlogQuota(ServiceConfiguration configuration) {
        return new BacklogQuota(configuration.getBacklogQuotaDefaultLimitGB() * 1024L * 1024L * 1024L, configuration.getBacklogQuotaDefaultRetentionPolicy());
    }

    public static DispatchRate topicDispatchRate(ServiceConfiguration configuration) {
        return new DispatchRate(configuration.getDispatchThrottlingRatePerTopicInMsg(), configuration.getDispatchThrottlingRatePerTopicInByte(), 1);
    }

    public static DispatchRate subscriptionDispatchRate(ServiceConfiguration configuration) {
        return new DispatchRate(configuration.getDispatchThrottlingRatePerSubscriptionInMsg(), configuration.getDispatchThrottlingRatePerSubscriptionInByte(), 1);
    }

    public static DispatchRate replicatorDispatchRate(ServiceConfiguration configuration) {
        return new DispatchRate(configuration.getDispatchThrottlingRatePerReplicatorInMsg(), configuration.getDispatchThrottlingRatePerReplicatorInByte(), 1);
    }

    public static SubscribeRate subscribeRate(ServiceConfiguration configuration) {
        return new SubscribeRate(configuration.getSubscribeThrottlingRatePerConsumer(), configuration.getSubscribeRatePeriodPerConsumerInSecond());
    }
}

