/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockedBookKeeperClientFactory
implements BookKeeperClientFactory {
    private static final Logger log = LoggerFactory.getLogger(MockedBookKeeperClientFactory.class);
    private final BookKeeper mockedBk;
    private final ExecutorService executor;

    public MockedBookKeeperClientFactory() {
        try {
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("mock-bk-client-factory").setUncaughtExceptionHandler((thread, ex) -> log.info("Uncaught exception", ex)).build());
            this.mockedBk = new PulsarMockBookKeeper(null, this.executor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties) throws IOException {
        return this.mockedBk;
    }

    public void close() {
        try {
            this.mockedBk.close();
        }
        catch (InterruptedException | BKException throwable) {
            // empty catch block
        }
        this.executor.shutdown();
    }
}

