/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.UriInfo;
import org.apache.pulsar.broker.admin.MockServletContext;
import org.apache.pulsar.broker.admin.v2.PersistentTopics;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AdminApiGetLastMessageIdTest
extends MockedPulsarServiceBaseTest {
    private PersistentTopics persistentTopics;
    private final String testTenant = "my-tenant";
    private final String testLocalCluster = "use";
    private final String testNamespace = "my-namespace";
    protected Field uriField;
    protected UriInfo uriInfo;

    @BeforeClass
    public void initPersistentTopics() throws Exception {
        this.uriField = PulsarWebResource.class.getDeclaredField("uri");
        this.uriField.setAccessible(true);
        this.uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
    }

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
        this.admin.tenants().createTenant("prop", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("prop/ns-abc");
        this.admin.namespaces().setNamespaceReplicationClusters("prop/ns-abc", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.persistentTopics = (PersistentTopics)Mockito.spy((Object)new PersistentTopics());
        this.persistentTopics.setServletContext((ServletContext)new MockServletContext());
        this.persistentTopics.setPulsar(this.pulsar);
        ((PersistentTopics)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.persistentTopics)).globalZk();
        ((PersistentTopics)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.persistentTopics)).localZk();
        ((PersistentTopics)Mockito.doReturn((Object)this.pulsar.getConfigurationCache().propertiesCache()).when((Object)this.persistentTopics)).tenantsCache();
        ((PersistentTopics)Mockito.doReturn((Object)this.pulsar.getConfigurationCache().policiesCache()).when((Object)this.persistentTopics)).policiesCache();
        ((PersistentTopics)Mockito.doReturn((Object)false).when((Object)this.persistentTopics)).isRequestHttps();
        ((PersistentTopics)Mockito.doReturn(null).when((Object)this.persistentTopics)).originalPrincipal();
        ((PersistentTopics)Mockito.doReturn((Object)"test").when((Object)this.persistentTopics)).clientAppId();
        ((PersistentTopics)Mockito.doReturn((Object)"persistent").when((Object)this.persistentTopics)).domain();
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant(this.testTenant);
        ((PersistentTopics)Mockito.doReturn((Object)Mockito.mock(AuthenticationDataHttps.class)).when((Object)this.persistentTopics)).clientAuthData();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testGetLastMessageId() throws Exception {
        try {
            this.persistentTopics.getLastMessageId("my-tenant", "my-namespace", "my-topic", true);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Topic not found", (String)e.getMessage());
        }
        String key = "legendtkl";
        String topicName = "persistent://prop/ns-abc/my-topic";
        String messagePredicate = "my-message-" + key + "-";
        int numberOfMessages = 30;
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/my-topic").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = 0; i < 30; ++i) {
            String message = messagePredicate + i;
            producer.send((Object)message.getBytes());
        }
        MessageId id = this.persistentTopics.getLastMessageId("prop", "ns-abc", "my-topic", true);
        System.out.println(id.toString());
        Assert.assertTrue((((MessageIdImpl)id).getLedgerId() >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)29L, (long)((MessageIdImpl)id).getEntryId());
        for (int i = 0; i < 30; ++i) {
            String message = messagePredicate + i;
            producer.send((Object)message.getBytes());
        }
        id = this.persistentTopics.getLastMessageId("prop", "ns-abc", "my-topic", true);
        System.out.println(id.toString());
        Assert.assertTrue((((MessageIdImpl)id).getLedgerId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)59L, (long)((MessageIdImpl)id).getEntryId());
        System.out.println(id.toString());
    }
}

