/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.ManagedLedgerInfo;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AdminApiOffloadTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setManagedLedgerMaxEntriesPerLedger(10);
        this.conf.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
        super.internalSetup();
        this.admin.clusters().createCluster("test", new ClusterData("http://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT));
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz", tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    private void testOffload(String topicName, String mlName) throws Exception {
        LedgerOffloader offloader = (LedgerOffloader)Mockito.mock(LedgerOffloader.class);
        Mockito.when((Object)offloader.getOffloadDriverName()).thenReturn((Object)"mock");
        ((PulsarService)Mockito.doReturn((Object)offloader).when((Object)this.pulsar)).getManagedLedgerOffloader();
        CompletableFuture promise = new CompletableFuture();
        ((LedgerOffloader)Mockito.doReturn(promise).when((Object)offloader)).offload((ReadHandle)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        MessageId currentId = MessageId.latest;
        try (Producer p = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).create();){
            for (int i = 0; i < 15; ++i) {
                currentId = p.send((Object)"Foobar".getBytes());
            }
        }
        ManagedLedgerInfo info = this.pulsar.getManagedLedgerFactory().getManagedLedgerInfo(mlName);
        Assert.assertEquals((int)info.ledgers.size(), (int)2);
        Assert.assertEquals((Object)this.admin.topics().offloadStatus((String)topicName).status, (Object)LongRunningProcessStatus.Status.NOT_RUN);
        this.admin.topics().triggerOffload(topicName, currentId);
        Assert.assertEquals((Object)this.admin.topics().offloadStatus((String)topicName).status, (Object)LongRunningProcessStatus.Status.RUNNING);
        try {
            this.admin.topics().triggerOffload(topicName, currentId);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException.ConflictException conflictException) {
            // empty catch block
        }
        promise.completeExceptionally(new Exception("Some random failure"));
        Assert.assertEquals((Object)this.admin.topics().offloadStatus((String)topicName).status, (Object)LongRunningProcessStatus.Status.ERROR);
        Assert.assertTrue((boolean)this.admin.topics().offloadStatus((String)topicName).lastError.contains("Some random failure"));
        ((LedgerOffloader)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)offloader)).offload((ReadHandle)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        this.admin.topics().triggerOffload(topicName, currentId);
        Assert.assertEquals((Object)this.admin.topics().offloadStatus((String)topicName).status, (Object)LongRunningProcessStatus.Status.SUCCESS);
        MessageIdImpl firstUnoffloaded = this.admin.topics().offloadStatus((String)topicName).firstUnoffloadedMessage;
        Assert.assertEquals((long)firstUnoffloaded.getLedgerId(), (long)((ManagedLedgerInfo.LedgerInfo)info.ledgers.get((int)1)).ledgerId);
        Assert.assertEquals((long)firstUnoffloaded.getEntryId(), (long)0L);
        ((LedgerOffloader)Mockito.verify((Object)offloader, (VerificationMode)Mockito.times((int)2))).offload((ReadHandle)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testOffloadV2() throws Exception {
        String topicName = "persistent://prop-xyz/ns1/topic1";
        String mlName = "prop-xyz/ns1/persistent/topic1";
        this.testOffload(topicName, mlName);
    }

    @Test
    public void testOffloadV1() throws Exception {
        String topicName = "persistent://prop-xyz/test/ns1/topic2";
        String mlName = "prop-xyz/test/ns1/persistent/topic2";
        this.testOffload(topicName, mlName);
    }
}

