/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.reflect.AvroAlias;
import org.apache.avro.reflect.AvroDefault;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AdminApiSchemaAutoUpdateTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiSchemaAutoUpdateTest.class);
    private static final Logger LOG = LoggerFactory.getLogger(AdminApiSchemaAutoUpdateTest.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", new ClusterData("http://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT));
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz", tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("prop-xyz/test/ns1");
        this.admin.namespaces().createNamespace("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("prop-xyz/test/ns2");
    }

    @Override
    @AfterMethod
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    private void testAutoUpdateBackward(String namespace, String topicName) throws Exception {
        Assert.assertEquals((Object)this.admin.namespaces().getSchemaAutoUpdateCompatibilityStrategy(namespace), (Object)SchemaAutoUpdateCompatibilityStrategy.Full);
        this.admin.namespaces().setSchemaAutoUpdateCompatibilityStrategy(namespace, SchemaAutoUpdateCompatibilityStrategy.Backward);
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topicName).create();){
            p.send((Object)new V1Data("test1", 1));
        }
        log.info("try with forward compat, should fail");
        try {
            p = this.pulsarClient.newProducer(Schema.AVRO(V3Data.class)).topic(topicName).create();
            var4_5 = null;
            try {
                Assert.fail((String)"Forward compat schema should be rejected");
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var4_5 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IncompatibleSchemaException"));
        }
        log.info("try with backward compat, should succeed");
        p = this.pulsarClient.newProducer(Schema.AVRO(V2Data.class)).topic(topicName).create();
        var4_5 = null;
        try {
            p.send((Object)new V2Data("test2"));
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var4_5 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
    }

    private void testAutoUpdateForward(String namespace, String topicName) throws Exception {
        Assert.assertEquals((Object)this.admin.namespaces().getSchemaAutoUpdateCompatibilityStrategy(namespace), (Object)SchemaAutoUpdateCompatibilityStrategy.Full);
        this.admin.namespaces().setSchemaAutoUpdateCompatibilityStrategy(namespace, SchemaAutoUpdateCompatibilityStrategy.Forward);
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topicName).create();){
            p.send((Object)new V1Data("test1", 1));
        }
        log.info("try with backward compat, should fail");
        try {
            p = this.pulsarClient.newProducer(Schema.AVRO(V2Data.class)).topic(topicName).create();
            var4_5 = null;
            try {
                Assert.fail((String)"Backward compat schema should be rejected");
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var4_5 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IncompatibleSchemaException"));
        }
        log.info("try with forward compat, should succeed");
        p = this.pulsarClient.newProducer(Schema.AVRO(V3Data.class)).topic(topicName).create();
        var4_5 = null;
        try {
            p.send((Object)new V3Data("test2", 1, 2L));
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var4_5 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
    }

    private void testAutoUpdateFull(String namespace, String topicName) throws Exception {
        Assert.assertEquals((Object)this.admin.namespaces().getSchemaAutoUpdateCompatibilityStrategy(namespace), (Object)SchemaAutoUpdateCompatibilityStrategy.Full);
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topicName).create();){
            p.send((Object)new V1Data("test1", 1));
        }
        log.info("try with backward compat only, should fail");
        try {
            p = this.pulsarClient.newProducer(Schema.AVRO(V2Data.class)).topic(topicName).create();
            var4_6 = null;
            try {
                Assert.fail((String)"Backward compat only schema should fail");
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var4_6 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IncompatibleSchemaException"));
        }
        log.info("try with forward compat only, should fail");
        try {
            p = this.pulsarClient.newProducer(Schema.AVRO(V3Data.class)).topic(topicName).create();
            var4_6 = null;
            try {
                Assert.fail((String)"Forward compat only schema should fail");
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var4_6 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IncompatibleSchemaException"));
        }
        log.info("try with fully compat");
        p = this.pulsarClient.newProducer(Schema.AVRO(V4Data.class)).topic(topicName).create();
        var4_6 = null;
        try {
            p.send((Object)new V4Data("test2", 1, 100));
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var4_6 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var4_6.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
    }

    private void testAutoUpdateDisabled(String namespace, String topicName) throws Exception {
        Assert.assertEquals((Object)this.admin.namespaces().getSchemaAutoUpdateCompatibilityStrategy(namespace), (Object)SchemaAutoUpdateCompatibilityStrategy.Full);
        this.admin.namespaces().setSchemaAutoUpdateCompatibilityStrategy(namespace, SchemaAutoUpdateCompatibilityStrategy.AutoUpdateDisabled);
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topicName).create();){
            p.send((Object)new V1Data("test1", 1));
        }
        log.info("try with backward compat only, should fail");
        try {
            p = this.pulsarClient.newProducer(Schema.AVRO(V2Data.class)).topic(topicName).create();
            var4_9 = null;
            try {
                Assert.fail((String)"Backward compat only schema should fail");
            }
            catch (Throwable throwable) {
                var4_9 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var4_9 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var4_9.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IncompatibleSchemaException"));
        }
        log.info("try with forward compat only, should fail");
        try {
            p = this.pulsarClient.newProducer(Schema.AVRO(V3Data.class)).topic(topicName).create();
            var4_9 = null;
            try {
                Assert.fail((String)"Forward compat only schema should fail");
            }
            catch (Throwable throwable) {
                var4_9 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var4_9 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var4_9.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IncompatibleSchemaException"));
        }
        log.info("try with fully compat, should fail");
        try {
            p = this.pulsarClient.newProducer(Schema.AVRO(V4Data.class)).topic(topicName).create();
            var4_9 = null;
            try {
                Assert.fail((String)"Fully compat schema should fail, autoupdate disabled");
            }
            catch (Throwable throwable) {
                var4_9 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var4_9 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var4_9.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IncompatibleSchemaException"));
        }
        log.info("Should still be able to connect with original schema");
        p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topicName).create();
        var4_9 = null;
        try {
            p.send((Object)new V1Data("test2", 2));
        }
        catch (Throwable throwable) {
            var4_9 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var4_9 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var4_9.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
        this.admin.namespaces().setSchemaAutoUpdateCompatibilityStrategy(namespace, SchemaAutoUpdateCompatibilityStrategy.Full);
        for (int i = 0; i < 100; ++i) {
            Topic t = (Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topicName).get()).get();
            Field strategy = t.getClass().getSuperclass().getDeclaredField("schemaCompatibilityStrategy");
            strategy.setAccessible(true);
            if (strategy.get(t) == SchemaCompatibilityStrategy.FULL) break;
            Thread.sleep(100L);
        }
        log.info("try with fully compat, again");
        p = this.pulsarClient.newProducer(Schema.AVRO(V4Data.class)).topic(topicName).create();
        var4_9 = null;
        try {
            p.send((Object)new V4Data("test2", 1, 100));
        }
        catch (Throwable throwable) {
            var4_9 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var4_9 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var4_9.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
    }

    @Test
    public void testBackwardV2() throws Exception {
        this.testAutoUpdateBackward("prop-xyz/ns1", "persistent://prop-xyz/ns1/backward");
        this.testAutoUpdateBackward("prop-xyz/ns2", "non-persistent://prop-xyz/ns2/backward-np");
    }

    @Test
    public void testForwardV2() throws Exception {
        this.testAutoUpdateForward("prop-xyz/ns1", "persistent://prop-xyz/ns1/forward");
        this.testAutoUpdateForward("prop-xyz/ns2", "non-persistent://prop-xyz/ns2/forward-np");
    }

    @Test
    public void testFullV2() throws Exception {
        this.testAutoUpdateFull("prop-xyz/ns1", "persistent://prop-xyz/ns1/full");
        this.testAutoUpdateFull("prop-xyz/ns2", "non-persistent://prop-xyz/ns2/full-np");
    }

    @Test
    public void testDisabledV2() throws Exception {
        this.testAutoUpdateDisabled("prop-xyz/ns1", "persistent://prop-xyz/ns1/disabled");
        this.testAutoUpdateDisabled("prop-xyz/ns2", "non-persistent://prop-xyz/ns2/disabled-np");
    }

    @Test
    public void testBackwardV1() throws Exception {
        this.testAutoUpdateBackward("prop-xyz/test/ns1", "persistent://prop-xyz/test/ns1/backward");
        this.testAutoUpdateBackward("prop-xyz/test/ns2", "non-persistent://prop-xyz/test/ns2/backward-np");
    }

    @Test
    public void testForwardV1() throws Exception {
        this.testAutoUpdateForward("prop-xyz/test/ns1", "persistent://prop-xyz/test/ns1/forward");
        this.testAutoUpdateForward("prop-xyz/test/ns2", "non-persistent://prop-xyz/test/ns2/forward-np");
    }

    @Test
    public void testFullV1() throws Exception {
        this.testAutoUpdateFull("prop-xyz/test/ns1", "persistent://prop-xyz/test/ns1/full");
        this.testAutoUpdateFull("prop-xyz/test/ns2", "non-persistent://prop-xyz/test/ns2/full-np");
    }

    @Test
    public void testDisabledV1() throws Exception {
        this.testAutoUpdateDisabled("prop-xyz/test/ns1", "persistent://prop-xyz/test/ns1/disabled");
        this.testAutoUpdateDisabled("prop-xyz/test/ns2", "non-persistent://prop-xyz/test/ns2/disabled-np");
    }

    @AvroAlias(space="blah", alias="data")
    static class V4Data {
        String foo;
        int bar;
        @AvroDefault(value="10")
        short blah;

        V4Data(String foo, int bar, short blah) {
            this.foo = foo;
            this.bar = bar;
            this.blah = blah;
        }
    }

    @AvroAlias(space="blah", alias="data")
    static class V3Data {
        String foo;
        int bar;
        long baz;

        V3Data(String foo, int bar, long baz) {
            this.foo = foo;
            this.bar = bar;
            this.baz = baz;
        }
    }

    @AvroAlias(space="blah", alias="data")
    static class V2Data {
        String foo;

        V2Data(String foo) {
            this.foo = foo;
        }
    }

    @AvroAlias(space="blah", alias="data")
    static class V1Data {
        String foo;
        int bar;

        V1Data(String foo, int bar) {
            this.foo = foo;
            this.bar = bar;
        }
    }
}

