/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.admin.AdminApiTest;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AdminApiTest2
extends MockedPulsarServiceBaseTest {
    private AdminApiTest.MockedPulsarService mockPulsarSetup;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        super.internalSetup();
        this.mockPulsarSetup = new AdminApiTest.MockedPulsarService(this.conf);
        this.mockPulsarSetup.setup();
        this.admin.clusters().createCluster("test", new ClusterData("http://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT));
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz", tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod
    public void cleanup() throws Exception {
        super.internalCleanup();
        this.mockPulsarSetup.cleanup();
    }

    @DataProvider(name="topicType")
    public Object[][] topicTypeProvider() {
        return new Object[][]{{TopicDomain.persistent.value()}, {TopicDomain.non_persistent.value()}};
    }

    @DataProvider(name="namespaceNames")
    public Object[][] namespaceNameProvider() {
        return new Object[][]{{"ns1"}, {"global"}};
    }

    @Test
    public void testIncrementPartitionsOfTopic() throws Exception {
        int i;
        String topicName = "increment-partitionedTopic";
        String subName1 = "increment-partitionedTopic-my-sub-1/encode";
        String subName2 = "increment-partitionedTopic-my-sub-2/encode";
        int startPartitions = 4;
        int newPartitions = 8;
        String partitionedTopicName = "persistent://prop-xyz/ns1/increment-partitionedTopic";
        URL pulsarUrl = new URL("http://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT);
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/ns1/increment-partitionedTopic", 4);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/ns1/increment-partitionedTopic").partitions, (int)4);
        PulsarClient client = PulsarClient.builder().serviceUrl(pulsarUrl.toString()).build();
        Consumer consumer1 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-1/encode").subscriptionType(SubscriptionType.Shared).subscribe();
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/ns1/increment-partitionedTopic"), (Collection)Lists.newArrayList((Object[])new String[]{"increment-partitionedTopic-my-sub-1/encode"}));
        Consumer consumer2 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-2/encode").subscriptionType(SubscriptionType.Shared).subscribe();
        Assert.assertEquals((Set)Sets.newHashSet((Iterable)this.admin.topics().getSubscriptions("persistent://prop-xyz/ns1/increment-partitionedTopic")), (Set)Sets.newHashSet((Object[])new String[]{"increment-partitionedTopic-my-sub-1/encode", "increment-partitionedTopic-my-sub-2/encode"}));
        this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/ns1/increment-partitionedTopic", 8);
        this.pulsar.getGlobalZkCache().invalidateAll();
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/ns1/increment-partitionedTopic").partitions, (int)8);
        String newPartitionTopicName = TopicName.get((String)"persistent://prop-xyz/ns1/increment-partitionedTopic").getPartition(5).toString();
        Producer producer = client.newProducer().topic("persistent://prop-xyz/ns1/increment-partitionedTopic").enableBatching(false).messageRoutingMode(MessageRoutingMode.RoundRobinPartition).create();
        int totalMessages = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            String message = "message-" + i2;
            producer.send((Object)message.getBytes());
        }
        consumer2.close();
        consumer2 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-2/encode").subscriptionType(SubscriptionType.Shared).subscribe();
        this.pulsar.getLocalZkCacheService().managedLedgerListCache().clearTree();
        Assert.assertEquals((Set)Sets.newHashSet((Iterable)this.admin.topics().getSubscriptions(newPartitionTopicName)), (Set)Sets.newHashSet((Object[])new String[]{"increment-partitionedTopic-my-sub-1/encode", "increment-partitionedTopic-my-sub-2/encode"}));
        Assert.assertEquals((int)Sets.newHashSet((Iterable)this.admin.topics().getList("prop-xyz/ns1")).size(), (int)8);
        PartitionedTopicStats topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/ns1/increment-partitionedTopic", false);
        Assert.assertEquals(topicStats.subscriptions.keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"increment-partitionedTopic-my-sub-1/encode", "increment-partitionedTopic-my-sub-2/encode"})));
        Assert.assertEquals((int)((SubscriptionStats)topicStats.subscriptions.get((Object)"increment-partitionedTopic-my-sub-2/encode")).consumers.size(), (int)1);
        Assert.assertEquals((long)((SubscriptionStats)topicStats.subscriptions.get((Object)"increment-partitionedTopic-my-sub-2/encode")).msgBacklog, (long)16L);
        Assert.assertEquals((int)topicStats.publishers.size(), (int)1);
        Assert.assertEquals((Object)topicStats.partitions, (Object)Maps.newHashMap());
        topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/ns1/increment-partitionedTopic", true);
        Assert.assertEquals((int)topicStats.metadata.partitions, (int)8);
        HashSet partitionSet = Sets.newHashSet();
        for (i = 0; i < 8; ++i) {
            partitionSet.add("persistent://prop-xyz/ns1/increment-partitionedTopic-partition-" + i);
        }
        Assert.assertEquals(topicStats.partitions.keySet(), (Set)partitionSet);
        for (i = 0; i < 8; ++i) {
            TopicStats partitionStats = (TopicStats)topicStats.partitions.get(TopicName.get((String)"persistent://prop-xyz/ns1/increment-partitionedTopic").getPartition(i).toString());
            Assert.assertEquals((int)partitionStats.publishers.size(), (int)1);
            Assert.assertEquals((int)((SubscriptionStats)partitionStats.subscriptions.get((Object)"increment-partitionedTopic-my-sub-2/encode")).consumers.size(), (int)1);
            Assert.assertEquals((float)((SubscriptionStats)partitionStats.subscriptions.get((Object)"increment-partitionedTopic-my-sub-2/encode")).msgBacklog, (float)2.0f, (float)1.0f);
        }
        producer.close();
        consumer1.close();
        consumer2.close();
        consumer2.close();
    }

    @Test
    public void nonPersistentTopics() throws Exception {
        String topicName = "nonPersistentTopic";
        String persistentTopicName = "non-persistent://prop-xyz/ns1/nonPersistentTopic";
        this.publishMessagesOnTopic("non-persistent://prop-xyz/ns1/nonPersistentTopic", 0, 0);
        URL pulsarUrl = new URL("http://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT);
        PulsarClient client = PulsarClient.builder().serviceUrl(pulsarUrl.toString()).statsInterval(0L, TimeUnit.SECONDS).build();
        Consumer consumer = client.newConsumer().topic(new String[]{"non-persistent://prop-xyz/ns1/nonPersistentTopic"}).subscriptionName("my-sub").subscribe();
        this.publishMessagesOnTopic("non-persistent://prop-xyz/ns1/nonPersistentTopic", 10, 0);
        TopicStats topicStats = this.admin.topics().getStats("non-persistent://prop-xyz/ns1/nonPersistentTopic");
        Assert.assertEquals(topicStats.subscriptions.keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
        Assert.assertEquals((int)((SubscriptionStats)topicStats.subscriptions.get((Object)"my-sub")).consumers.size(), (int)1);
        Assert.assertEquals((int)topicStats.publishers.size(), (int)0);
        PersistentTopicInternalStats internalStats = this.admin.topics().getInternalStats("non-persistent://prop-xyz/ns1/nonPersistentTopic");
        Assert.assertEquals(internalStats.cursors.keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
        consumer.close();
        client.close();
        topicStats = this.admin.topics().getStats("non-persistent://prop-xyz/ns1/nonPersistentTopic");
        Assert.assertTrue((boolean)topicStats.subscriptions.keySet().contains("my-sub"));
        Assert.assertEquals((int)topicStats.publishers.size(), (int)0);
        String partitionedTopicName = "non-persistent://prop-xyz/ns1/paritioned";
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"non-persistent://prop-xyz/ns1/paritioned").partitions, (int)0);
        this.admin.topics().createPartitionedTopic("non-persistent://prop-xyz/ns1/paritioned", 5);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"non-persistent://prop-xyz/ns1/paritioned").partitions, (int)5);
    }

    private void publishMessagesOnTopic(String topicName, int messages, int startIdx) throws Exception {
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = startIdx; i < messages + startIdx; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
    }

    @Test
    public void testSetPersistencepolicies() throws Exception {
        String namespace = "prop-xyz/ns2";
        this.admin.namespaces().createNamespace("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/ns2"), (Object)new PersistencePolicies(1, 1, 1, 0.0));
        this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(3, 3, 3, 10.0));
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/ns2"), (Object)new PersistencePolicies(3, 3, 3, 10.0));
        try {
            this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(3, 4, 3, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
        }
        try {
            this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(3, 3, 4, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
        }
        try {
            this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(6, 3, 1, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
        }
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/ns2"), (Object)new PersistencePolicies(3, 3, 3, 10.0));
    }

    @Test
    public void testUpdatePersistencePolicyUpdateManagedCursor() throws Exception {
        String namespace = "prop-xyz/ns2";
        String topicName = "persistent://prop-xyz/ns2/topic1";
        this.admin.namespaces().createNamespace("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(3, 3, 3, 50.0));
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/ns2"), (Object)new PersistencePolicies(3, 3, 3, 50.0));
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop-xyz/ns2/topic1").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/ns2/topic1"}).subscriptionName("my-sub").subscribe();
        PersistentTopic topic = (PersistentTopic)this.pulsar.getBrokerService().getOrCreateTopic("persistent://prop-xyz/ns2/topic1").get();
        ManagedLedgerImpl managedLedger = (ManagedLedgerImpl)topic.getManagedLedger();
        ManagedCursorImpl cursor = (ManagedCursorImpl)managedLedger.getCursors().iterator().next();
        double newThrottleRate = 100.0;
        int newEnsembleSize = 5;
        this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(5, 3, 3, 100.0));
        AdminApiTest2.retryStrategically(test -> managedLedger.getConfig().getEnsembleSize() == 5 && cursor.getThrottleMarkDelete() != 100.0, 5, 200L);
        Assert.assertEquals((Object)cursor.getThrottleMarkDelete(), (Object)100.0);
        producer.close();
        consumer.close();
    }

    @Test(dataProvider="topicType")
    public void testUnloadTopic(String topicType) throws Exception {
        String namespace = "prop-xyz/ns2";
        String topicName = topicType + "://" + "prop-xyz/ns2" + "/topic1";
        this.admin.namespaces().createNamespace("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        producer.close();
        Topic topic = (Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topicName).join()).get();
        boolean isPersistentTopic = topic instanceof PersistentTopic;
        this.unloadTopic(topicName, isPersistentTopic);
        Assert.assertFalse((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        this.pulsarClient.newProducer().topic(topicName).create();
        topic = (Topic)this.pulsar.getBrokerService().getTopicReference(topicName).get();
        Assert.assertNotNull((Object)topic);
        this.unloadTopic(topicName, isPersistentTopic);
        for (int i = 0; i < 5; ++i) {
            if (this.pulsar.getBrokerService().getTopicReference(topicName).isPresent() && i == 4) continue;
            Thread.sleep(200L);
        }
        topic = (Topic)this.pulsar.getBrokerService().getTopicReference(topicName).get();
        Assert.assertNotNull((Object)topic);
    }

    private void unloadTopic(String topicName, boolean isPersistentTopic) throws Exception {
        this.admin.topics().unload(topicName);
    }

    @Test(dataProvider="namespaceNames", timeOut=10000L)
    public void testResetCursorOnPosition(String namespaceName) throws Exception {
        String topicName = "persistent://prop-xyz/use/" + namespaceName + "/resetPosition";
        int totalProducedMessages = 50;
        this.admin.namespaces().setRetention("prop-xyz/ns1", new RetentionPolicies(10, 10));
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
        this.publishMessagesOnPersistentTopic(topicName, 50, 0);
        List messages = this.admin.topics().peekMessages(topicName, "my-sub", 10);
        Assert.assertEquals((int)messages.size(), (int)10);
        Message message = null;
        MessageIdImpl resetMessageId = null;
        int resetPositionId = 10;
        for (int i = 0; i < 20; ++i) {
            message = consumer.receive(1, TimeUnit.SECONDS);
            consumer.acknowledge(message);
            if (i != resetPositionId) continue;
            resetMessageId = (MessageIdImpl)message.getMessageId();
        }
        consumer.close();
        MessageIdImpl messageId = new MessageIdImpl(resetMessageId.getLedgerId(), resetMessageId.getEntryId(), -1);
        this.admin.topics().resetCursor(topicName, "my-sub", (MessageId)messageId);
        consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        MessageIdImpl msgId2 = (MessageIdImpl)consumer.receive(1, TimeUnit.SECONDS).getMessageId();
        Assert.assertEquals((Object)resetMessageId, (Object)msgId2);
        int receivedAfterReset = 1;
        for (int i = 0; i < 50 && (message = consumer.receive(500, TimeUnit.MILLISECONDS)) != null; ++i) {
            consumer.acknowledge(message);
            ++receivedAfterReset;
        }
        Assert.assertEquals((int)receivedAfterReset, (int)(50 - resetPositionId));
        try {
            this.admin.topics().resetCursor(topicName + "invalid", "my-sub", (MessageId)messageId);
            Assert.fail((String)"It should have failed due to invalid topic name");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.admin.topics().resetCursor(topicName, "invalid-sub", (MessageId)messageId);
            Assert.fail((String)"It should have failed due to invalid subscription name");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            messageId = new MessageIdImpl(0L, 0L, -1);
            this.admin.topics().resetCursor(topicName, "my-sub", (MessageId)messageId);
            Assert.fail((String)"It should have failed due to invalid subscription name");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
        consumer.close();
    }

    private void publishMessagesOnPersistentTopic(String topicName, int messages, int startIdx) throws Exception {
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = startIdx; i < messages + startIdx; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
    }

    @Test
    public void testLoadReportApi() throws Exception {
        this.conf.setLoadManagerClassName(SimpleLoadManagerImpl.class.getName());
        AdminApiTest.MockedPulsarService mockPulsarSetup1 = new AdminApiTest.MockedPulsarService(this.conf);
        mockPulsarSetup1.setup();
        PulsarService simpleLoadManager = mockPulsarSetup1.getPulsar();
        PulsarAdmin simpleLoadManagerAdmin = mockPulsarSetup1.getAdmin();
        Assert.assertNotNull((Object)simpleLoadManagerAdmin.brokerStats().getLoadReport());
        this.conf.setLoadManagerClassName(ModularLoadManagerImpl.class.getName());
        AdminApiTest.MockedPulsarService mockPulsarSetup2 = new AdminApiTest.MockedPulsarService(this.conf);
        mockPulsarSetup2.setup();
        PulsarService modularLoadManager = mockPulsarSetup2.getPulsar();
        PulsarAdmin modularLoadManagerAdmin = mockPulsarSetup2.getAdmin();
        Assert.assertNotNull((Object)modularLoadManagerAdmin.brokerStats().getLoadReport());
        simpleLoadManagerAdmin.close();
        simpleLoadManager.close();
        modularLoadManagerAdmin.close();
        modularLoadManager.close();
        mockPulsarSetup1.cleanup();
        mockPulsarSetup2.cleanup();
    }

    @Test
    public void testPeerCluster() throws Exception {
        this.admin.clusters().createCluster("us-west1", new ClusterData("http://broker.messaging.west1.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("us-west2", new ClusterData("http://broker.messaging.west2.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("us-east1", new ClusterData("http://broker.messaging.east1.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("us-east2", new ClusterData("http://broker.messaging.east2.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2"}));
        Assert.assertNull((Object)this.admin.clusters().getCluster("us-west2").getPeerClusterNames());
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2", "us-east1", "us-west2", "us-east1", "us-west2", "us-east1"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2", "us-east1"}));
        this.admin.clusters().updatePeerClusterNames("us-west1", null);
        Assert.assertNull((Object)this.admin.clusters().getCluster("us-west1").getPeerClusterNames());
        try {
            this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"invalid-cluster"})));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
        try {
            this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west1"})));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
    }

    @Test
    public void testReplicationPeerCluster() throws Exception {
        this.admin.clusters().createCluster("us-west1", new ClusterData("http://broker.messaging.west1.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("us-west2", new ClusterData("http://broker.messaging.west2.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("us-west3", new ClusterData("http://broker.messaging.west2.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("us-west4", new ClusterData("http://broker.messaging.west2.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("us-east1", new ClusterData("http://broker.messaging.east1.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("us-east2", new ClusterData("http://broker.messaging.east2.example.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("global", new ClusterData());
        String property = "peer-prop";
        HashSet allowedClusters = Sets.newHashSet((Object[])new String[]{"us-west1", "us-west2", "us-west3", "us-west4", "us-east1", "us-east2"});
        TenantInfo propConfig = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"test"}), (Set)allowedClusters);
        this.admin.tenants().createTenant("peer-prop", propConfig);
        String namespace = "peer-prop/global/conflictPeer";
        this.admin.namespaces().createNamespace("peer-prop/global/conflictPeer");
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2", "us-west3"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2", "us-west3"}));
        HashSet clusterIds = Sets.newHashSet((Object[])new String[]{"us-east1", "us-east2"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west2", "us-west3", "us-west1"});
        try {
            this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
            Assert.fail((String)"Peer-cluster can't coexist in replication cluster list");
        }
        catch (PulsarAdminException.ConflictException conflictException) {
            // empty catch block
        }
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west2", "us-west3"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west1", "us-west4"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
    }

    @Test
    public void clusterFailureDomain() throws PulsarAdminException {
        String cluster = this.pulsar.getConfiguration().getClusterName();
        FailureDomain domain = new FailureDomain();
        domain.setBrokers((Set)Sets.newHashSet((Object[])new String[]{"b1", "b2", "b3"}));
        this.admin.clusters().createFailureDomain(cluster, "domain-1", domain);
        this.admin.clusters().updateFailureDomain(cluster, "domain-1", domain);
        Assert.assertEquals((Object)this.admin.clusters().getFailureDomain(cluster, "domain-1"), (Object)domain);
        Map domains = this.admin.clusters().getFailureDomains(cluster);
        Assert.assertEquals((int)domains.size(), (int)1);
        Assert.assertTrue((boolean)domains.containsKey("domain-1"));
        try {
            this.admin.clusters().createFailureDomain(cluster, "domain-2", domain);
            Assert.fail((String)"should have failed because of brokers are already registered");
        }
        catch (PulsarAdminException.ConflictException conflictException) {
            // empty catch block
        }
        this.admin.clusters().deleteFailureDomain(cluster, "domain-1");
        Assert.assertTrue((boolean)this.admin.clusters().getFailureDomains(cluster).isEmpty());
        this.admin.clusters().createFailureDomain(cluster, "domain-2", domain);
        domains = this.admin.clusters().getFailureDomains(cluster);
        Assert.assertEquals((int)domains.size(), (int)1);
        Assert.assertTrue((boolean)domains.containsKey("domain-2"));
    }

    @Test
    public void namespaceAntiAffinity() throws PulsarAdminException {
        String namespace = "prop-xyz/ns1";
        String antiAffinityGroup = "group";
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/ns1")));
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/ns1", "group");
        Assert.assertEquals((String)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/ns1"), (String)"group");
        this.admin.namespaces().deleteNamespaceAntiAffinityGroup("prop-xyz/ns1");
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/ns1")));
        String ns1 = "prop-xyz/antiAG1";
        String ns2 = "prop-xyz/antiAG2";
        String ns3 = "prop-xyz/antiAG3";
        this.admin.namespaces().createNamespace("prop-xyz/antiAG1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("prop-xyz/antiAG2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("prop-xyz/antiAG3", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/antiAG1", "group");
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/antiAG2", "group");
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/antiAG3", "group");
        HashSet namespaces = new HashSet(this.admin.namespaces().getAntiAffinityNamespaces("prop-xyz", "test", "group"));
        Assert.assertEquals((int)namespaces.size(), (int)3);
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/antiAG1"));
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/antiAG2"));
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/antiAG3"));
        List namespaces2 = this.admin.namespaces().getAntiAffinityNamespaces("prop-xyz", "test", "invalid-group");
        Assert.assertEquals((int)namespaces2.size(), (int)0);
    }

    @Test
    public void testNonPersistentTopics() throws Exception {
        int i;
        String namespace = "prop-xyz/ns2";
        String topicName = "non-persistent://prop-xyz/ns2/topic";
        this.admin.namespaces().createNamespace("prop-xyz/ns2", 20);
        this.admin.namespaces().setNamespaceReplicationClusters("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        int totalTopics = 100;
        HashSet topicNames = Sets.newHashSet();
        for (i = 0; i < totalTopics; ++i) {
            topicNames.add("non-persistent://prop-xyz/ns2/topic" + i);
            Producer producer = this.pulsarClient.newProducer().topic("non-persistent://prop-xyz/ns2/topic" + i).create();
            producer.close();
        }
        for (i = 0; i < totalTopics; ++i) {
            Topic topic = (Topic)this.pulsar.getBrokerService().getTopicReference("non-persistent://prop-xyz/ns2/topic" + i).get();
            Assert.assertNotNull((Object)topic);
        }
        HashSet topicsInNs = Sets.newHashSet((Iterable)this.admin.topics().getList("prop-xyz/ns2"));
        Assert.assertEquals((int)topicsInNs.size(), (int)totalTopics);
        topicsInNs.removeAll(topicNames);
        Assert.assertEquals((int)topicsInNs.size(), (int)0);
    }

    @Test
    public void testPublishConsumerStats() throws Exception {
        String topicName = "statTopic";
        String subscriberName = "statTopic-my-sub-1";
        String topic = "persistent://prop-xyz/ns1/statTopic";
        String producerName = "myProducer";
        URL pulsarUrl = new URL("http://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT);
        PulsarClient client = PulsarClient.builder().serviceUrl(pulsarUrl.toString()).build();
        Consumer consumer = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/statTopic"}).subscriptionName("statTopic-my-sub-1").subscriptionType(SubscriptionType.Shared).subscribe();
        Producer producer = client.newProducer().topic("persistent://prop-xyz/ns1/statTopic").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).producerName("myProducer").create();
        AdminApiTest2.retryStrategically(test -> {
            try {
                TopicStats stats = this.admin.topics().getStats("persistent://prop-xyz/ns1/statTopic");
                return stats.publishers.size() > 0 && stats.subscriptions.get("statTopic-my-sub-1") != null && ((SubscriptionStats)stats.subscriptions.get((Object)"statTopic-my-sub-1")).consumers.size() > 0;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 5, 200L);
        TopicStats topicStats = this.admin.topics().getStats("persistent://prop-xyz/ns1/statTopic");
        Assert.assertEquals((int)topicStats.publishers.size(), (int)1);
        Assert.assertNotNull((Object)((PublisherStats)topicStats.publishers.get(0)).getAddress());
        Assert.assertNotNull((Object)((PublisherStats)topicStats.publishers.get(0)).getClientVersion());
        Assert.assertNotNull((Object)((PublisherStats)topicStats.publishers.get(0)).getConnectedSince());
        Assert.assertNotNull((Object)((PublisherStats)topicStats.publishers.get(0)).getProducerName());
        Assert.assertEquals((String)((PublisherStats)topicStats.publishers.get(0)).getProducerName(), (String)"myProducer");
        SubscriptionStats subscriber = (SubscriptionStats)topicStats.subscriptions.get("statTopic-my-sub-1");
        Assert.assertNotNull((Object)subscriber);
        Assert.assertEquals((int)subscriber.consumers.size(), (int)1);
        ConsumerStats consumerStats = (ConsumerStats)subscriber.consumers.get(0);
        Assert.assertNotNull((Object)consumerStats.getAddress());
        Assert.assertNotNull((Object)consumerStats.getClientVersion());
        Assert.assertNotNull((Object)consumerStats.getConnectedSince());
        producer.close();
        consumer.close();
    }

    @Test
    public void testTenantNameWithUnderscore() throws Exception {
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop_xyz", tenantInfo);
        this.admin.namespaces().createNamespace("prop_xyz/my-namespace", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String topic = "persistent://prop_xyz/use/my-namespace/my-topic";
        Producer producer = this.pulsarClient.newProducer().topic(topic).create();
        TopicStats stats = this.admin.topics().getStats(topic);
        Assert.assertEquals((int)stats.publishers.size(), (int)1);
        producer.close();
    }

    @Test
    public void testTenantNameWithInvalidCharacters() throws Exception {
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        try {
            this.admin.tenants().createTenant("prop xyz", tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            this.admin.tenants().createTenant("prop&xyz", tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void testTenantWithNonexistentClusters() throws Exception {
        Assert.assertFalse((boolean)this.admin.clusters().getClusters().contains("cluster-non-existing"));
        HashSet allowedClusters = Sets.newHashSet((Object[])new String[]{"cluster-non-existing"});
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)allowedClusters);
        try {
            this.admin.tenants().createTenant("test-tenant", tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        Assert.assertFalse((boolean)this.admin.tenants().getTenants().contains("test-tenant"));
        Assert.assertTrue((boolean)this.admin.tenants().getTenants().contains("prop-xyz"));
        try {
            this.admin.tenants().updateTenant("prop-xyz", tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void brokerNamespaceIsolationPolicies() throws Exception {
        String policyName1 = "policy-1";
        String namespaceRegex = "other/use/other.*";
        String cluster = "use";
        String brokerName = this.pulsar.getAdvertisedAddress();
        String brokerAddress = brokerName + ":" + this.pulsar.getConfiguration().getWebServicePort().get();
        NamespaceIsolationData nsPolicyData1 = new NamespaceIsolationData();
        nsPolicyData1.namespaces = new ArrayList();
        nsPolicyData1.namespaces.add(namespaceRegex);
        nsPolicyData1.primary = new ArrayList();
        nsPolicyData1.primary.add(brokerName + ":[0-9]*");
        nsPolicyData1.secondary = new ArrayList();
        nsPolicyData1.secondary.add(brokerName + ".*");
        nsPolicyData1.auto_failover_policy = new AutoFailoverPolicyData();
        nsPolicyData1.auto_failover_policy.policy_type = AutoFailoverPolicyType.min_available;
        nsPolicyData1.auto_failover_policy.parameters = new HashMap();
        nsPolicyData1.auto_failover_policy.parameters.put("min_limit", "1");
        nsPolicyData1.auto_failover_policy.parameters.put("usage_threshold", "100");
        this.admin.clusters().createNamespaceIsolationPolicy(cluster, policyName1, nsPolicyData1);
        List brokerIsolationDataList = this.admin.clusters().getBrokersWithNamespaceIsolationPolicy(cluster);
        Assert.assertEquals((int)brokerIsolationDataList.size(), (int)1);
        Assert.assertEquals((String)((BrokerNamespaceIsolationData)brokerIsolationDataList.get((int)0)).brokerName, (String)brokerAddress);
        Assert.assertEquals((int)((BrokerNamespaceIsolationData)brokerIsolationDataList.get((int)0)).namespaceRegex.size(), (int)1);
        Assert.assertEquals((String)((String)((BrokerNamespaceIsolationData)brokerIsolationDataList.get((int)0)).namespaceRegex.get(0)), (String)namespaceRegex);
        BrokerNamespaceIsolationData brokerIsolationData = this.admin.clusters().getBrokerWithNamespaceIsolationPolicy(cluster, brokerAddress);
        Assert.assertEquals((String)brokerIsolationData.brokerName, (String)brokerAddress);
        Assert.assertEquals((int)brokerIsolationData.namespaceRegex.size(), (int)1);
        Assert.assertEquals((String)((String)brokerIsolationData.namespaceRegex.get(0)), (String)namespaceRegex);
        try {
            this.admin.clusters().getBrokerWithNamespaceIsolationPolicy(cluster, "invalid-broker");
            Assert.fail((String)"should have failed due to invalid broker address");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void clustersList() throws PulsarAdminException {
        String cluster = this.pulsar.getConfiguration().getClusterName();
        this.admin.clusters().createCluster("global", new ClusterData("http://localhost:6650"));
        Assert.assertEquals((Collection)this.admin.clusters().getClusters(), (Collection)Lists.newArrayList((Object[])new String[]{cluster}));
    }

    @Test
    public void testClusterIsReadyBeforeCreateTopic() throws PulsarAdminException {
        String topicName = "partitionedTopic";
        int partitions = 4;
        String persistentPartitionedTopicName = "persistent://prop-xyz/ns2/partitionedTopic";
        String NonPersistentPartitionedTopicName = "non-persistent://prop-xyz/ns2/partitionedTopic";
        this.admin.namespaces().createNamespace("prop-xyz/ns2");
        try {
            this.admin.topics().createPartitionedTopic("persistent://prop-xyz/ns2/partitionedTopic", 4);
            Assert.fail((String)"should have failed due to Namespace does not have any clusters configured");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
        try {
            this.admin.topics().createPartitionedTopic("non-persistent://prop-xyz/ns2/partitionedTopic", 4);
            Assert.fail((String)"should have failed due to Namespace does not have any clusters configured");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateNamespaceWithNoClusters() throws PulsarAdminException {
        String localCluster = this.pulsar.getConfiguration().getClusterName();
        String namespace = "prop-xyz/test-ns-with-no-clusters";
        this.admin.namespaces().createNamespace(namespace);
        Assert.assertEquals((Collection)this.admin.namespaces().getNamespaceReplicationClusters(namespace), Collections.singletonList(localCluster));
    }
}

