/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.util.Codec;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdminResourceTest {
    private static AdminResource mockResource() {
        return new AdminResource(){

            protected String domain() {
                return "persistent";
            }
        };
    }

    @Test
    public void testValidatePartitionedTopicNameSuccess() {
        String tenant = "test-tenant";
        String namespace = "test-namespace";
        String topic = Codec.encode((String)"test-topic");
        AdminResource resource = AdminResourceTest.mockResource();
        resource.validatePartitionedTopicName(tenant, namespace, topic);
    }

    @Test
    public void testValidatePartitionedTopicNameInvalid() {
        String tenant = "test-tenant";
        String namespace = "test-namespace";
        String topic = Codec.encode((String)"test-topic-partition-0");
        AdminResource resource = AdminResourceTest.mockResource();
        try {
            resource.validatePartitionedTopicName(tenant, namespace, topic);
            Assert.fail((String)"Should fail validation on invalid partitioned topic");
        }
        catch (RestException re) {
            Assert.assertEquals((int)Response.Status.PRECONDITION_FAILED.getStatusCode(), (int)re.getResponse().getStatus());
        }
    }
}

