/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URI;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletContext;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.admin.MockServletContext;
import org.apache.pulsar.broker.admin.v1.BrokerStats;
import org.apache.pulsar.broker.admin.v1.Brokers;
import org.apache.pulsar.broker.admin.v1.Clusters;
import org.apache.pulsar.broker.admin.v1.Namespaces;
import org.apache.pulsar.broker.admin.v1.PersistentTopics;
import org.apache.pulsar.broker.admin.v1.Properties;
import org.apache.pulsar.broker.admin.v1.ResourceQuotas;
import org.apache.pulsar.broker.admin.v2.SchemasResource;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class AdminTest
extends MockedPulsarServiceBaseTest {
    private final String configClusterName = "use";
    private ConfigurationCacheService configurationCache;
    private Clusters clusters;
    private Properties properties;
    private Namespaces namespaces;
    private PersistentTopics persistentTopics;
    private Brokers brokers;
    private ResourceQuotas resourceQuotas;
    private BrokerStats brokerStats;
    private SchemasResource schemasResource;
    private Field uriField;
    private Clock mockClock = Clock.fixed(Instant.ofEpochSecond(365248800L), ZoneId.of("-05:00"));

    public AdminTest() {
        this.conf.setClusterName("use");
    }

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        this.configurationCache = this.pulsar.getConfigurationCache();
        this.clusters = (Clusters)Mockito.spy((Object)new Clusters());
        this.clusters.setPulsar(this.pulsar);
        ((Clusters)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.clusters)).globalZk();
        ((Clusters)Mockito.doReturn((Object)this.configurationCache.clustersCache()).when((Object)this.clusters)).clustersCache();
        ((Clusters)Mockito.doReturn((Object)this.configurationCache.clustersListCache()).when((Object)this.clusters)).clustersListCache();
        ((Clusters)Mockito.doReturn((Object)this.configurationCache.namespaceIsolationPoliciesCache()).when((Object)this.clusters)).namespaceIsolationPoliciesCache();
        ((Clusters)Mockito.doReturn((Object)"test").when((Object)this.clusters)).clientAppId();
        ((Clusters)Mockito.doNothing().when((Object)this.clusters)).validateSuperUserAccess();
        this.properties = (Properties)Mockito.spy((Object)new Properties());
        this.properties.setServletContext((ServletContext)new MockServletContext());
        this.properties.setPulsar(this.pulsar);
        ((Properties)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.properties)).globalZk();
        ((Properties)Mockito.doReturn((Object)this.configurationCache.propertiesCache()).when((Object)this.properties)).tenantsCache();
        ((Properties)Mockito.doReturn((Object)"test").when((Object)this.properties)).clientAppId();
        ((Properties)Mockito.doNothing().when((Object)this.properties)).validateSuperUserAccess();
        this.namespaces = (Namespaces)Mockito.spy((Object)new Namespaces());
        this.namespaces.setServletContext((ServletContext)new MockServletContext());
        this.namespaces.setPulsar(this.pulsar);
        ((Namespaces)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.namespaces)).globalZk();
        ((Namespaces)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.namespaces)).localZk();
        ((Namespaces)Mockito.doReturn((Object)this.configurationCache.propertiesCache()).when((Object)this.namespaces)).tenantsCache();
        ((Namespaces)Mockito.doReturn((Object)this.configurationCache.policiesCache()).when((Object)this.namespaces)).policiesCache();
        ((Namespaces)Mockito.doReturn((Object)"test").when((Object)this.namespaces)).clientAppId();
        ((Namespaces)Mockito.doReturn((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"use", "usw", "usc", "global"}))).when((Object)this.namespaces)).clusters();
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant("my-tenant");
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant("other-tenant");
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant("new-property");
        this.brokers = (Brokers)Mockito.spy((Object)new Brokers());
        this.brokers.setServletContext((ServletContext)new MockServletContext());
        this.brokers.setPulsar(this.pulsar);
        ((Brokers)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.brokers)).globalZk();
        ((Brokers)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.brokers)).localZk();
        ((Brokers)Mockito.doReturn((Object)this.configurationCache.clustersListCache()).when((Object)this.brokers)).clustersListCache();
        ((Brokers)Mockito.doReturn((Object)"test").when((Object)this.brokers)).clientAppId();
        ((Brokers)Mockito.doNothing().when((Object)this.brokers)).validateSuperUserAccess();
        this.uriField = PulsarWebResource.class.getDeclaredField("uri");
        this.uriField.setAccessible(true);
        this.persistentTopics = (PersistentTopics)Mockito.spy((Object)new PersistentTopics());
        this.persistentTopics.setServletContext((ServletContext)new MockServletContext());
        this.persistentTopics.setPulsar(this.pulsar);
        ((PersistentTopics)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.persistentTopics)).globalZk();
        ((PersistentTopics)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.persistentTopics)).localZk();
        ((PersistentTopics)Mockito.doReturn((Object)this.configurationCache.propertiesCache()).when((Object)this.persistentTopics)).tenantsCache();
        ((PersistentTopics)Mockito.doReturn((Object)this.configurationCache.policiesCache()).when((Object)this.persistentTopics)).policiesCache();
        ((PersistentTopics)Mockito.doReturn((Object)"test").when((Object)this.persistentTopics)).clientAppId();
        ((PersistentTopics)Mockito.doReturn((Object)"persistent").when((Object)this.persistentTopics)).domain();
        ((PersistentTopics)Mockito.doReturn((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"use", "usw", "usc"}))).when((Object)this.persistentTopics)).clusters();
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant("my-tenant");
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant("other-tenant");
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant("prop-xyz");
        this.resourceQuotas = (ResourceQuotas)Mockito.spy((Object)new ResourceQuotas());
        this.resourceQuotas.setServletContext((ServletContext)new MockServletContext());
        this.resourceQuotas.setPulsar(this.pulsar);
        ((ResourceQuotas)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.resourceQuotas)).globalZk();
        ((ResourceQuotas)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.resourceQuotas)).localZk();
        ((ResourceQuotas)Mockito.doReturn((Object)this.configurationCache.propertiesCache()).when((Object)this.resourceQuotas)).tenantsCache();
        ((ResourceQuotas)Mockito.doReturn((Object)this.configurationCache.policiesCache()).when((Object)this.resourceQuotas)).policiesCache();
        this.brokerStats = (BrokerStats)Mockito.spy((Object)new BrokerStats());
        this.brokerStats.setServletContext((ServletContext)new MockServletContext());
        this.brokerStats.setPulsar(this.pulsar);
        ((BrokerStats)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.brokerStats)).globalZk();
        ((BrokerStats)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.brokerStats)).localZk();
        ((BrokerStats)Mockito.doReturn((Object)this.configurationCache.propertiesCache()).when((Object)this.brokerStats)).tenantsCache();
        ((BrokerStats)Mockito.doReturn((Object)this.configurationCache.policiesCache()).when((Object)this.brokerStats)).policiesCache();
        this.schemasResource = (SchemasResource)Mockito.spy((Object)new SchemasResource(this.mockClock));
        this.schemasResource.setServletContext((ServletContext)new MockServletContext());
        this.schemasResource.setPulsar(this.pulsar);
        ((SchemasResource)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.schemasResource)).globalZk();
        ((SchemasResource)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.schemasResource)).localZk();
        ((SchemasResource)Mockito.doReturn((Object)this.configurationCache.propertiesCache()).when((Object)this.schemasResource)).tenantsCache();
        ((SchemasResource)Mockito.doReturn((Object)this.configurationCache.policiesCache()).when((Object)this.schemasResource)).policiesCache();
    }

    @Override
    @AfterMethod
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    void internalConfiguration() throws Exception {
        InternalConfigurationData expectedData = new InternalConfigurationData(this.pulsar.getConfiguration().getZookeeperServers(), this.pulsar.getConfiguration().getConfigurationStoreServers(), new ClientConfiguration().getZkLedgersRootPath(), (String)this.pulsar.getWorkerConfig().map(wc -> wc.getStateStorageServiceUrl()).orElse(null));
        Assert.assertEquals((Object)this.brokers.getInternalConfigurationData(), (Object)expectedData);
    }

    @Test
    void clusters() throws Exception {
        Assert.assertEquals((Collection)this.clusters.getClusters(), (Collection)Lists.newArrayList());
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.never())).validateSuperUserAccess();
        this.clusters.createCluster("use", new ClusterData("http://broker.messaging.use.example.com"));
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)1))).validateSuperUserAccess();
        this.clusters.clustersListCache().clear();
        Assert.assertEquals((Collection)this.clusters.getClusters(), (Collection)Lists.newArrayList((Object[])new String[]{"use"}));
        try {
            this.clusters.createCluster("use", new ClusterData("http://broker.messaging.use.example.com"));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        try {
            this.clusters.deleteCluster("usc");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        Assert.assertEquals((Object)this.clusters.getCluster("use"), (Object)new ClusterData("http://broker.messaging.use.example.com"));
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)4))).validateSuperUserAccess();
        this.clusters.updateCluster("use", new ClusterData("http://new-broker.messaging.use.example.com"));
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)5))).validateSuperUserAccess();
        Assert.assertEquals((Object)this.clusters.getCluster("use"), (Object)new ClusterData("http://new-broker.messaging.use.example.com"));
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)6))).validateSuperUserAccess();
        try {
            this.clusters.getNamespaceIsolationPolicies("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)404);
        }
        NamespaceIsolationData policyData = new NamespaceIsolationData();
        policyData.namespaces = new ArrayList();
        policyData.namespaces.add("dummy/colo/ns");
        policyData.primary = new ArrayList();
        policyData.primary.add("localhost:" + this.BROKER_WEBSERVICE_PORT);
        policyData.secondary = new ArrayList();
        policyData.auto_failover_policy = new AutoFailoverPolicyData();
        policyData.auto_failover_policy.policy_type = AutoFailoverPolicyType.min_available;
        policyData.auto_failover_policy.parameters = new HashMap();
        policyData.auto_failover_policy.parameters.put("min_limit", "1");
        policyData.auto_failover_policy.parameters.put("usage_threshold", "90");
        this.clusters.setNamespaceIsolationPolicy("use", "policy1", policyData);
        this.clusters.getNamespaceIsolationPolicies("use");
        try {
            this.clusters.deleteCluster("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)412);
        }
        this.clusters.deleteNamespaceIsolationPolicy("use", "policy1");
        Assert.assertTrue((boolean)this.clusters.getNamespaceIsolationPolicies("use").isEmpty());
        this.clusters.deleteCluster("use");
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)13))).validateSuperUserAccess();
        Assert.assertEquals((Collection)this.clusters.getClusters(), (Collection)Lists.newArrayList());
        try {
            this.clusters.getCluster("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)404);
        }
        try {
            this.clusters.updateCluster("use", new ClusterData());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)404);
        }
        try {
            this.clusters.getNamespaceIsolationPolicies("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)404);
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        this.configurationCache.clustersListCache().clear();
        try {
            this.clusters.getClusters();
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.clusters.createCluster("test", new ClusterData("http://broker.messaging.test.example.com"));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.clusters.updateCluster("test", new ClusterData("http://broker.messaging.test.example.com"));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.clusters.getCluster("test");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failAfter(0, KeeperException.Code.SESSIONEXPIRED);
        try {
            this.clusters.deleteCluster("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failAfter(1, KeeperException.Code.SESSIONEXPIRED);
        try {
            this.clusters.deleteCluster("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        try {
            this.clusters.createCluster("bf@", new ClusterData("http://dummy.messaging.example.com"));
            Assert.fail((String)"should have filed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    void properties() throws Exception {
        Assert.assertEquals((Collection)this.properties.getTenants(), (Collection)Lists.newArrayList());
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)1))).validateSuperUserAccess();
        HashSet allowedClusters = Sets.newHashSet();
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)allowedClusters);
        this.properties.createTenant("test-property", tenantInfo);
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)2))).validateSuperUserAccess();
        Assert.assertEquals((Collection)this.properties.getTenants(), (Collection)Lists.newArrayList((Object[])new String[]{"test-property"}));
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)3))).validateSuperUserAccess();
        Assert.assertEquals((Object)this.properties.getTenantAdmin("test-property"), (Object)tenantInfo);
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)4))).validateSuperUserAccess();
        TenantInfo newPropertyAdmin = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "other-role"}), (Set)allowedClusters);
        this.properties.updateTenant("test-property", newPropertyAdmin);
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)5))).validateSuperUserAccess();
        Thread.sleep(100L);
        Assert.assertEquals((Object)this.properties.getTenantAdmin("test-property"), (Object)newPropertyAdmin);
        Assert.assertNotSame((Object)this.properties.getTenantAdmin("test-property"), (Object)tenantInfo);
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)7))).validateSuperUserAccess();
        try {
            this.properties.createTenant("test-property", tenantInfo);
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        try {
            this.properties.getTenantAdmin("non-existing");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.properties.updateTenant("xxx-non-existing", newPropertyAdmin);
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.properties.deleteTenant("non-existing");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.properties.getTenants();
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.properties.getTenantAdmin("my-tenant");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.properties.updateTenant("my-tenant", newPropertyAdmin);
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.properties.createTenant("test", tenantInfo);
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.properties.deleteTenant("my-tenant");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.properties.createTenant("error-property", tenantInfo);
        this.mockZookKeeper.failAfter(2, KeeperException.Code.SESSIONEXPIRED);
        try {
            this.properties.deleteTenant("error-property");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.properties.deleteTenant("test-property");
        this.properties.deleteTenant("error-property");
        Assert.assertEquals((Collection)this.properties.getTenants(), (Collection)Lists.newArrayList());
        this.clusters.createCluster("use", new ClusterData());
        newPropertyAdmin = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "other-role"}), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.properties.createTenant("my-tenant", newPropertyAdmin);
        this.namespaces.createNamespace("my-tenant", "use", "my-namespace", new BundlesData());
        try {
            this.properties.deleteTenant("my-tenant");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            // empty catch block
        }
        try {
            this.properties.createTenant("test&", tenantInfo);
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        TenantInfo nullTenantInfo = new TenantInfo();
        this.properties.createTenant("tenant-config-is-null", null);
        Assert.assertEquals((Object)this.properties.getTenantAdmin("tenant-config-is-null"), (Object)nullTenantInfo);
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, "my-tenant", "use", "my-namespace", false);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(captor.capture());
        Assert.assertEquals((int)((Response)captor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        this.properties.deleteTenant("my-tenant");
        this.properties.deleteTenant("tenant-config-is-null");
    }

    @Test
    void brokers() throws Exception {
        this.clusters.createCluster("use", new ClusterData("http://broker.messaging.use.example.com", "https://broker.messaging.use.example.com:4443"));
        URI requestUri = new URI("http://broker.messaging.use.example.com:" + this.BROKER_WEBSERVICE_PORT + "/admin/brokers/use");
        UriInfo mockUri = (UriInfo)Mockito.mock(UriInfo.class);
        ((UriInfo)Mockito.doReturn((Object)requestUri).when((Object)mockUri)).getRequestUri();
        Field uriField = PulsarWebResource.class.getDeclaredField("uri");
        uriField.setAccessible(true);
        uriField.set(this.brokers, mockUri);
        Set activeBrokers = this.brokers.getActiveBrokers("use");
        Assert.assertEquals((int)activeBrokers.size(), (int)1);
        Assert.assertEquals((Set)activeBrokers, (Set)Sets.newHashSet((Object[])new String[]{this.pulsar.getAdvertisedAddress() + ":" + this.BROKER_WEBSERVICE_PORT}));
    }

    @Test
    void resourceQuotas() throws Exception {
        ResourceQuota quota = this.resourceQuotas.getDefaultResourceQuota();
        Assert.assertNotNull((Object)quota);
        Assert.assertTrue((quota.getBandwidthIn() > 0.0 ? 1 : 0) != 0);
        double defaultBandwidth = 1000.0;
        quota.setBandwidthIn(defaultBandwidth);
        quota.setBandwidthOut(defaultBandwidth);
        this.resourceQuotas.setDefaultResourceQuota(quota);
        Assert.assertEquals((Object)defaultBandwidth, (Object)this.resourceQuotas.getDefaultResourceQuota().getBandwidthIn());
        Assert.assertEquals((Object)defaultBandwidth, (Object)this.resourceQuotas.getDefaultResourceQuota().getBandwidthOut());
        String property = "prop-xyz";
        String cluster = "use";
        String namespace = "ns";
        String bundleRange = "0x00000000_0xffffffff";
        Policies policies = new Policies();
        ((ResourceQuotas)Mockito.doReturn((Object)policies).when((Object)this.resourceQuotas)).getNamespacePolicies(NamespaceName.get((String)property, (String)cluster, (String)namespace));
        ((ResourceQuotas)Mockito.doReturn((Object)"client-id").when((Object)this.resourceQuotas)).clientAppId();
        try {
            this.resourceQuotas.setNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange, quota);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.resourceQuotas.removeNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TenantInfo admin = new TenantInfo();
        admin.getAllowedClusters().add(cluster);
        this.mockZookKeeper.create(PulsarWebResource.path((String[])new String[]{"policies", property}), ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)admin), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        double customizeBandwidth = 3000.0;
        quota.setBandwidthIn(customizeBandwidth);
        quota.setBandwidthOut(customizeBandwidth);
        this.resourceQuotas.setNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange, quota);
        ResourceQuota bundleQuota = this.resourceQuotas.getNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange);
        Assert.assertEquals((Object)quota, (Object)bundleQuota);
        this.resourceQuotas.removeNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange);
        bundleQuota = this.resourceQuotas.getNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange);
        Assert.assertEquals((Object)defaultBandwidth, (Object)bundleQuota.getBandwidthIn());
        Assert.assertEquals((Object)defaultBandwidth, (Object)bundleQuota.getBandwidthOut());
    }

    @Test
    void brokerStats() throws Exception {
        ((BrokerStats)Mockito.doReturn((Object)"client-id").when((Object)this.brokerStats)).clientAppId();
        Collection metrics = this.brokerStats.getMetrics();
        Assert.assertNotNull((Object)metrics);
        LocalBrokerData loadReport = (LocalBrokerData)this.brokerStats.getLoadReport();
        Assert.assertNotNull((Object)loadReport);
        Assert.assertNotNull((Object)loadReport.getCpu());
        Collection mBeans = this.brokerStats.getMBeans();
        Assert.assertFalse((boolean)mBeans.isEmpty());
        AllocatorStats allocatorStats = this.brokerStats.getAllocatorStats("default");
        Assert.assertNotNull((Object)allocatorStats);
        Map bookieOpsStats = this.brokerStats.getPendingBookieOpsStats();
        Assert.assertTrue((boolean)bookieOpsStats.isEmpty());
        StreamingOutput topic = this.brokerStats.getTopics2();
        Assert.assertNotNull((Object)topic);
        try {
            this.brokerStats.getBrokerResourceAvailability("prop", "use", "ns2");
            Assert.fail((String)"should have failed as ModularLoadManager doesn't support it");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    @Test
    void persistentTopics() throws Exception {
        String property = "prop-xyz";
        String cluster = "use";
        String namespace = "ns";
        String topic = "ds1";
        Policies policies = new Policies();
        ((ResourceQuotas)Mockito.doReturn((Object)policies).when((Object)this.resourceQuotas)).getNamespacePolicies(NamespaceName.get((String)"prop-xyz", (String)"use", (String)"ns"));
        ((ResourceQuotas)Mockito.doReturn((Object)"client-id").when((Object)this.resourceQuotas)).clientAppId();
        TenantInfo admin = new TenantInfo();
        admin.getAllowedClusters().add("use");
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.mockZookKeeper, (String)PulsarWebResource.path((String[])new String[]{"policies", "prop-xyz", "use", "ns"}), (byte[])ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)new Policies()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.getList(response, "prop-xyz", "use", "ns");
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).resume((Object)Lists.newArrayList());
        Assert.assertEquals((Collection)this.persistentTopics.getPartitionedTopicList("prop-xyz", "use", "ns"), (Collection)Lists.newArrayList());
        this.persistentTopics.createPartitionedTopic("prop-xyz", "use", "ns", "ds1", 5);
        Assert.assertEquals((Collection)this.persistentTopics.getPartitionedTopicList("prop-xyz", "use", "ns"), (Collection)Lists.newArrayList((Object[])new String[]{String.format("persistent://%s/%s/%s/%s", "prop-xyz", "use", "ns", "ds1")}));
        CountDownLatch notificationLatch = new CountDownLatch(2);
        this.configurationCache.policiesCache().registerListener((path, data, stat) -> notificationLatch.countDown());
        HashSet actions = Sets.newHashSet((Object[])new AuthAction[]{AuthAction.produce});
        String role = "test-role";
        this.persistentTopics.grantPermissionsOnTopic("prop-xyz", "use", "ns", "ds1", "test-role", (Set)actions);
        Map permission = this.persistentTopics.getPermissionsOnTopic("prop-xyz", "use", "ns", "ds1");
        Assert.assertEquals((Set)((Set)permission.get("test-role")), (Set)actions);
        this.persistentTopics.revokePermissionsOnTopic("prop-xyz", "use", "ns", "ds1", "test-role");
        notificationLatch.await();
        permission = this.persistentTopics.getPermissionsOnTopic("prop-xyz", "use", "ns", "ds1");
        Assert.assertTrue((boolean)permission.isEmpty());
    }

    @Test
    public void testRestExceptionMessage() {
        String message = "my-message";
        RestException exception = new RestException(Response.Status.PRECONDITION_FAILED, message);
        Assert.assertEquals((String)exception.getMessage(), (String)message);
    }
}

