/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.pulsar.broker.admin.AdminApiTest;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IncrementPartitionsTest
extends MockedPulsarServiceBaseTest {
    private AdminApiTest.MockedPulsarService mockPulsarSetup;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        super.internalSetup();
        this.mockPulsarSetup = new AdminApiTest.MockedPulsarService(this.conf);
        this.mockPulsarSetup.setup();
        this.admin.clusters().createCluster("use", new ClusterData("http://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT));
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.tenants().createTenant("prop-xyz", tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/use/ns1");
    }

    @Override
    @AfterMethod
    public void cleanup() throws Exception {
        super.internalCleanup();
        this.mockPulsarSetup.cleanup();
    }

    @Test
    public void testIncrementPartitionsOfTopicOnUnusedTopic() throws Exception {
        String partitionedTopicName = "persistent://prop-xyz/use/ns1/test-topic";
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/use/ns1/test-topic", 10);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic").partitions, (int)10);
        this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/use/ns1/test-topic", 20);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic").partitions, (int)20);
    }

    @Test
    public void testIncrementPartitionsOfTopic() throws Exception {
        String partitionedTopicName = "persistent://prop-xyz/use/ns1/test-topic-2";
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/use/ns1/test-topic-2", 10);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic-2").partitions, (int)10);
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/test-topic-2"}).subscriptionName("sub-1").subscribe();
        this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/use/ns1/test-topic-2", 20);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic-2").partitions, (int)20);
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(TopicName.get((String)"persistent://prop-xyz/use/ns1/test-topic-2").getPartition(15).toString()), (Collection)Lists.newArrayList((Object[])new String[]{"sub-1"}));
        consumer.close();
    }
}

