/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.servlet.ServletContext;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.admin.MockServletContext;
import org.apache.pulsar.broker.admin.v1.Namespaces;
import org.apache.pulsar.broker.admin.v1.PersistentTopics;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.namespace.OwnershipCache;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class NamespacesTest
extends MockedPulsarServiceBaseTest {
    private Namespaces namespaces;
    private List<NamespaceName> testLocalNamespaces;
    private List<NamespaceName> testGlobalNamespaces;
    private final String testTenant = "my-tenant";
    private final String testOtherTenant = "other-tenant";
    private final String testLocalCluster = "use";
    private final String testOtherCluster = "usc";
    protected NamespaceService nsSvc;
    protected Field uriField;
    protected UriInfo uriInfo;

    public NamespacesTest() {
        this.conf.setClusterName("use");
    }

    @BeforeClass
    public void initNamespace() throws Exception {
        this.testLocalNamespaces = Lists.newArrayList();
        this.testGlobalNamespaces = Lists.newArrayList();
        this.testLocalNamespaces.add(NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)"test-namespace-1"));
        this.testLocalNamespaces.add(NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)"test-namespace-2"));
        this.testLocalNamespaces.add(NamespaceName.get((String)this.testTenant, (String)this.testOtherCluster, (String)"test-other-namespace-1"));
        this.testLocalNamespaces.add(NamespaceName.get((String)this.testOtherTenant, (String)this.testLocalCluster, (String)"test-namespace-1"));
        this.testGlobalNamespaces.add(NamespaceName.get((String)this.testTenant, (String)"global", (String)"test-global-ns1"));
        this.uriField = PulsarWebResource.class.getDeclaredField("uri");
        this.uriField.setAccessible(true);
        this.uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
    }

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        this.namespaces = (Namespaces)Mockito.spy((Object)new Namespaces());
        this.namespaces.setServletContext((ServletContext)new MockServletContext());
        this.namespaces.setPulsar(this.pulsar);
        ((Namespaces)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.namespaces)).globalZk();
        ((Namespaces)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.namespaces)).localZk();
        ((Namespaces)Mockito.doReturn((Object)this.pulsar.getConfigurationCache().propertiesCache()).when((Object)this.namespaces)).tenantsCache();
        ((Namespaces)Mockito.doReturn((Object)this.pulsar.getConfigurationCache().policiesCache()).when((Object)this.namespaces)).policiesCache();
        ((Namespaces)Mockito.doReturn((Object)false).when((Object)this.namespaces)).isRequestHttps();
        ((Namespaces)Mockito.doReturn((Object)"test").when((Object)this.namespaces)).clientAppId();
        ((Namespaces)Mockito.doReturn(null).when((Object)this.namespaces)).originalPrincipal();
        ((Namespaces)Mockito.doReturn((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"use", "usw", "usc", "global"}))).when((Object)this.namespaces)).clusters();
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant(this.testTenant);
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant("non-existing-tenant");
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant("new-property");
        this.admin.clusters().createCluster("use", new ClusterData("http://broker-use.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("usw", new ClusterData("http://broker-usw.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("usc", new ClusterData("http://broker-usc.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.tenants().createTenant(this.testTenant, new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "usc", "usw"})));
        this.admin.tenants().createTenant(this.testOtherTenant, new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role3", "role4"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "usc", "usw"})));
        this.createTestNamespaces(this.testLocalNamespaces, new BundlesData());
        this.createGlobalTestNamespaces(this.testTenant, this.testGlobalNamespaces.get(0).getLocalName(), new BundlesData());
        ((Namespaces)Mockito.doThrow((Throwable[])new Throwable[]{new RestException(Response.Status.UNAUTHORIZED, "unauthorized")}).when((Object)this.namespaces)).validateAdminAccessForTenant(this.testOtherTenant);
        this.nsSvc = this.pulsar.getNamespaceService();
    }

    @Override
    @AfterMethod
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testCreateNamespaces() throws Exception {
        try {
            this.namespaces.createNamespace(this.testTenant, "other-colo", "my-namespace", new BundlesData());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        ArrayList nsnames = Lists.newArrayList();
        nsnames.add(NamespaceName.get((String)this.testTenant, (String)"use", (String)"create-namespace-1"));
        nsnames.add(NamespaceName.get((String)this.testTenant, (String)"use", (String)"create-namespace-2"));
        nsnames.add(NamespaceName.get((String)this.testTenant, (String)"usc", (String)"create-other-namespace-1"));
        this.createTestNamespaces(nsnames, new BundlesData());
        try {
            this.namespaces.createNamespace(this.testTenant, "use", "create-namespace-1", new BundlesData());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        try {
            this.namespaces.createNamespace("non-existing-tenant", "use", "create-namespace-1", new BundlesData());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        try {
            this.namespaces.createNamespace(this.testTenant, "use", "create-namespace-#", new BundlesData());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.namespaces.createNamespace(this.testTenant, "use", "my-namespace-3", new BundlesData());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNamespaces() throws Exception {
        ArrayList expectedList = Lists.newArrayList((Object[])new String[]{this.testLocalNamespaces.get(0).toString(), this.testLocalNamespaces.get(1).toString()});
        expectedList.sort(null);
        Assert.assertEquals((Collection)this.namespaces.getNamespacesForCluster(this.testTenant, this.testLocalCluster), (Collection)expectedList);
        expectedList = Lists.newArrayList((Object[])new String[]{this.testLocalNamespaces.get(0).toString(), this.testLocalNamespaces.get(1).toString(), this.testLocalNamespaces.get(2).toString(), this.testGlobalNamespaces.get(0).toString()});
        expectedList.sort(null);
        Assert.assertEquals((Collection)this.namespaces.getTenantNamespaces(this.testTenant), (Collection)expectedList);
        try {
            this.namespaces.getTenantNamespaces("non-existing-tenant");
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        try {
            this.namespaces.getNamespacesForCluster(this.testTenant, "other-cluster");
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.namespaces.getTenantNamespaces(this.testTenant);
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.namespaces.getNamespacesForCluster(this.testTenant, this.testLocalCluster);
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    @Test(enabled=false)
    public void testGrantAndRevokePermissions() throws Exception {
        Policies expectedPolicies = new Policies();
        Assert.assertEquals((Object)this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies);
        Assert.assertEquals((Object)this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies.auth_policies.namespace_auth);
        this.namespaces.grantPermissionOnNamespace(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName(), "my-role", EnumSet.of(AuthAction.produce));
        expectedPolicies.auth_policies.namespace_auth.put("my-role", EnumSet.of(AuthAction.produce));
        Assert.assertEquals((Object)this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies);
        Assert.assertEquals((Object)this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies.auth_policies.namespace_auth);
        this.namespaces.grantPermissionOnNamespace(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName(), "other-role", EnumSet.of(AuthAction.consume));
        expectedPolicies.auth_policies.namespace_auth.put("other-role", EnumSet.of(AuthAction.consume));
        Assert.assertEquals((Object)this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies);
        Assert.assertEquals((Object)this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies.auth_policies.namespace_auth);
        this.namespaces.revokePermissionsOnNamespace(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName(), "my-role");
        expectedPolicies.auth_policies.namespace_auth.remove("my-role");
        Assert.assertEquals((Object)this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies);
        Assert.assertEquals((Object)this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies.auth_policies.namespace_auth);
        try {
            this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, "non-existing-namespace-1");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, "non-existing-namespace-1");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.namespaces.grantPermissionOnNamespace(this.testTenant, this.testLocalCluster, "non-existing-namespace-1", "my-role", EnumSet.of(AuthAction.produce));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.namespaces.revokePermissionsOnNamespace(this.testTenant, this.testLocalCluster, "non-existing-namespace-1", "my-role");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        NamespaceName testNs = this.testLocalNamespaces.get(1);
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.namespaces.getPolicies(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.namespaces.getPermissions(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.namespaces.grantPermissionOnNamespace(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), "other-role", EnumSet.of(AuthAction.consume));
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZookKeeper.failNow(KeeperException.Code.BADVERSION);
        try {
            this.namespaces.grantPermissionOnNamespace(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), "other-role", EnumSet.of(AuthAction.consume));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.BADVERSION);
        try {
            this.namespaces.revokePermissionsOnNamespace(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), "other-role");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.namespaces.revokePermissionsOnNamespace(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), "other-role");
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    @Test
    public void testGlobalNamespaceReplicationConfiguration() throws Exception {
        Assert.assertEquals((Set)this.namespaces.getNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName()), (Set)Sets.newHashSet());
        this.namespaces.setNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
        Assert.assertEquals((Collection)this.namespaces.getNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName()), (Collection)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "invalid-cluster"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.FORBIDDEN.getStatusCode());
        }
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "global"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "invalid-cluster"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.FORBIDDEN.getStatusCode());
        }
        this.admin.tenants().updateTenant("my-tenant", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "usc"})));
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.FORBIDDEN.getStatusCode());
        }
        this.mockZookKeeper.setAlwaysFail(KeeperException.Code.SESSIONEXPIRED);
        this.pulsar.getConfigurationCache().policiesCache().invalidate(AdminResource.path((String[])new String[]{"policies", this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName()}));
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        finally {
            this.mockZookKeeper.unsetAlwaysFail();
        }
        this.mockZookKeeper.failNow(KeeperException.Code.BADVERSION);
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        try {
            this.namespaces.getNamespaceReplicationClusters(this.testTenant, "global", "non-existing-ns");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", "non-existing-ns", (List)Lists.newArrayList((Object[])new String[]{"use"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        this.pulsar.getConfigurationCache().policiesCache().clear();
        try {
            this.namespaces.getNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)500);
        }
        try {
            this.namespaces.getNamespaceReplicationClusters(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void testGetBundles() throws Exception {
        BundlesData bundle = new BundlesData((List)Lists.newArrayList((Object[])new String[]{"0x00000000", "0x80000000", "0xffffffff"}));
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, "test-bundled-namespace-1", bundle);
        BundlesData responseData = this.namespaces.getBundlesData("my-tenant", this.testLocalCluster, "test-bundled-namespace-1");
        Assert.assertEquals((Object)responseData, (Object)bundle);
    }

    @Test
    public void testNamespacesApiRedirects() throws Exception {
        this.uriField.set(this.namespaces, this.uriInfo);
        ((Namespaces)Mockito.doReturn((Object)false).when((Object)this.namespaces)).isLeaderBroker();
        URI uri = URI.create("http://localhost:" + this.BROKER_WEBSERVICE_PORT + "/admin/namespace/" + this.testLocalNamespaces.get(2).toString());
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)this.uriInfo)).getRequestUri();
        this.conf.setAuthorizationEnabled(true);
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, this.testTenant, this.testOtherCluster, this.testLocalNamespaces.get(2).getLocalName(), false);
        ArgumentCaptor captor = ArgumentCaptor.forClass(WebApplicationException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)captor.capture());
        Assert.assertEquals((int)((WebApplicationException)((Object)captor.getValue())).getResponse().getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        Assert.assertEquals((String)((WebApplicationException)((Object)captor.getValue())).getResponse().getLocation().toString(), (String)UriBuilder.fromUri((URI)uri).host("broker-usc.com").port(this.BROKER_WEBSERVICE_PORT).toString());
        uri = URI.create("http://localhost:" + this.BROKER_WEBSERVICE_PORT + "/admin/namespace/" + this.testLocalNamespaces.get(2).toString() + "/unload");
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)this.uriInfo)).getRequestUri();
        try {
            this.namespaces.unloadNamespaceBundle(this.testTenant, this.testOtherCluster, this.testLocalNamespaces.get(2).getLocalName(), "0x00000000_0xffffffff", false);
            Assert.fail((String)"Should have raised exception to redirect request");
        }
        catch (WebApplicationException wae) {
            Assert.assertEquals((int)wae.getResponse().getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
            Assert.assertEquals((String)wae.getResponse().getLocation().toString(), (String)UriBuilder.fromUri((URI)uri).host("broker-usc.com").port(this.BROKER_WEBSERVICE_PORT).toString());
        }
        uri = URI.create("http://localhost:" + this.BROKER_WEBSERVICE_PORT + "/admin/namespace/" + this.testGlobalNamespaces.get(0).toString() + "/configversion");
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)this.uriInfo)).getRequestUri();
        ((NamespaceService)Mockito.doReturn(Optional.of(new URL("http://otherhost:" + this.BROKER_WEBSERVICE_PORT))).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<NamespaceName>(){

            public boolean matches(NamespaceName nsname) {
                return nsname.equals(NamespacesTest.this.testGlobalNamespaces.get(0));
            }
        }), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        this.admin.namespaces().setNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).toString(), (Set)Sets.newHashSet((Object[])new String[]{"usw"}));
        uri = URI.create("http://localhost:" + this.BROKER_WEBSERVICE_PORT + "/admin/namespace/" + this.testLocalNamespaces.get(2).toString() + "?authoritative=false");
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)this.uriInfo)).getRequestUri();
        ((Namespaces)Mockito.doReturn((Object)true).when((Object)this.namespaces)).isLeaderBroker();
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, this.testLocalNamespaces.get(2).getTenant(), this.testLocalNamespaces.get(2).getCluster(), this.testLocalNamespaces.get(2).getLocalName(), false);
        captor = ArgumentCaptor.forClass(WebApplicationException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)captor.capture());
        Assert.assertEquals((int)((WebApplicationException)((Object)captor.getValue())).getResponse().getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        Assert.assertEquals((String)((WebApplicationException)((Object)captor.getValue())).getResponse().getLocation().toString(), (String)UriBuilder.fromUri((URI)uri).host("broker-usc.com").port(this.BROKER_WEBSERVICE_PORT).toString());
    }

    @Test
    public void testDeleteNamespaces() throws Exception {
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, this.testTenant, this.testLocalCluster, "non-existing-namespace-1", false);
        ArgumentCaptor errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        NamespaceName testNs = this.testLocalNamespaces.get(1);
        TopicName topicName = TopicName.get((String)testNs.getPersistentTopicName("my-topic"));
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.mockZookKeeper, (String)("/managed-ledgers/" + topicName.getPersistenceNamingEncoding()), (byte[])new byte[0], null, null);
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testNs, false, false, false);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testNs);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false);
        errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        this.mockZookKeeper.delete("/managed-ledgers/" + topicName.getPersistenceNamingEncoding(), -1);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.mockZookKeeper, (String)("/admin/partitioned-topics/" + topicName.getPersistenceNamingEncoding()), (byte[])new byte[0], null, null);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false);
        errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        this.mockZookKeeper.delete("/admin/partitioned-topics/" + topicName.getPersistenceNamingEncoding(), -1);
        testNs = this.testGlobalNamespaces.get(0);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testNs, false, false, false);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testNs);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        testNs = this.testLocalNamespaces.get(0);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testNs, false, false, false);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testNs);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false);
        responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        ArrayList nsList = Lists.newArrayList((Object[])new String[]{this.testLocalNamespaces.get(1).toString(), this.testLocalNamespaces.get(2).toString()});
        nsList.sort(null);
        Assert.assertEquals((Collection)this.namespaces.getTenantNamespaces(this.testTenant), (Collection)nsList);
        testNs = this.testLocalNamespaces.get(1);
        this.pulsar.getLocalZkCacheService().managedLedgerListCache().clearTree();
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testNs, false, false, false);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testNs);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false);
        responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
    }

    @Test
    public void testDeleteNamespaceWithBundles() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        BundlesData bundleData = new BundlesData((List)Lists.newArrayList((Object[])new String[]{"0x00000000", "0x80000000", "0xffffffff"}));
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        final NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        org.apache.pulsar.client.admin.Namespaces namespacesAdmin = (org.apache.pulsar.client.admin.Namespaces)Mockito.mock(org.apache.pulsar.client.admin.Namespaces.class);
        ((PulsarAdmin)Mockito.doReturn((Object)namespacesAdmin).when((Object)this.admin)).namespaces();
        ((NamespaceService)Mockito.doReturn(null).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<NamespaceBundle>(){

            public boolean matches(NamespaceBundle bundle) {
                return bundle.getNamespaceObject().equals((Object)testNs);
            }
        }), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((NamespaceService)Mockito.doReturn((Object)false).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<NamespaceBundle>(){

            public boolean matches(NamespaceBundle bundle) {
                return bundle.getNamespaceObject().equals((Object)testNs);
            }
        }));
        ((NamespaceService)Mockito.doReturn(Optional.of(new NamespaceEphemeralData())).when((Object)this.nsSvc)).getOwner((NamespaceBundle)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<NamespaceBundle>(){

            public boolean matches(NamespaceBundle bundle) {
                return bundle.getNamespaceObject().equals((Object)testNs);
            }
        }));
        CompletableFuture preconditionFailed = new CompletableFuture();
        preconditionFailed.completeExceptionally(new PulsarAdminException.PreconditionFailedException(new ClientErrorException(Response.Status.PRECONDITION_FAILED)));
        ((org.apache.pulsar.client.admin.Namespaces)Mockito.doReturn(preconditionFailed).when((Object)namespacesAdmin)).deleteNamespaceBundleAsync(Mockito.anyString(), Mockito.anyString());
        try {
            this.namespaces.deleteNamespaceBundle("my-tenant", "use", bundledNsLocal, "0x00000000_0x80000000", false);
            Assert.fail((String)"Should have failed");
        }
        catch (RestException re) {
            Assert.assertEquals((int)re.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, "my-tenant", "use", bundledNsLocal, false);
        ArgumentCaptor captor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)captor.capture());
        Assert.assertEquals((int)((RestException)((Object)captor.getValue())).getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        NamespaceBundles nsBundles = this.nsSvc.getNamespaceBundleFactory().getBundles(testNs, bundleData);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)nsBundles.getBundles().get(0), false, true, false);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)nsBundles.getBundles().get(0));
        ((org.apache.pulsar.client.admin.Namespaces)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)namespacesAdmin)).deleteNamespaceBundleAsync("my-tenant/use/" + bundledNsLocal, "0x00000000_0x80000000");
        try {
            this.namespaces.deleteNamespaceBundle("my-tenant", "use", bundledNsLocal, "0x80000000_0xffffffff", false);
            Assert.fail((String)"Should have failed");
        }
        catch (RestException re) {
            Assert.assertEquals((int)re.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, "my-tenant", "use", bundledNsLocal, false);
        captor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)captor.capture());
        Assert.assertEquals((int)((RestException)((Object)captor.getValue())).getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        for (NamespaceBundle bundle : nsBundles.getBundles()) {
            ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)bundle, false, true, false);
            ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)bundle);
        }
        ((org.apache.pulsar.client.admin.Namespaces)Mockito.doNothing().when((Object)namespacesAdmin)).deleteNamespaceBundle(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void testUnloadNamespaces() throws Exception {
        NamespaceName testNs = this.testLocalNamespaces.get(1);
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat(ns -> ns.equals(testNs)), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.argThat(ns -> ns.equals(testNs)));
        NamespaceBundle bundle = this.nsSvc.getNamespaceBundleFactory().getFullBundle(testNs);
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateBundleOwnership(bundle, false, true);
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.unloadNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(captor.capture());
        Assert.assertEquals((int)((Response)captor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
    }

    @Test
    public void testSplitBundles() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        BundlesData bundleData = new BundlesData((List)Lists.newArrayList((Object[])new String[]{"0x00000000", "0xffffffff"}));
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doNothing().when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        this.mockWebUrl(localWebServiceUrl, testNs);
        try {
            this.namespaces.splitNamespaceBundle("my-tenant", "use", bundledNsLocal, "0x00000000_0xffffffff", false, true);
            BundlesData bundlesData = this.namespaces.getBundlesData("my-tenant", "use", bundledNsLocal);
            Assert.assertNotNull((Object)bundlesData);
            Assert.assertEquals((int)bundlesData.boundaries.size(), (int)3);
            Assert.assertEquals((String)((String)bundlesData.boundaries.get(0)), (String)"0x00000000");
            Assert.assertEquals((String)((String)bundlesData.boundaries.get(1)), (String)"0x7fffffff");
            Assert.assertEquals((String)((String)bundlesData.boundaries.get(2)), (String)"0xffffffff");
        }
        catch (RestException re) {
            Assert.assertEquals((int)re.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void testSplitBundleWithUnDividedRange() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        BundlesData bundleData = new BundlesData((List)Lists.newArrayList((Object[])new String[]{"0x00000000", "0x08375b1a", "0x08375b1b", "0xffffffff"}));
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doNothing().when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        this.mockWebUrl(localWebServiceUrl, testNs);
        try {
            this.namespaces.splitNamespaceBundle("my-tenant", "use", bundledNsLocal, "0x08375b1a_0x08375b1b", false, false);
        }
        catch (RestException re) {
            Assert.assertEquals((int)re.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void testUnloadNamespaceWithBundles() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        BundlesData bundleData = new BundlesData((List)Lists.newArrayList((Object[])new String[]{"0x00000000", "0x80000000", "0xffffffff"}));
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat(bundle -> bundle.getNamespaceObject().equals((Object)testNs)), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.argThat(bundle -> bundle.getNamespaceObject().equals((Object)testNs)));
        NamespaceBundles nsBundles = this.nsSvc.getNamespaceBundleFactory().getBundles(testNs, bundleData);
        NamespaceBundle testBundle = (NamespaceBundle)nsBundles.getBundles().get(0);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testBundle, false, true, false);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testBundle);
        ((NamespaceService)Mockito.doNothing().when((Object)this.nsSvc)).unloadNamespaceBundle(testBundle);
        this.namespaces.unloadNamespaceBundle("my-tenant", "use", bundledNsLocal, "0x00000000_0x80000000", false);
        ((NamespaceService)Mockito.verify((Object)this.nsSvc, (VerificationMode)Mockito.times((int)1))).unloadNamespaceBundle(testBundle);
        try {
            this.namespaces.unloadNamespaceBundle("my-tenant", "use", bundledNsLocal, "0x00000000_0x88000000", false);
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    private void createBundledTestNamespaces(String property, String cluster, String namespace, BundlesData bundle) throws Exception {
        this.namespaces.createNamespace(property, cluster, namespace, bundle);
    }

    private void createGlobalTestNamespaces(String property, String namespace, BundlesData bundle) throws Exception {
        this.namespaces.createNamespace(property, "global", namespace, bundle);
    }

    private void createTestNamespaces(List<NamespaceName> nsnames, BundlesData bundle) throws Exception {
        for (NamespaceName nsName : nsnames) {
            this.namespaces.createNamespace(nsName.getTenant(), nsName.getCluster(), nsName.getLocalName(), bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateAdminAccessOnTenant() throws Exception {
        try {
            String property = "prop";
            this.pulsar.getConfiguration().setAuthenticationEnabled(true);
            this.pulsar.getConfiguration().setAuthorizationEnabled(true);
            String path = PulsarWebResource.path((String[])new String[]{"policies", "prop"});
            String data = ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{this.namespaces.clientAppId()}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
            ZkUtils.createFullPathOptimistic((ZooKeeper)this.pulsar.getConfigurationCache().getZooKeeper(), (String)path, (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
            this.namespaces.validateAdminAccessForTenant("prop");
        }
        finally {
            this.pulsar.getConfiguration().setAuthenticationEnabled(false);
            this.pulsar.getConfiguration().setAuthorizationEnabled(false);
        }
    }

    @Test
    public void testValidateNamespaceOwnershipWithBundles() throws Exception {
        try {
            URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
            String bundledNsLocal = "test-bundled-namespace-1";
            BundlesData bundleData = new BundlesData((List)Lists.newArrayList((Object[])new String[]{"0x00000000", "0xffffffff"}));
            this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
            NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
            this.mockWebUrl(localWebServiceUrl, testNs);
            OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
            ((OwnershipCache)Mockito.doNothing().when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
            Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
            ownership.setAccessible(true);
            ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
            this.namespaces.validateNamespaceOwnershipWithBundles(this.testTenant, this.testLocalCluster, bundledNsLocal, false, true, bundleData);
        }
        catch (RestException e) {
            Assert.fail((String)"ValidateNamespaceOwnershipWithBundles failed");
        }
    }

    @Test
    public void testRetention() throws Exception {
        try {
            URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
            String bundledNsLocal = "test-bundled-namespace-1";
            BundlesData bundleData = new BundlesData((List)Lists.newArrayList((Object[])new String[]{"0x00000000", "0xffffffff"}));
            this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
            NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
            this.mockWebUrl(localWebServiceUrl, testNs);
            OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
            ((OwnershipCache)Mockito.doNothing().when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
            Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
            ownership.setAccessible(true);
            ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
            RetentionPolicies retention = new RetentionPolicies(10, 10);
            this.namespaces.setRetention(this.testTenant, this.testLocalCluster, bundledNsLocal, retention);
            RetentionPolicies retention2 = this.namespaces.getRetention(this.testTenant, this.testLocalCluster, bundledNsLocal);
            Assert.assertEquals((Object)retention, (Object)retention2);
        }
        catch (RestException e) {
            Assert.fail((String)"ValidateNamespaceOwnershipWithBundles failed");
        }
    }

    @Test
    public void testRetentionUnauthorized() throws Exception {
        try {
            NamespaceName testNs = this.testLocalNamespaces.get(3);
            RetentionPolicies retention = new RetentionPolicies(10, 10);
            this.namespaces.setRetention(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), retention);
            Assert.fail((String)"Should fail");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode());
        }
    }

    @Test
    public void testPersistence() throws Exception {
        NamespaceName testNs = this.testLocalNamespaces.get(0);
        PersistencePolicies persistence1 = new PersistencePolicies(3, 2, 1, 0.0);
        this.namespaces.setPersistence(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), persistence1);
        PersistencePolicies persistence2 = this.namespaces.getPersistence(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName());
        Assert.assertEquals((Object)persistence2, (Object)persistence1);
    }

    @Test
    public void testPersistenceUnauthorized() throws Exception {
        try {
            NamespaceName testNs = this.testLocalNamespaces.get(3);
            PersistencePolicies persistence = new PersistencePolicies(3, 2, 1, 0.0);
            this.namespaces.setPersistence(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), persistence);
            Assert.fail((String)"Should fail");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode());
        }
    }

    @Test
    public void testValidateTopicOwnership() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        BundlesData bundleData = new BundlesData((List)Lists.newArrayList((Object[])new String[]{"0x00000000", "0xffffffff"}));
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doNothing().when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        TopicName topicName = TopicName.get((String)testNs.getPersistentTopicName("my-topic"));
        PersistentTopics topics = (PersistentTopics)Mockito.spy((Object)new PersistentTopics());
        topics.setServletContext((ServletContext)new MockServletContext());
        topics.setPulsar(this.pulsar);
        ((PersistentTopics)Mockito.doReturn((Object)false).when((Object)topics)).isRequestHttps();
        ((PersistentTopics)Mockito.doReturn((Object)"test").when((Object)topics)).clientAppId();
        ((PersistentTopics)Mockito.doReturn(null).when((Object)topics)).originalPrincipal();
        this.mockWebUrl(localWebServiceUrl, testNs);
        ((PersistentTopics)Mockito.doReturn((Object)"persistent").when((Object)topics)).domain();
        topics.validateTopicName(topicName.getTenant(), topicName.getCluster(), topicName.getNamespacePortion(), topicName.getEncodedLocalName());
        topics.validateAdminOperationOnTopic(false);
    }

    @Test
    public void testIsLeader() throws Exception {
        Assert.assertTrue((boolean)this.namespaces.isLeaderBroker());
    }

    @Test
    public void testDeleteNamespace() throws Exception {
        String namespace = this.testTenant + "/use/deleteNs";
        this.admin.namespaces().createNamespace(namespace, 100);
        Assert.assertEquals((int)this.admin.namespaces().getPolicies((String)namespace).bundles.numBundles, (int)100);
        String topicName = "persistent://" + namespace + "/my-topic";
        TopicName topic = TopicName.get((String)topicName);
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        producer.close();
        NamespaceBundle bundle1 = this.pulsar.getNamespaceService().getBundle(topic);
        this.admin.topics().delete(topicName);
        this.admin.namespaces().deleteNamespace(namespace);
        NamespaceBundle bundle2 = this.pulsar.getNamespaceService().getBundle(topic);
        Assert.assertNotEquals((Object)bundle1.getBundleRange(), (Object)bundle2.getBundleRange());
        Assert.assertEquals((String)"0x00000000_0xffffffff", (String)bundle2.getBundleRange());
    }

    @Test
    public void testSubscribeRate() throws Exception {
        SubscribeRate subscribeRate = new SubscribeRate(1, 5);
        String namespace = "my-tenants/my-namespace";
        this.admin.tenants().createTenant("my-tenants", new TenantInfo((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.namespaces().setSubscribeRate(namespace, subscribeRate);
        Assert.assertEquals((Object)subscribeRate, (Object)this.admin.namespaces().getSubscribeRate(namespace));
        String topicName = "persistent://" + namespace + "/subscribe-rate";
        this.admin.topics().createPartitionedTopic(topicName, 2);
        this.pulsar.getConfiguration().setAuthorizationEnabled(false);
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionType(SubscriptionType.Shared).subscriptionName("subscribe-rate").subscribe();
        Assert.assertTrue((boolean)consumer.isConnected());
        this.pulsarClient.updateServiceUrl(this.lookupUrl.toString());
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)consumer.isConnected());
        Thread.sleep(6000L);
        this.pulsarClient.updateServiceUrl(this.lookupUrl.toString());
        Assert.assertTrue((boolean)consumer.isConnected());
        subscribeRate = new SubscribeRate(0, 10);
        this.admin.namespaces().setSubscribeRate(namespace, subscribeRate);
        this.pulsarClient.updateServiceUrl(this.lookupUrl.toString());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)consumer.isConnected());
        this.pulsar.getConfiguration().setAuthorizationEnabled(true);
        this.admin.topics().deletePartitionedTopic(topicName, true);
        this.admin.namespaces().deleteNamespace(namespace);
        this.admin.tenants().deleteTenant("my-tenants");
    }

    private void mockWebUrl(URL localWebServiceUrl, NamespaceName namespace) throws Exception {
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat(bundle -> bundle.getNamespaceObject().equals((Object)namespace)), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.argThat(bundle -> bundle.getNamespaceObject().equals((Object)namespace)));
    }
}

