/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.pulsar.broker.admin.MockServletContext;
import org.apache.pulsar.broker.admin.v2.NonPersistentTopics;
import org.apache.pulsar.broker.admin.v2.PersistentTopics;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.zookeeper.KeeperException;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PersistentTopicsTest
extends MockedPulsarServiceBaseTest {
    private PersistentTopics persistentTopics;
    private final String testTenant = "my-tenant";
    private final String testLocalCluster = "use";
    private final String testNamespace = "my-namespace";
    protected Field uriField;
    protected UriInfo uriInfo;
    private NonPersistentTopics nonPersistentTopic;

    @BeforeClass
    public void initPersistentTopics() throws Exception {
        this.uriField = PulsarWebResource.class.getDeclaredField("uri");
        this.uriField.setAccessible(true);
        this.uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
    }

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        this.persistentTopics = (PersistentTopics)Mockito.spy((Object)new PersistentTopics());
        this.persistentTopics.setServletContext((ServletContext)new MockServletContext());
        this.persistentTopics.setPulsar(this.pulsar);
        ((PersistentTopics)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.persistentTopics)).globalZk();
        ((PersistentTopics)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.persistentTopics)).localZk();
        ((PersistentTopics)Mockito.doReturn((Object)this.pulsar.getConfigurationCache().propertiesCache()).when((Object)this.persistentTopics)).tenantsCache();
        ((PersistentTopics)Mockito.doReturn((Object)this.pulsar.getConfigurationCache().policiesCache()).when((Object)this.persistentTopics)).policiesCache();
        ((PersistentTopics)Mockito.doReturn((Object)false).when((Object)this.persistentTopics)).isRequestHttps();
        ((PersistentTopics)Mockito.doReturn(null).when((Object)this.persistentTopics)).originalPrincipal();
        ((PersistentTopics)Mockito.doReturn((Object)"test").when((Object)this.persistentTopics)).clientAppId();
        ((PersistentTopics)Mockito.doReturn((Object)TopicDomain.persistent.value()).when((Object)this.persistentTopics)).domain();
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant(this.testTenant);
        ((PersistentTopics)Mockito.doReturn((Object)Mockito.mock(AuthenticationDataHttps.class)).when((Object)this.persistentTopics)).clientAuthData();
        this.nonPersistentTopic = (NonPersistentTopics)Mockito.spy((Object)new NonPersistentTopics());
        this.nonPersistentTopic.setServletContext((ServletContext)new MockServletContext());
        this.nonPersistentTopic.setPulsar(this.pulsar);
        ((NonPersistentTopics)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.nonPersistentTopic)).globalZk();
        ((NonPersistentTopics)Mockito.doReturn((Object)this.mockZookKeeper).when((Object)this.nonPersistentTopic)).localZk();
        ((NonPersistentTopics)Mockito.doReturn((Object)this.pulsar.getConfigurationCache().propertiesCache()).when((Object)this.nonPersistentTopic)).tenantsCache();
        ((NonPersistentTopics)Mockito.doReturn((Object)this.pulsar.getConfigurationCache().policiesCache()).when((Object)this.nonPersistentTopic)).policiesCache();
        ((NonPersistentTopics)Mockito.doReturn((Object)false).when((Object)this.nonPersistentTopic)).isRequestHttps();
        ((NonPersistentTopics)Mockito.doReturn(null).when((Object)this.nonPersistentTopic)).originalPrincipal();
        ((NonPersistentTopics)Mockito.doReturn((Object)"test").when((Object)this.nonPersistentTopic)).clientAppId();
        ((NonPersistentTopics)Mockito.doReturn((Object)TopicDomain.non_persistent.value()).when((Object)this.nonPersistentTopic)).domain();
        ((NonPersistentTopics)Mockito.doNothing().when((Object)this.nonPersistentTopic)).validateAdminAccessForTenant(this.testTenant);
        ((NonPersistentTopics)Mockito.doReturn((Object)Mockito.mock(AuthenticationDataHttps.class)).when((Object)this.nonPersistentTopic)).clientAuthData();
        this.admin.clusters().createCluster("use", new ClusterData("http://broker-use.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.clusters().createCluster("test", new ClusterData("http://broker-use.com:" + this.BROKER_WEBSERVICE_PORT));
        this.admin.tenants().createTenant(this.testTenant, new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "test"})));
        this.admin.namespaces().createNamespace("my-tenant/my-namespace", (Set)Sets.newHashSet((Object[])new String[]{"use", "test"}));
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testGetSubscriptions() {
        String testLocalTopicName = "topic-not-found";
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.getSubscriptions(response, "my-tenant", "my-namespace", testLocalTopicName, true);
        ArgumentCaptor errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        Assert.assertEquals((String)((RestException)((Object)errorCaptor.getValue())).getMessage(), (String)"Topic not found");
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.getSubscriptions(response, "my-tenant", "my-namespace", testLocalTopicName + "-partition-0", true);
        errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        Assert.assertEquals((String)((RestException)((Object)errorCaptor.getValue())).getMessage(), (String)"Partitioned Topic not found: persistent://my-tenant/my-namespace/topic-not-found-partition-0 has zero partitions");
        this.persistentTopics.createPartitionedTopic("my-tenant", "my-namespace", testLocalTopicName, 3);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.getSubscriptions(response, "my-tenant", "my-namespace", testLocalTopicName + "-partition-0", true);
        errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        Assert.assertEquals((String)((RestException)((Object)errorCaptor.getValue())).getMessage(), (String)"Topic partitions were not yet created");
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.createSubscription(response, "my-tenant", "my-namespace", testLocalTopicName, "test", true, (MessageIdImpl)MessageId.earliest, false);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.getSubscriptions(response, "my-tenant", "my-namespace", testLocalTopicName + "-partition-0", true);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Object)Lists.newArrayList((Object[])new String[]{"test"}));
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.deleteSubscription(response, "my-tenant", "my-namespace", testLocalTopicName, "test", true);
        responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.getSubscriptions(response, "my-tenant", "my-namespace", testLocalTopicName + "-partition-0", true);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Object)Lists.newArrayList());
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.deletePartitionedTopic(response, "my-tenant", "my-namespace", testLocalTopicName, true, true);
        responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
    }

    @Test
    public void testNonPartitionedTopics() {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        String nonPartitionTopic = "non-partitioned-topic";
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.createSubscription(response, "my-tenant", "my-namespace", "non-partitioned-topic", "test", true, (MessageIdImpl)MessageId.latest, false);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.getSubscriptions(response, "my-tenant", "my-namespace", "non-partitioned-topic-partition-0", true);
        ArgumentCaptor errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertTrue((boolean)((RestException)((Object)errorCaptor.getValue())).getMessage().contains("zero partitions"));
        String nonPartitionTopic2 = "secondary-non-partitioned-topic";
        this.persistentTopics.createNonPartitionedTopic("my-tenant", "my-namespace", "secondary-non-partitioned-topic", true);
        Assert.assertEquals((int)this.persistentTopics.getPartitionedMetadata((String)"my-tenant", (String)"my-namespace", (String)"non-partitioned-topic", (boolean)true, (boolean)false).partitions, (int)0);
    }

    @Test
    public void testCreateNonPartitionedTopic() {
        String topicName = "standard-topic";
        this.persistentTopics.createNonPartitionedTopic("my-tenant", "my-namespace", "standard-topic", true);
        PartitionedTopicMetadata pMetadata = this.persistentTopics.getPartitionedMetadata("my-tenant", "my-namespace", "standard-topic", true, false);
        Assert.assertEquals((int)pMetadata.partitions, (int)0);
    }

    @Test
    public void testUnloadTopic() {
        String topicName = "standard-topic-to-be-unload";
        this.persistentTopics.createNonPartitionedTopic("my-tenant", "my-namespace", "standard-topic-to-be-unload", true);
        this.persistentTopics.unloadTopic("my-tenant", "my-namespace", "standard-topic-to-be-unload", true);
    }

    @Test(expectedExceptions={RestException.class})
    public void testUnloadTopicShallThrowNotFoundWhenTopicNotExist() {
        try {
            this.persistentTopics.unloadTopic("my-tenant", "my-namespace", "non-existent-topic", true);
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
            throw e;
        }
    }

    @Test
    public void testGetPartitionedTopicsList() throws KeeperException, InterruptedException, PulsarAdminException {
        this.persistentTopics.createPartitionedTopic("my-tenant", "my-namespace", "test-topic1", 3);
        this.nonPersistentTopic.createPartitionedTopic("my-tenant", "my-namespace", "test-topic2", 3);
        List persistentPartitionedTopics = this.persistentTopics.getPartitionedTopicList("my-tenant", "my-namespace");
        Assert.assertEquals((int)persistentPartitionedTopics.size(), (int)1);
        Assert.assertEquals((String)TopicName.get((String)((String)persistentPartitionedTopics.get(0))).getDomain().value(), (String)TopicDomain.persistent.value());
        List nonPersistentPartitionedTopics = this.nonPersistentTopic.getPartitionedTopicList("my-tenant", "my-namespace");
        Assert.assertEquals((int)nonPersistentPartitionedTopics.size(), (int)1);
        Assert.assertEquals((String)TopicName.get((String)((String)nonPersistentPartitionedTopics.get(0))).getDomain().value(), (String)TopicDomain.non_persistent.value());
    }
}

