/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthenticationServiceTest {
    private static final String s_authentication_success = "authenticated";

    @Test(timeOut=10000L)
    public void testAuthentication() throws Exception {
        ServiceConfiguration config = new ServiceConfiguration();
        HashSet providersClassNames = Sets.newHashSet((Object[])new String[]{MockAuthenticationProvider.class.getName()});
        config.setAuthenticationProviders((Set)providersClassNames);
        config.setAuthenticationEnabled(true);
        AuthenticationService service = new AuthenticationService(config);
        String result = service.authenticate(null, "auth");
        Assert.assertEquals((String)result, (String)s_authentication_success);
        service.close();
    }

    @Test(timeOut=10000L)
    public void testAuthenticationHttp() throws Exception {
        ServiceConfiguration config = new ServiceConfiguration();
        HashSet providersClassNames = Sets.newHashSet((Object[])new String[]{MockAuthenticationProvider.class.getName()});
        config.setAuthenticationProviders((Set)providersClassNames);
        config.setAuthenticationEnabled(true);
        AuthenticationService service = new AuthenticationService(config);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"192.168.1.1");
        Mockito.when((Object)request.getRemotePort()).thenReturn((Object)8080);
        Mockito.when((Object)request.getHeader(Mockito.anyString())).thenReturn((Object)"data");
        String result = service.authenticateHttpRequest(request);
        Assert.assertEquals((String)result, (String)s_authentication_success);
        service.close();
    }

    public static class MockAuthenticationProvider
    implements AuthenticationProvider {
        public void close() throws IOException {
        }

        public void initialize(ServiceConfiguration config) throws IOException {
        }

        public String getAuthMethodName() {
            return "auth";
        }

        public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
            return AuthenticationServiceTest.s_authentication_success;
        }
    }
}

