/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.bookkeeper.test.PortManager;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.SameThreadOrderedSafeExecutor;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MockedPulsarServiceBaseTest {
    protected ServiceConfiguration conf;
    protected PulsarService pulsar;
    protected PulsarAdmin admin;
    protected PulsarClient pulsarClient;
    protected URL brokerUrl;
    protected URL brokerUrlTls;
    protected URI lookupUrl;
    protected final int BROKER_WEBSERVICE_PORT = PortManager.nextFreePort();
    protected final int BROKER_WEBSERVICE_PORT_TLS = PortManager.nextFreePort();
    protected final int BROKER_PORT = PortManager.nextFreePort();
    protected final int BROKER_PORT_TLS = PortManager.nextFreePort();
    protected MockZooKeeper mockZookKeeper;
    protected NonClosableMockBookKeeper mockBookKeeper;
    protected boolean isTcpLookup = false;
    protected final String configClusterName = "test";
    private SameThreadOrderedSafeExecutor sameThreadOrderedSafeExecutor;
    private ExecutorService bkExecutor;
    protected ZooKeeperClientFactory mockZooKeeperClientFactory = new ZooKeeperClientFactory(){

        public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
            return CompletableFuture.completedFuture(MockedPulsarServiceBaseTest.this.mockZookKeeper);
        }
    };
    private BookKeeperClientFactory mockBookKeeperClientFactory = new BookKeeperClientFactory(){

        public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties) {
            return MockedPulsarServiceBaseTest.this.mockBookKeeper;
        }

        public void close() {
        }
    };
    private static final Logger log = LoggerFactory.getLogger(MockedPulsarServiceBaseTest.class);

    public MockedPulsarServiceBaseTest() {
        this.resetConfig();
    }

    protected void resetConfig() {
        this.conf = new ServiceConfiguration();
        this.conf.setAdvertisedAddress("localhost");
        this.conf.setBrokerServicePort(Optional.ofNullable(this.BROKER_PORT));
        this.conf.setAdvertisedAddress("localhost");
        this.conf.setWebServicePort(Optional.ofNullable(this.BROKER_WEBSERVICE_PORT));
        this.conf.setClusterName("test");
        this.conf.setAdvertisedAddress("localhost");
        this.conf.setManagedLedgerCacheSizeMB(8);
        this.conf.setActiveConsumerFailoverDelayTimeMillis(0);
        this.conf.setDefaultNumberOfNamespaceBundles(1);
        this.conf.setZookeeperServers("localhost:2181");
        this.conf.setConfigurationStoreServers("localhost:3181");
        this.conf.setAllowAutoTopicCreationType("non-persistent");
    }

    protected final void internalSetup() throws Exception {
        this.init();
        this.lookupUrl = new URI(this.brokerUrl.toString());
        if (this.isTcpLookup) {
            this.lookupUrl = new URI("pulsar://localhost:" + this.BROKER_PORT);
        }
        this.pulsarClient = this.newPulsarClient(this.lookupUrl.toString(), 0);
    }

    protected PulsarClient newPulsarClient(String url, int intervalInSecs) throws PulsarClientException {
        return PulsarClient.builder().serviceUrl(url).statsInterval((long)intervalInSecs, TimeUnit.SECONDS).build();
    }

    protected final void internalSetupForStatsTest() throws Exception {
        this.init();
        String lookupUrl = this.brokerUrl.toString();
        if (this.isTcpLookup) {
            lookupUrl = new URI("pulsar://localhost:" + this.BROKER_PORT).toString();
        }
        this.pulsarClient = this.newPulsarClient(lookupUrl, 1);
    }

    protected final void init() throws Exception {
        this.sameThreadOrderedSafeExecutor = new SameThreadOrderedSafeExecutor();
        this.bkExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("mock-pulsar-bk").setUncaughtExceptionHandler((thread, ex) -> log.info("Uncaught exception", ex)).build());
        this.mockZookKeeper = MockedPulsarServiceBaseTest.createMockZooKeeper();
        this.mockBookKeeper = MockedPulsarServiceBaseTest.createMockBookKeeper((ZooKeeper)this.mockZookKeeper, this.bkExecutor);
        this.startBroker();
        this.brokerUrl = new URL("http://" + this.pulsar.getAdvertisedAddress() + ":" + this.BROKER_WEBSERVICE_PORT);
        this.brokerUrlTls = new URL("https://" + this.pulsar.getAdvertisedAddress() + ":" + this.BROKER_WEBSERVICE_PORT_TLS);
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).build());
    }

    protected final void internalCleanup() throws Exception {
        try {
            if (this.admin != null) {
                this.admin.close();
            }
            if (this.pulsarClient != null) {
                this.pulsarClient.close();
            }
            if (this.pulsar != null) {
                this.pulsar.close();
            }
            if (this.mockBookKeeper != null) {
                this.mockBookKeeper.reallyShutdown();
            }
            if (this.mockZookKeeper != null) {
                this.mockZookKeeper.shutdown();
            }
            if (this.sameThreadOrderedSafeExecutor != null) {
                this.sameThreadOrderedSafeExecutor.shutdown();
            }
            if (this.bkExecutor != null) {
                this.bkExecutor.shutdown();
            }
        }
        catch (Exception e) {
            log.warn("Failed to clean up mocked pulsar service:", (Throwable)e);
            throw e;
        }
    }

    protected abstract void setup() throws Exception;

    protected abstract void cleanup() throws Exception;

    protected void restartBroker() throws Exception {
        this.stopBroker();
        this.startBroker();
    }

    protected void stopBroker() throws Exception {
        this.pulsar.close();
    }

    protected void startBroker() throws Exception {
        this.pulsar = this.startBroker(this.conf);
    }

    protected PulsarService startBroker(ServiceConfiguration conf) throws Exception {
        PulsarService pulsar = (PulsarService)Mockito.spy((Object)new PulsarService(conf));
        this.setupBrokerMocks(pulsar);
        boolean isAuthorizationEnabled = conf.isAuthorizationEnabled();
        conf.setAuthorizationEnabled(true);
        pulsar.start();
        conf.setAuthorizationEnabled(isAuthorizationEnabled);
        Compactor spiedCompactor = (Compactor)Mockito.spy((Object)pulsar.getCompactor());
        ((PulsarService)Mockito.doReturn((Object)spiedCompactor).when((Object)pulsar)).getCompactor();
        return pulsar;
    }

    protected void setupBrokerMocks(PulsarService pulsar) throws Exception {
        ((PulsarService)Mockito.doReturn((Object)this.mockZooKeeperClientFactory).when((Object)pulsar)).getZooKeeperClientFactory();
        ((PulsarService)Mockito.doReturn((Object)this.mockBookKeeperClientFactory).when((Object)pulsar)).newBookKeeperClientFactory();
        Supplier<NamespaceService> namespaceServiceSupplier = () -> (NamespaceService)Mockito.spy((Object)new NamespaceService(pulsar));
        ((PulsarService)Mockito.doReturn(namespaceServiceSupplier).when((Object)pulsar)).getNamespaceServiceProvider();
        ((PulsarService)Mockito.doReturn((Object)((Object)this.sameThreadOrderedSafeExecutor)).when((Object)pulsar)).getOrderedExecutor();
    }

    public static MockZooKeeper createMockZooKeeper() throws Exception {
        MockZooKeeper zk = MockZooKeeper.newInstance((ExecutorService)MoreExecutors.newDirectExecutorService());
        ArrayList dummyAclList = new ArrayList(0);
        ZkUtils.createFullPathOptimistic((ZooKeeper)zk, (String)"/ledgers/available/192.168.1.1:5000", (byte[])"".getBytes(ZookeeperClientFactoryImpl.ENCODING_SCHEME), dummyAclList, (CreateMode)CreateMode.PERSISTENT);
        zk.create("/ledgers/LAYOUT", "1\nflat:1".getBytes(ZookeeperClientFactoryImpl.ENCODING_SCHEME), dummyAclList, CreateMode.PERSISTENT);
        return zk;
    }

    public static NonClosableMockBookKeeper createMockBookKeeper(ZooKeeper zookeeper, ExecutorService executor) throws Exception {
        return (NonClosableMockBookKeeper)((Object)Mockito.spy((Object)((Object)new NonClosableMockBookKeeper(zookeeper, executor))));
    }

    public static void retryStrategically(Predicate<Void> predicate, int retryCount, long intSleepTimeInMillis) throws Exception {
        for (int i = 0; i < retryCount && !predicate.test(null) && i != retryCount - 1; ++i) {
            Thread.sleep(intSleepTimeInMillis + intSleepTimeInMillis * (long)i);
        }
    }

    public static void setFieldValue(Class clazz, Object classObj, String fieldName, Object fieldValue) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(classObj, fieldValue);
    }

    public static class NonClosableMockBookKeeper
    extends PulsarMockBookKeeper {
        public NonClosableMockBookKeeper(ZooKeeper zk, ExecutorService executor) throws Exception {
            super(zk, executor);
        }

        public void close() {
        }

        public void shutdown() {
        }

        public void reallyShutdown() {
            super.shutdown();
        }
    }
}

