/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import com.github.zafarkhaja.semver.Version;
import java.util.TreeSet;
import org.apache.pulsar.broker.BrokerData;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.BrokerFilterBadVersionException;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.impl.BrokerVersionFilter;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrokerVersionFilterTest {
    @Test
    public void testLatestVersion() {
        LoadData loadData = this.initLoadData();
        TreeSet<String> brokers = new TreeSet<String>();
        brokers.add("broker1");
        brokers.add("broker2");
        brokers.add("broker3");
        BrokerVersionFilter filter = new BrokerVersionFilter();
        try {
            Version latestVersion = filter.getLatestVersionNumber(brokers, loadData);
            Assert.assertEquals((int)latestVersion.getMajorVersion(), (int)1);
            Assert.assertEquals((int)latestVersion.getMinorVersion(), (int)2);
            Assert.assertEquals((int)latestVersion.getPatchVersion(), (int)0);
        }
        catch (BrokerFilterBadVersionException bad) {
            Assert.fail((String)bad.getMessage(), (Throwable)bad);
        }
        ServiceConfiguration configuration = new ServiceConfiguration();
        configuration.setPreferLaterVersions(true);
        try {
            filter.filter(brokers, null, loadData, configuration);
            Assert.assertEquals((int)brokers.size(), (int)1);
        }
        catch (BrokerFilterBadVersionException bad) {
            Assert.fail((String)bad.getMessage(), (Throwable)bad);
        }
    }

    private LoadData initLoadData() {
        LocalBrokerData broker1Data = new LocalBrokerData();
        broker1Data.setBrokerVersionString("1.1.0-SNAPSHOT");
        LocalBrokerData broker2Data = new LocalBrokerData();
        broker2Data.setBrokerVersionString("1.1.0-SNAPSHOT");
        LocalBrokerData broker3Data = new LocalBrokerData();
        broker3Data.setBrokerVersionString("1.2.0-SNAPSHOT");
        LoadData loadData = new LoadData();
        loadData.getBrokerData().put("broker1", new BrokerData(broker1Data));
        loadData.getBrokerData().put("broker2", new BrokerData(broker2Data));
        loadData.getBrokerData().put("broker3", new BrokerData(broker3Data));
        return loadData;
    }
}

