/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import org.apache.commons.lang3.SystemUtils;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class LoadReportNetworkLimit
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        this.conf.setLoadBalancerOverrideBrokerNicSpeedGbps(Double.valueOf(5.4));
        super.internalSetup();
    }

    @Override
    @AfterClass
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void checkLoadReportNicSpeed() throws Exception {
        LoadManagerReport report = this.admin.brokerStats().getLoadReport();
        if (SystemUtils.IS_OS_LINUX) {
            Assert.assertEquals((Object)report.getBandwidthIn().limit, (Object)5662310.4);
            Assert.assertEquals((Object)report.getBandwidthOut().limit, (Object)5662310.4);
        } else {
            Assert.assertEquals((Object)report.getBandwidthIn().limit, (Object)-1.0);
            Assert.assertEquals((Object)report.getBandwidthOut().limit, (Object)-1.0);
        }
    }
}

