/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LoadManagerSharedTest {
    @Test
    public void testRemoveMostServicingBrokersForNamespace() throws Exception {
        String namespace = "tenant1/ns1";
        String assignedBundle = namespace + "/0x00000000_0x40000000";
        HashSet candidates = Sets.newHashSet();
        ConcurrentOpenHashMap map = new ConcurrentOpenHashMap();
        LoadManagerShared.removeMostServicingBrokersForNamespace((String)assignedBundle, (Set)candidates, (ConcurrentOpenHashMap)map);
        Assert.assertEquals((int)candidates.size(), (int)0);
        candidates = Sets.newHashSet((Object[])new String[]{"broker1"});
        LoadManagerShared.removeMostServicingBrokersForNamespace((String)assignedBundle, (Set)candidates, (ConcurrentOpenHashMap)map);
        Assert.assertEquals((int)candidates.size(), (int)1);
        Assert.assertTrue((boolean)candidates.contains("broker1"));
        candidates = Sets.newHashSet((Object[])new String[]{"broker1"});
        LoadManagerSharedTest.fillBrokerToNamespaceToBundleMap((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)map, "broker1", namespace, "0x40000000_0x80000000");
        LoadManagerShared.removeMostServicingBrokersForNamespace((String)assignedBundle, (Set)candidates, (ConcurrentOpenHashMap)map);
        Assert.assertEquals((int)candidates.size(), (int)1);
        Assert.assertTrue((boolean)candidates.contains("broker1"));
        candidates = Sets.newHashSet((Object[])new String[]{"broker1", "broker2"});
        LoadManagerShared.removeMostServicingBrokersForNamespace((String)assignedBundle, (Set)candidates, (ConcurrentOpenHashMap)map);
        Assert.assertEquals((int)candidates.size(), (int)1);
        Assert.assertTrue((boolean)candidates.contains("broker2"));
        candidates = Sets.newHashSet((Object[])new String[]{"broker1", "broker2"});
        LoadManagerSharedTest.fillBrokerToNamespaceToBundleMap((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)map, "broker2", namespace, "0x80000000_0xc0000000");
        LoadManagerShared.removeMostServicingBrokersForNamespace((String)assignedBundle, (Set)candidates, (ConcurrentOpenHashMap)map);
        Assert.assertEquals((int)candidates.size(), (int)2);
        Assert.assertTrue((boolean)candidates.contains("broker1"));
        Assert.assertTrue((boolean)candidates.contains("broker2"));
        candidates = Sets.newHashSet((Object[])new String[]{"broker1", "broker2"});
        LoadManagerSharedTest.fillBrokerToNamespaceToBundleMap((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)map, "broker2", namespace, "0xc0000000_0xd0000000");
        LoadManagerShared.removeMostServicingBrokersForNamespace((String)assignedBundle, (Set)candidates, (ConcurrentOpenHashMap)map);
        Assert.assertEquals((int)candidates.size(), (int)1);
        Assert.assertTrue((boolean)candidates.contains("broker1"));
        candidates = Sets.newHashSet((Object[])new String[]{"broker1", "broker2", "broker3"});
        LoadManagerSharedTest.fillBrokerToNamespaceToBundleMap((ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>>)map, "broker3", namespace, "0xd0000000_0xffffffff");
        LoadManagerShared.removeMostServicingBrokersForNamespace((String)assignedBundle, (Set)candidates, (ConcurrentOpenHashMap)map);
        Assert.assertEquals((int)candidates.size(), (int)2);
        Assert.assertTrue((boolean)candidates.contains("broker1"));
        Assert.assertTrue((boolean)candidates.contains("broker3"));
    }

    private static void fillBrokerToNamespaceToBundleMap(ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>> map, String broker, String namespace, String bundle) {
        ((ConcurrentOpenHashSet)((ConcurrentOpenHashMap)map.computeIfAbsent((Object)broker, k -> new ConcurrentOpenHashMap())).computeIfAbsent((Object)namespace, k -> new ConcurrentOpenHashSet())).add((Object)bundle);
    }
}

