/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup.http;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.lookup.NamespaceData;
import org.apache.pulsar.broker.lookup.RedirectData;
import org.apache.pulsar.broker.lookup.v1.TopicLookup;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.zookeeper.ZooKeeperChildrenCache;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HttpTopicLookupv2Test {
    private PulsarService pulsar;
    private NamespaceService ns;
    private AuthorizationService auth;
    private ServiceConfiguration config;
    private ConfigurationCacheService mockConfigCache;
    private ZooKeeperChildrenCache clustersListCache;
    private ZooKeeperDataCache<ClusterData> clustersCache;
    private ZooKeeperDataCache<Policies> policiesCache;
    private Set<String> clusters;

    @BeforeMethod
    public void setUp() throws Exception {
        this.pulsar = (PulsarService)Mockito.mock(PulsarService.class);
        this.ns = (NamespaceService)Mockito.mock(NamespaceService.class);
        this.auth = (AuthorizationService)Mockito.mock(AuthorizationService.class);
        this.mockConfigCache = (ConfigurationCacheService)Mockito.mock(ConfigurationCacheService.class);
        this.clustersListCache = (ZooKeeperChildrenCache)Mockito.mock(ZooKeeperChildrenCache.class);
        this.clustersCache = (ZooKeeperDataCache)Mockito.mock(ZooKeeperDataCache.class);
        this.policiesCache = (ZooKeeperDataCache)Mockito.mock(ZooKeeperDataCache.class);
        this.config = (ServiceConfiguration)Mockito.spy((Object)new ServiceConfiguration());
        this.config.setClusterName("use");
        this.clusters = new TreeSet<String>();
        this.clusters.add("use");
        this.clusters.add("usc");
        this.clusters.add("usw");
        ClusterData useData = new ClusterData("http://broker.messaging.use.example.com:8080");
        ClusterData uscData = new ClusterData("http://broker.messaging.usc.example.com:8080");
        ClusterData uswData = new ClusterData("http://broker.messaging.usw.example.com:8080");
        ((PulsarService)Mockito.doReturn((Object)this.config).when((Object)this.pulsar)).getConfiguration();
        ((PulsarService)Mockito.doReturn((Object)this.mockConfigCache).when((Object)this.pulsar)).getConfigurationCache();
        ((ConfigurationCacheService)Mockito.doReturn((Object)this.clustersListCache).when((Object)this.mockConfigCache)).clustersListCache();
        ((ConfigurationCacheService)Mockito.doReturn(this.clustersCache).when((Object)this.mockConfigCache)).clustersCache();
        ((ConfigurationCacheService)Mockito.doReturn(this.policiesCache).when((Object)this.mockConfigCache)).policiesCache();
        ((ZooKeeperDataCache)Mockito.doReturn(Optional.of(useData)).when(this.clustersCache)).get(AdminResource.path((String[])new String[]{"clusters", "use"}));
        ((ZooKeeperDataCache)Mockito.doReturn(Optional.of(uscData)).when(this.clustersCache)).get(AdminResource.path((String[])new String[]{"clusters", "usc"}));
        ((ZooKeeperDataCache)Mockito.doReturn(Optional.of(uswData)).when(this.clustersCache)).get(AdminResource.path((String[])new String[]{"clusters", "usw"}));
        ((ZooKeeperDataCache)Mockito.doReturn(CompletableFuture.completedFuture(Optional.of(useData))).when(this.clustersCache)).getAsync(AdminResource.path((String[])new String[]{"clusters", "use"}));
        ((ZooKeeperDataCache)Mockito.doReturn(CompletableFuture.completedFuture(Optional.of(uscData))).when(this.clustersCache)).getAsync(AdminResource.path((String[])new String[]{"clusters", "usc"}));
        ((ZooKeeperDataCache)Mockito.doReturn(CompletableFuture.completedFuture(Optional.of(uswData))).when(this.clustersCache)).getAsync(AdminResource.path((String[])new String[]{"clusters", "usw"}));
        ((ZooKeeperChildrenCache)Mockito.doReturn(this.clusters).when((Object)this.clustersListCache)).get();
        ((PulsarService)Mockito.doReturn((Object)this.ns).when((Object)this.pulsar)).getNamespaceService();
        BrokerService brokerService = (BrokerService)Mockito.mock(BrokerService.class);
        ((PulsarService)Mockito.doReturn((Object)brokerService).when((Object)this.pulsar)).getBrokerService();
        ((BrokerService)Mockito.doReturn((Object)this.auth).when((Object)brokerService)).getAuthorizationService();
        ((BrokerService)Mockito.doReturn((Object)new Semaphore(1000)).when((Object)brokerService)).getLookupRequestSemaphore();
    }

    @Test
    public void crossColoLookup() throws Exception {
        TopicLookup destLookup = (TopicLookup)Mockito.spy((Object)new TopicLookup());
        ((TopicLookup)Mockito.doReturn((Object)false).when((Object)destLookup)).isRequestHttps();
        destLookup.setPulsar(this.pulsar);
        ((TopicLookup)Mockito.doReturn((Object)"null").when((Object)destLookup)).clientAppId();
        Field uriField = PulsarWebResource.class.getDeclaredField("uri");
        uriField.setAccessible(true);
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        uriField.set(destLookup, uriInfo);
        URI uri = URI.create("http://localhost:8080/lookup/v2/destination/topic/myprop/usc/ns2/topic1");
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)uriInfo)).getRequestUri();
        ((ServiceConfiguration)Mockito.doReturn((Object)true).when((Object)this.config)).isAuthorizationEnabled();
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        destLookup.lookupTopicAsync(TopicDomain.persistent.value(), "myprop", "usc", "ns2", "topic1", false, asyncResponse);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Throwable.class);
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume((Throwable)arg.capture());
        Assert.assertEquals(((Throwable)arg.getValue()).getClass(), WebApplicationException.class);
        WebApplicationException wae = (WebApplicationException)arg.getValue();
        Assert.assertEquals((int)wae.getResponse().getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
    }

    @Test
    public void testNotEnoughLookupPermits() throws Exception {
        BrokerService brokerService = this.pulsar.getBrokerService();
        ((BrokerService)Mockito.doReturn((Object)new Semaphore(0)).when((Object)brokerService)).getLookupRequestSemaphore();
        TopicLookup destLookup = (TopicLookup)Mockito.spy((Object)new TopicLookup());
        ((TopicLookup)Mockito.doReturn((Object)false).when((Object)destLookup)).isRequestHttps();
        destLookup.setPulsar(this.pulsar);
        ((TopicLookup)Mockito.doReturn((Object)"null").when((Object)destLookup)).clientAppId();
        Field uriField = PulsarWebResource.class.getDeclaredField("uri");
        uriField.setAccessible(true);
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        uriField.set(destLookup, uriInfo);
        URI uri = URI.create("http://localhost:8080/lookup/v2/destination/topic/myprop/usc/ns2/topic1");
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)uriInfo)).getRequestUri();
        ((ServiceConfiguration)Mockito.doReturn((Object)true).when((Object)this.config)).isAuthorizationEnabled();
        AsyncResponse asyncResponse1 = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        destLookup.lookupTopicAsync(TopicDomain.persistent.value(), "myprop", "usc", "ns2", "topic1", false, asyncResponse1);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Throwable.class);
        ((AsyncResponse)Mockito.verify((Object)asyncResponse1)).resume((Throwable)arg.capture());
        Assert.assertEquals(((Throwable)arg.getValue()).getClass(), WebApplicationException.class);
        WebApplicationException wae = (WebApplicationException)arg.getValue();
        Assert.assertEquals((int)wae.getResponse().getStatus(), (int)Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
    }

    @Test
    public void testValidateReplicationSettingsOnNamespace() throws Exception {
        String property = "my-prop";
        String cluster = "global";
        String ns1 = "ns1";
        String ns2 = "ns2";
        Policies policies1 = new Policies();
        ((ZooKeeperDataCache)Mockito.doReturn(Optional.of(policies1)).when(this.policiesCache)).get(AdminResource.path((String[])new String[]{"policies", "my-prop", "global", "ns1"}));
        Policies policies2 = new Policies();
        policies2.replication_clusters = Sets.newHashSet((Object[])new String[]{"invalid-localCluster"});
        ((ZooKeeperDataCache)Mockito.doReturn(Optional.of(policies2)).when(this.policiesCache)).get(AdminResource.path((String[])new String[]{"policies", "my-prop", "global", "ns2"}));
        TopicLookup destLookup = (TopicLookup)Mockito.spy((Object)new TopicLookup());
        ((TopicLookup)Mockito.doReturn((Object)false).when((Object)destLookup)).isRequestHttps();
        destLookup.setPulsar(this.pulsar);
        ((TopicLookup)Mockito.doReturn((Object)"null").when((Object)destLookup)).clientAppId();
        Field uriField = PulsarWebResource.class.getDeclaredField("uri");
        uriField.setAccessible(true);
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        uriField.set(destLookup, uriInfo);
        ((ServiceConfiguration)Mockito.doReturn((Object)false).when((Object)this.config)).isAuthorizationEnabled();
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        destLookup.lookupTopicAsync(TopicDomain.persistent.value(), "my-prop", "global", "ns1", "empty-cluster", false, asyncResponse);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Throwable.class);
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume((Throwable)arg.capture());
        Assert.assertEquals(((Throwable)arg.getValue()).getClass(), RestException.class);
        AsyncResponse asyncResponse2 = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        destLookup.lookupTopicAsync(TopicDomain.persistent.value(), "my-prop", "global", "ns2", "invalid-localCluster", false, asyncResponse2);
        ArgumentCaptor arg2 = ArgumentCaptor.forClass(Throwable.class);
        ((AsyncResponse)Mockito.verify((Object)asyncResponse2)).resume((Throwable)arg2.capture());
        Assert.assertEquals(((Throwable)arg2.getValue()).getClass(), RestException.class);
    }

    @Test
    public void testDataPojo() {
        String url = "localhost:8080";
        NamespaceData data1 = new NamespaceData("localhost:8080");
        Assert.assertEquals((String)data1.getBrokerUrl(), (String)"localhost:8080");
        RedirectData data2 = new RedirectData("localhost:8080");
        Assert.assertEquals((String)data2.getRedirectLookupAddress(), (String)"localhost:8080");
    }
}

