/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.namespace.OwnedBundle;
import org.apache.pulsar.broker.namespace.OwnershipCache;
import org.apache.pulsar.broker.namespace.ServiceUnitZkUtils;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.zookeeper.LocalZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCacheListener;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OwnershipCacheTest {
    private PulsarService pulsar;
    private ServiceConfiguration config;
    private String selfBrokerUrl;
    private ZooKeeperCache zkCache;
    private LocalZooKeeperCacheService localCache;
    private NamespaceBundleFactory bundleFactory;
    private NamespaceService nsService;
    private BrokerService brokerService;
    private OrderedScheduler executor;

    @BeforeMethod
    public void setup() throws Exception {
        int port = 8080;
        this.selfBrokerUrl = "tcp://localhost:8080";
        this.pulsar = (PulsarService)Mockito.mock(PulsarService.class);
        this.config = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        this.executor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).name("test").build();
        this.zkCache = new LocalZooKeeperCache((ZooKeeper)MockZooKeeper.newInstance(), 30, (OrderedExecutor)this.executor);
        this.localCache = (LocalZooKeeperCacheService)Mockito.spy((Object)new LocalZooKeeperCacheService(this.zkCache, null));
        ZooKeeperDataCache poilciesCache = (ZooKeeperDataCache)Mockito.mock(ZooKeeperDataCache.class);
        Mockito.when((Object)this.pulsar.getLocalZkCacheService()).thenReturn((Object)this.localCache);
        Mockito.when((Object)this.localCache.policiesCache()).thenReturn((Object)poilciesCache);
        ((ZooKeeperDataCache)Mockito.doNothing().when((Object)poilciesCache)).registerListener((ZooKeeperCacheListener)Mockito.any());
        this.bundleFactory = new NamespaceBundleFactory(this.pulsar, Hashing.crc32());
        this.nsService = (NamespaceService)Mockito.mock(NamespaceService.class);
        this.brokerService = (BrokerService)Mockito.mock(BrokerService.class);
        ((BrokerService)Mockito.doReturn(CompletableFuture.completedFuture(1)).when((Object)this.brokerService)).unloadServiceUnit((NamespaceBundle)Mockito.any());
        ((PulsarService)Mockito.doReturn((Object)this.zkCache).when((Object)this.pulsar)).getLocalZkCache();
        ((PulsarService)Mockito.doReturn((Object)this.localCache).when((Object)this.pulsar)).getLocalZkCacheService();
        ((PulsarService)Mockito.doReturn((Object)this.config).when((Object)this.pulsar)).getConfiguration();
        ((PulsarService)Mockito.doReturn((Object)this.nsService).when((Object)this.pulsar)).getNamespaceService();
        ((ServiceConfiguration)Mockito.doReturn(Optional.ofNullable(new Integer(8080))).when((Object)this.config)).getBrokerServicePort();
        ((ServiceConfiguration)Mockito.doReturn(Optional.ofNullable(null)).when((Object)this.config)).getWebServicePort();
        ((PulsarService)Mockito.doReturn((Object)this.brokerService).when((Object)this.pulsar)).getBrokerService();
        ((PulsarService)Mockito.doReturn((Object)PulsarService.webAddress((ServiceConfiguration)this.config)).when((Object)this.pulsar)).getSafeWebServiceAddress();
        ((PulsarService)Mockito.doReturn((Object)this.selfBrokerUrl).when((Object)this.pulsar)).getSafeBrokerServiceUrl();
    }

    @AfterMethod
    public void teardown() throws Exception {
        this.executor.shutdown();
    }

    @Test
    public void testConstructor() {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory);
        Assert.assertNotNull((Object)cache);
        Assert.assertNotNull((Object)cache.getOwnedBundles());
    }

    @Test
    public void testDisableOwnership() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory);
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-1"));
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testBundle).get()).isPresent());
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertFalse((boolean)data1.isDisabled());
        cache.disableOwnership(testBundle);
        data1 = (NamespaceEphemeralData)((Optional)cache.getOwnerAsync(testBundle).get()).get();
        Assert.assertTrue((boolean)data1.isDisabled());
    }

    @Test
    public void testGetOrSetOwner() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory);
        NamespaceBundle testFullBundle = this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-2"));
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testFullBundle).get()).isPresent());
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testFullBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        OwnedBundle nsObj = cache.getOwnedBundle(testFullBundle);
        ((NamespaceService)Mockito.doReturn((Object)cache).when((Object)this.nsService)).getOwnershipCache();
        nsObj.handleUnloadRequest(this.pulsar, 5L, TimeUnit.SECONDS);
        Thread.sleep(1000L);
        this.localCache.ownerInfoCache().invalidate(ServiceUnitZkUtils.path((NamespaceBundle)testFullBundle));
        ServiceUnitZkUtils.acquireNameSpace((ZooKeeper)this.zkCache.getZooKeeper(), (String)ServiceUnitZkUtils.path((NamespaceBundle)testFullBundle), (NamespaceEphemeralData)new NamespaceEphemeralData("pulsar://otherhost:8881", "pulsar://otherhost:8884", "http://localhost:8080", "https://localhost:4443", false));
        data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testFullBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)"pulsar://otherhost:8881");
        Assert.assertEquals((String)data1.getNativeUrlTls(), (String)"pulsar://otherhost:8884");
        Assert.assertFalse((boolean)data1.isDisabled());
    }

    @Test
    public void testGetOwner() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory);
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-3"));
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testBundle).get()).isPresent());
        ServiceUnitZkUtils.acquireNameSpace((ZooKeeper)this.zkCache.getZooKeeper(), (String)ServiceUnitZkUtils.path((NamespaceBundle)testBundle), (NamespaceEphemeralData)new NamespaceEphemeralData("pulsar://otherhost:8881", "pulsar://otherhost:8884", "http://otherhost:8080", "https://otherhost:4443", false));
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)"pulsar://otherhost:8881");
        Assert.assertEquals((String)data1.getNativeUrlTls(), (String)"pulsar://otherhost:8884");
        Assert.assertFalse((boolean)data1.isDisabled());
        NamespaceEphemeralData readOnlyData = (NamespaceEphemeralData)((Optional)cache.getOwnerAsync(testBundle).get()).get();
        Assert.assertEquals((Object)data1, (Object)readOnlyData);
        MockZooKeeper mockZk = (MockZooKeeper)this.zkCache.getZooKeeper();
        mockZk.failNow(KeeperException.Code.NONODE);
        Optional res = (Optional)cache.getOwnerAsync(this.bundleFactory.getFullBundle(NamespaceName.get((String)"pulsar/test/ns-none"))).get();
        Assert.assertFalse((boolean)res.isPresent());
    }

    @Test
    public void testGetOwnedServiceUnit() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory);
        NamespaceName testNs = NamespaceName.get((String)"pulsar/test/ns-5");
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(testNs);
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testBundle).get()).isPresent());
        try {
            Preconditions.checkNotNull((Object)cache.getOwnedBundle(testBundle));
            Assert.fail((String)"Should have failed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ServiceUnitZkUtils.acquireNameSpace((ZooKeeper)this.zkCache.getZooKeeper(), (String)ServiceUnitZkUtils.path((NamespaceBundle)testBundle), (NamespaceEphemeralData)new NamespaceEphemeralData("pulsar://otherhost:8881", "pulsar://otherhost:8884", "http://otherhost:8080", "https://otherhost:4443", false));
        try {
            Preconditions.checkNotNull((Object)cache.getOwnedBundle(testBundle));
            Assert.fail((String)"Should have failed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Thread.sleep(500L);
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)"pulsar://otherhost:8881");
        Assert.assertEquals((String)data1.getNativeUrlTls(), (String)"pulsar://otherhost:8884");
        Assert.assertFalse((boolean)data1.isDisabled());
        try {
            Preconditions.checkNotNull((Object)cache.getOwnedBundle(testBundle));
            Assert.fail((String)"Should have failed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.zkCache.getZooKeeper().delete(ServiceUnitZkUtils.path((NamespaceBundle)testBundle), -1);
        this.localCache.ownerInfoCache().invalidate(ServiceUnitZkUtils.path((NamespaceBundle)testBundle));
        data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertNotNull((Object)cache.getOwnedBundle(testBundle));
    }

    @Test
    public void testGetOwnedServiceUnits() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory);
        NamespaceName testNs = NamespaceName.get((String)"pulsar/test/ns-6");
        NamespaceBundle testBundle = this.bundleFactory.getFullBundle(testNs);
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(testBundle).get()).isPresent());
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        ServiceUnitZkUtils.acquireNameSpace((ZooKeeper)this.zkCache.getZooKeeper(), (String)ServiceUnitZkUtils.path((NamespaceBundle)testBundle), (NamespaceEphemeralData)new NamespaceEphemeralData("pulsar://otherhost:8881", "pulsar://otherhost:8884", "http://otherhost:8080", "https://otherhost:4443", false));
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        Thread.sleep(500L);
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)"pulsar://otherhost:8881");
        Assert.assertEquals((String)data1.getNativeUrlTls(), (String)"pulsar://otherhost:8884");
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        this.zkCache.getZooKeeper().delete(ServiceUnitZkUtils.path((NamespaceBundle)testBundle), -1);
        this.localCache.ownerInfoCache().invalidate(ServiceUnitZkUtils.path((NamespaceBundle)testBundle));
        data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(testBundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertEquals((int)cache.getOwnedBundles().size(), (int)1);
    }

    @Test
    public void testRemoveOwnership() throws Exception {
        OwnershipCache cache = new OwnershipCache(this.pulsar, this.bundleFactory);
        NamespaceName testNs = NamespaceName.get((String)"pulsar/test/ns-7");
        NamespaceBundle bundle = this.bundleFactory.getFullBundle(testNs);
        Assert.assertFalse((boolean)((Optional)cache.getOwnerAsync(bundle).get()).isPresent());
        cache.removeOwnership(bundle).get();
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        NamespaceEphemeralData data1 = (NamespaceEphemeralData)cache.tryAcquiringOwnership(bundle).get();
        Assert.assertEquals((String)data1.getNativeUrl(), (String)this.selfBrokerUrl);
        Assert.assertFalse((boolean)data1.isDisabled());
        Assert.assertEquals((int)cache.getOwnedBundles().size(), (int)1);
        cache.removeOwnership(bundle);
        Thread.sleep(500L);
        Assert.assertTrue((boolean)cache.getOwnedBundles().isEmpty());
        Thread.sleep(500L);
        try {
            this.zkCache.getZooKeeper().getData(ServiceUnitZkUtils.path((NamespaceBundle)bundle), null, null);
            Assert.fail((String)"Should have failed");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }
}

