/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.bookkeeper.test.PortManager;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.apache.zookeeper.data.Stat;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AdvertisedAddressTest {
    LocalBookkeeperEnsemble bkEnsemble;
    PulsarService pulsar;
    private final int ZOOKEEPER_PORT = 12759;
    private final int BROKER_WEBSERVICE_PORT = 15782;
    private final int BROKER_SERVICE_PORT = 16650;
    private final String advertisedAddress = "pulsar-usc.example.com";

    @BeforeMethod
    public void setup() throws Exception {
        this.bkEnsemble = new LocalBookkeeperEnsemble(3, 12759, () -> PortManager.nextFreePort());
        this.bkEnsemble.start();
        ServiceConfiguration config = new ServiceConfiguration();
        config.setZookeeperServers("127.0.0.1:12759");
        config.setWebServicePort(Optional.ofNullable(15782));
        config.setClusterName("usc");
        config.setAdvertisedAddress("localhost");
        config.setBrokerServicePort(Optional.ofNullable(16650));
        config.setAdvertisedAddress("pulsar-usc.example.com");
        config.setManagedLedgerMaxEntriesPerLedger(5);
        config.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
        this.pulsar = new PulsarService(config);
        this.pulsar.start();
    }

    @AfterMethod
    public void shutdown() throws Exception {
        this.pulsar.close();
        this.bkEnsemble.stop();
    }

    @Test
    public void testAdvertisedAddress() throws Exception {
        Assert.assertEquals((String)this.pulsar.getAdvertisedAddress(), (String)"pulsar-usc.example.com");
        Assert.assertEquals((String)this.pulsar.getSafeBrokerServiceUrl(), (String)String.format("pulsar://%s:%d", "pulsar-usc.example.com", 16650));
        Assert.assertEquals((String)this.pulsar.getSafeWebServiceAddress(), (String)String.format("http://%s:%d", "pulsar-usc.example.com", 15782));
        String brokerZkPath = String.format("/loadbalance/brokers/%s:%d", this.pulsar.getAdvertisedAddress(), 15782);
        String bkBrokerData = new String(this.bkEnsemble.getZkClient().getData(brokerZkPath, false, new Stat()), StandardCharsets.UTF_8);
        JsonObject jsonBkBrokerData = (JsonObject)new Gson().fromJson(bkBrokerData, JsonObject.class);
        Assert.assertEquals((String)jsonBkBrokerData.get("pulsarServiceUrl").getAsString(), (String)this.pulsar.getSafeBrokerServiceUrl());
        Assert.assertEquals((String)jsonBkBrokerData.get("webServiceUrl").getAsString(), (String)this.pulsar.getSafeWebServiceAddress());
    }
}

