/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.PortManager;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.broker.ManagedLedgerClientFactory;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerImpl;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BrokerBookieIsolationTest {
    private LocalBookkeeperEnsemble bkEnsemble;
    private PulsarService pulsarService;
    private final int ZOOKEEPER_PORT = PortManager.nextFreePort();
    private final int PRIMARY_BROKER_WEBSERVICE_PORT = PortManager.nextFreePort();
    private final int PRIMARY_BROKER_PORT = PortManager.nextFreePort();
    private static final List<ACL> Acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private final ObjectMapper jsonMapper = ObjectMapperFactory.create();
    private static final Logger log = LoggerFactory.getLogger(BrokerBookieIsolationTest.class);

    @BeforeMethod
    protected void setup() throws Exception {
        this.bkEnsemble = new LocalBookkeeperEnsemble(4, this.ZOOKEEPER_PORT, () -> PortManager.nextFreePort());
        this.bkEnsemble.start();
    }

    @AfterMethod
    protected void cleanup() throws Exception {
        if (this.pulsarService != null) {
            this.pulsarService.close();
        }
        this.bkEnsemble.stop();
    }

    @Test
    public void testBookieIsolation() throws Exception {
        String tenant1 = "tenant1";
        String cluster = "use";
        String ns1 = String.format("%s/%s/%s", "tenant1", "use", "ns1");
        String ns2 = String.format("%s/%s/%s", "tenant1", "use", "ns2");
        String ns3 = String.format("%s/%s/%s", "tenant1", "use", "ns3");
        String ns4 = String.format("%s/%s/%s", "tenant1", "use", "ns4");
        int totalPublish = 100;
        String brokerBookkeeperClientIsolationGroups = "default-group";
        String tenantNamespaceIsolationGroups = "tenant1-isolation";
        BookieServer[] bookies = this.bkEnsemble.getBookies();
        ZooKeeper zkClient = this.bkEnsemble.getZkClient();
        HashSet defaultBookies = Sets.newHashSet((Object[])new BookieSocketAddress[]{bookies[0].getLocalAddress(), bookies[1].getLocalAddress()});
        HashSet isolatedBookies = Sets.newHashSet((Object[])new BookieSocketAddress[]{bookies[2].getLocalAddress(), bookies[3].getLocalAddress()});
        this.setDefaultIsolationGroup("default-group", zkClient, defaultBookies);
        this.setDefaultIsolationGroup("tenant1-isolation", zkClient, isolatedBookies);
        ServiceConfiguration config = new ServiceConfiguration();
        config.setLoadManagerClassName(ModularLoadManagerImpl.class.getName());
        config.setClusterName("use");
        config.setWebServicePort(Optional.of(this.PRIMARY_BROKER_WEBSERVICE_PORT));
        config.setZookeeperServers("127.0.0.1:" + this.ZOOKEEPER_PORT);
        config.setBrokerServicePort(Optional.of(this.PRIMARY_BROKER_PORT));
        config.setAdvertisedAddress("localhost");
        config.setBookkeeperClientIsolationGroups("default-group");
        config.setManagedLedgerDefaultEnsembleSize(2);
        config.setManagedLedgerDefaultWriteQuorum(2);
        config.setManagedLedgerDefaultAckQuorum(2);
        config.setAllowAutoTopicCreationType("non-partitioned");
        int totalEntriesPerLedger = 20;
        int totalLedgers = 100 / totalEntriesPerLedger;
        config.setManagedLedgerMaxEntriesPerLedger(totalEntriesPerLedger);
        config.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
        this.pulsarService = new PulsarService(config);
        this.pulsarService.start();
        URL brokerUrl = new URL("http://127.0.0.1:" + this.PRIMARY_BROKER_WEBSERVICE_PORT);
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(brokerUrl.toString()).build();
        ClusterData clusterData = new ClusterData(this.pulsarService.getWebServiceAddress());
        admin.clusters().createCluster("use", clusterData);
        TenantInfo tenantInfo = new TenantInfo(null, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        admin.tenants().createTenant("tenant1", tenantInfo);
        admin.namespaces().createNamespace(ns1);
        admin.namespaces().createNamespace(ns2);
        admin.namespaces().createNamespace(ns3);
        admin.namespaces().createNamespace(ns4);
        admin.namespaces().setBookieAffinityGroup(ns2, new BookieAffinityGroupData("tenant1-isolation", null));
        admin.namespaces().setBookieAffinityGroup(ns3, new BookieAffinityGroupData("tenant1-isolation", null));
        admin.namespaces().setBookieAffinityGroup(ns4, new BookieAffinityGroupData("tenant1-isolation", null));
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns2), (Object)new BookieAffinityGroupData("tenant1-isolation", null));
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns3), (Object)new BookieAffinityGroupData("tenant1-isolation", null));
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns4), (Object)new BookieAffinityGroupData("tenant1-isolation", null));
        try {
            admin.namespaces().getBookieAffinityGroup(ns1);
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(brokerUrl.toString()).statsInterval(-1L, TimeUnit.SECONDS).build();
        PersistentTopic topic1 = (PersistentTopic)this.createTopicAndPublish(pulsarClient, ns1, "topic1", 100);
        PersistentTopic topic2 = (PersistentTopic)this.createTopicAndPublish(pulsarClient, ns2, "topic1", 100);
        PersistentTopic topic3 = (PersistentTopic)this.createTopicAndPublish(pulsarClient, ns3, "topic1", 100);
        PersistentTopic topic4 = (PersistentTopic)this.createTopicAndPublish(pulsarClient, ns4, "topic1", 100);
        Bookie bookie1 = bookies[0].getBookie();
        Field ledgerManagerField = Bookie.class.getDeclaredField("ledgerManager");
        ledgerManagerField.setAccessible(true);
        LedgerManager ledgerManager = (LedgerManager)ledgerManagerField.get(bookie1);
        ManagedLedgerImpl ml = (ManagedLedgerImpl)topic1.getManagedLedger();
        Assert.assertEquals((int)ml.getLedgersInfoAsList().size(), (int)totalLedgers);
        this.assertAffinityBookies(ledgerManager, ml.getLedgersInfoAsList(), defaultBookies);
        ml = (ManagedLedgerImpl)topic2.getManagedLedger();
        Assert.assertEquals((int)ml.getLedgersInfoAsList().size(), (int)totalLedgers);
        this.assertAffinityBookies(ledgerManager, ml.getLedgersInfoAsList(), isolatedBookies);
        ml = (ManagedLedgerImpl)topic3.getManagedLedger();
        Assert.assertEquals((int)ml.getLedgersInfoAsList().size(), (int)totalLedgers);
        this.assertAffinityBookies(ledgerManager, ml.getLedgersInfoAsList(), isolatedBookies);
        ml = (ManagedLedgerImpl)topic4.getManagedLedger();
        Assert.assertEquals((int)ml.getLedgersInfoAsList().size(), (int)totalLedgers);
        this.assertAffinityBookies(ledgerManager, ml.getLedgersInfoAsList(), isolatedBookies);
        ManagedLedgerClientFactory mlFactory = this.pulsarService.getManagedLedgerClientFactory();
        Map bkPlacementPolicyToBkClientMap = mlFactory.getBkEnsemblePolicyToBookKeeperMap();
        Assert.assertEquals((int)bkPlacementPolicyToBkClientMap.size(), (int)1);
    }

    @Test
    public void testBookieIsilationWithSecondaryGroup() throws Exception {
        String tenant1 = "tenant1";
        String cluster = "use";
        String ns1 = String.format("%s/%s/%s", "tenant1", "use", "ns1");
        String ns2 = String.format("%s/%s/%s", "tenant1", "use", "ns2");
        String ns3 = String.format("%s/%s/%s", "tenant1", "use", "ns3");
        String ns4 = String.format("%s/%s/%s", "tenant1", "use", "ns4");
        int totalPublish = 100;
        String brokerBookkeeperClientIsolationGroups = "default-group";
        String tenantNamespaceIsolationGroupsPrimary = "tenant1-isolation-primary";
        String tenantNamespaceIsolationGroupsSecondary = "tenant1-isolation=secondary";
        BookieServer[] bookies = this.bkEnsemble.getBookies();
        ZooKeeper zkClient = this.bkEnsemble.getZkClient();
        HashSet defaultBookies = Sets.newHashSet((Object[])new BookieSocketAddress[]{bookies[0].getLocalAddress(), bookies[1].getLocalAddress()});
        HashSet isolatedBookies = Sets.newHashSet((Object[])new BookieSocketAddress[]{bookies[2].getLocalAddress(), bookies[3].getLocalAddress()});
        HashSet downedBookies = Sets.newHashSet((Object[])new BookieSocketAddress[]{new BookieSocketAddress("1.1.1.1:1111"), new BookieSocketAddress("1.1.1.1:1112")});
        this.setDefaultIsolationGroup("default-group", zkClient, defaultBookies);
        this.setDefaultIsolationGroup("tenant1-isolation-primary", zkClient, downedBookies);
        this.setDefaultIsolationGroup("tenant1-isolation=secondary", zkClient, isolatedBookies);
        ServiceConfiguration config = new ServiceConfiguration();
        config.setLoadManagerClassName(ModularLoadManagerImpl.class.getName());
        config.setClusterName("use");
        config.setWebServicePort(Optional.of(this.PRIMARY_BROKER_WEBSERVICE_PORT));
        config.setZookeeperServers("127.0.0.1:" + this.ZOOKEEPER_PORT);
        config.setBrokerServicePort(Optional.of(this.PRIMARY_BROKER_PORT));
        config.setAdvertisedAddress("localhost");
        config.setBookkeeperClientIsolationGroups("default-group");
        config.setManagedLedgerDefaultEnsembleSize(2);
        config.setManagedLedgerDefaultWriteQuorum(2);
        config.setManagedLedgerDefaultAckQuorum(2);
        config.setAllowAutoTopicCreationType("non-partitioned");
        int totalEntriesPerLedger = 20;
        int totalLedgers = 100 / totalEntriesPerLedger;
        config.setManagedLedgerMaxEntriesPerLedger(totalEntriesPerLedger);
        config.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
        this.pulsarService = new PulsarService(config);
        this.pulsarService.start();
        URL brokerUrl = new URL("http://127.0.0.1:" + this.PRIMARY_BROKER_WEBSERVICE_PORT);
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(brokerUrl.toString()).build();
        ClusterData clusterData = new ClusterData(this.pulsarService.getWebServiceAddress());
        admin.clusters().createCluster("use", clusterData);
        TenantInfo tenantInfo = new TenantInfo(null, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        admin.tenants().createTenant("tenant1", tenantInfo);
        admin.namespaces().createNamespace(ns1);
        admin.namespaces().createNamespace(ns2);
        admin.namespaces().createNamespace(ns3);
        admin.namespaces().createNamespace(ns4);
        admin.namespaces().setBookieAffinityGroup(ns2, new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
        admin.namespaces().setBookieAffinityGroup(ns3, new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
        admin.namespaces().setBookieAffinityGroup(ns4, new BookieAffinityGroupData("tenant1-isolation-primary", null));
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns2), (Object)new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns3), (Object)new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns4), (Object)new BookieAffinityGroupData("tenant1-isolation-primary", null));
        try {
            admin.namespaces().getBookieAffinityGroup(ns1);
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(brokerUrl.toString()).statsInterval(-1L, TimeUnit.SECONDS).build();
        PersistentTopic topic1 = (PersistentTopic)this.createTopicAndPublish(pulsarClient, ns1, "topic1", 100);
        PersistentTopic topic2 = (PersistentTopic)this.createTopicAndPublish(pulsarClient, ns2, "topic1", 100);
        PersistentTopic topic3 = (PersistentTopic)this.createTopicAndPublish(pulsarClient, ns3, "topic1", 100);
        Bookie bookie1 = bookies[0].getBookie();
        Field ledgerManagerField = Bookie.class.getDeclaredField("ledgerManager");
        ledgerManagerField.setAccessible(true);
        LedgerManager ledgerManager = (LedgerManager)ledgerManagerField.get(bookie1);
        ManagedLedgerImpl ml = (ManagedLedgerImpl)topic1.getManagedLedger();
        Assert.assertEquals((int)ml.getLedgersInfoAsList().size(), (int)totalLedgers);
        this.assertAffinityBookies(ledgerManager, ml.getLedgersInfoAsList(), defaultBookies);
        ml = (ManagedLedgerImpl)topic2.getManagedLedger();
        Assert.assertEquals((int)ml.getLedgersInfoAsList().size(), (int)totalLedgers);
        this.assertAffinityBookies(ledgerManager, ml.getLedgersInfoAsList(), isolatedBookies);
        ml = (ManagedLedgerImpl)topic3.getManagedLedger();
        Assert.assertEquals((int)ml.getLedgersInfoAsList().size(), (int)totalLedgers);
        this.assertAffinityBookies(ledgerManager, ml.getLedgersInfoAsList(), isolatedBookies);
        ManagedLedgerClientFactory mlFactory = this.pulsarService.getManagedLedgerClientFactory();
        Map bkPlacementPolicyToBkClientMap = mlFactory.getBkEnsemblePolicyToBookKeeperMap();
        Assert.assertEquals((int)bkPlacementPolicyToBkClientMap.size(), (int)1);
        try {
            PersistentTopic topic4 = (PersistentTopic)this.createTopicAndPublish(pulsarClient, ns4, "topic1", 1);
            Assert.fail((String)"should have failed due to not enough non-faulty bookie");
        }
        catch (PulsarClientException.BrokerPersistenceException brokerPersistenceException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteIsolationGroup() throws Exception {
        String tenant1 = "tenant1";
        String cluster = "use";
        String ns2 = String.format("%s/%s/%s", "tenant1", "use", "ns2");
        String ns3 = String.format("%s/%s/%s", "tenant1", "use", "ns3");
        String brokerBookkeeperClientIsolationGroups = "default-group";
        String tenantNamespaceIsolationGroupsPrimary = "tenant1-isolation-primary";
        String tenantNamespaceIsolationGroupsSecondary = "tenant1-isolation=secondary";
        BookieServer[] bookies = this.bkEnsemble.getBookies();
        ZooKeeper zkClient = this.bkEnsemble.getZkClient();
        HashSet defaultBookies = Sets.newHashSet((Object[])new BookieSocketAddress[]{bookies[0].getLocalAddress(), bookies[1].getLocalAddress()});
        HashSet isolatedBookies = Sets.newHashSet((Object[])new BookieSocketAddress[]{bookies[2].getLocalAddress(), bookies[3].getLocalAddress()});
        this.setDefaultIsolationGroup("default-group", zkClient, defaultBookies);
        this.setDefaultIsolationGroup("tenant1-isolation-primary", zkClient, Sets.newHashSet());
        this.setDefaultIsolationGroup("tenant1-isolation=secondary", zkClient, isolatedBookies);
        ServiceConfiguration config = new ServiceConfiguration();
        config.setLoadManagerClassName(ModularLoadManagerImpl.class.getName());
        config.setClusterName("use");
        config.setWebServicePort(Optional.of(this.PRIMARY_BROKER_WEBSERVICE_PORT));
        config.setZookeeperServers("127.0.0.1:" + this.ZOOKEEPER_PORT);
        config.setBrokerServicePort(Optional.of(this.PRIMARY_BROKER_PORT));
        config.setAdvertisedAddress("localhost");
        config.setBookkeeperClientIsolationGroups("default-group");
        config.setManagedLedgerDefaultEnsembleSize(2);
        config.setManagedLedgerDefaultWriteQuorum(2);
        config.setManagedLedgerDefaultAckQuorum(2);
        config.setAllowAutoTopicCreationType("non-partitioned");
        config.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
        this.pulsarService = new PulsarService(config);
        this.pulsarService.start();
        URL brokerUrl = new URL("http://127.0.0.1:" + this.PRIMARY_BROKER_WEBSERVICE_PORT);
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(brokerUrl.toString()).build();
        ClusterData clusterData = new ClusterData(this.pulsarService.getWebServiceAddress());
        admin.clusters().createCluster("use", clusterData);
        TenantInfo tenantInfo = new TenantInfo(null, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        admin.tenants().createTenant("tenant1", tenantInfo);
        admin.namespaces().createNamespace(ns2);
        admin.namespaces().createNamespace(ns3);
        admin.namespaces().setBookieAffinityGroup(ns2, new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
        admin.namespaces().setBookieAffinityGroup(ns3, new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns2), (Object)new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns3), (Object)new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
        admin.namespaces().deleteBookieAffinityGroup(ns2);
        try {
            admin.namespaces().getBookieAffinityGroup(ns2);
            Assert.fail((String)"should have fail due to affinity-group not present");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        Assert.assertEquals((Object)admin.namespaces().getBookieAffinityGroup(ns3), (Object)new BookieAffinityGroupData("tenant1-isolation-primary", "tenant1-isolation=secondary"));
    }

    private void assertAffinityBookies(LedgerManager ledgerManager, List<MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgers1, Set<BookieSocketAddress> defaultBookies) throws Exception {
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo lInfo : ledgers1) {
            long ledgerId = lInfo.getLedgerId();
            CompletableFuture ledgerMetaFuture = ledgerManager.readLedgerMetadata(ledgerId);
            LedgerMetadata ledgerMetadata = (LedgerMetadata)((Versioned)ledgerMetaFuture.get()).getValue();
            HashSet ledgerBookies = Sets.newHashSet();
            ledgerBookies.addAll((Collection)ledgerMetadata.getAllEnsembles().values().iterator().next());
            Assert.assertEquals((int)ledgerBookies.size(), (int)defaultBookies.size());
            ledgerBookies.removeAll(defaultBookies);
            Assert.assertEquals((int)ledgerBookies.size(), (int)0);
        }
    }

    private Topic createTopicAndPublish(PulsarClient pulsarClient, String ns, String topicLocalName, int totalPublish) throws Exception {
        String topicName = String.format("persistent://%s/%s", ns, topicLocalName);
        Consumer consumer = pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-subscriber-name").subscribe();
        consumer.close();
        ProducerBuilder producerBuilder = pulsarClient.newProducer().topic(topicName).sendTimeout(5, TimeUnit.SECONDS);
        Producer producer = producerBuilder.create();
        for (int i = 0; i < totalPublish; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
        return (Topic)this.pulsarService.getBrokerService().getTopicReference(topicName).get();
    }

    private void setDefaultIsolationGroup(String brokerBookkeeperClientIsolationGroups, ZooKeeper zkClient, Set<BookieSocketAddress> bookieAddresses) throws Exception {
        BookiesRackConfiguration bookies = null;
        try {
            byte[] data = zkClient.getData("/bookies", false, null);
            System.out.println(new String(data));
            bookies = (BookiesRackConfiguration)this.jsonMapper.readValue(data, BookiesRackConfiguration.class);
        }
        catch (KeeperException.NoNodeException e) {
            zkClient.create("/bookies", "".getBytes(), Acl, CreateMode.PERSISTENT);
        }
        if (bookies == null) {
            bookies = new BookiesRackConfiguration();
        }
        HashMap bookieInfoMap = Maps.newHashMap();
        for (BookieSocketAddress bkSocket : bookieAddresses) {
            BookieInfo info = new BookieInfo("use", bkSocket.getHostName() + ":" + bkSocket.getPort());
            bookieInfoMap.put(bkSocket.toString(), info);
        }
        bookies.put((Object)brokerBookkeeperClientIsolationGroups, (Object)bookieInfoMap);
        zkClient.setData("/bookies", this.jsonMapper.writeValueAsBytes((Object)bookies), -1);
    }
}

