/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BrokerServiceAutoTopicCreationTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testAutoNonPartitionedTopicCreation() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("non-partitioned");
        String topicName = "persistent://prop/ns-abc/non-partitioned-topic";
        String subscriptionName = "non-partitioned-topic-sub";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/non-partitioned-topic"}).subscriptionName("non-partitioned-topic-sub").subscribe();
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/non-partitioned-topic"));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/non-partitioned-topic"));
    }

    @Test
    public void testAutoPartitionedTopicCreation() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(3);
        String topicName = "persistent://prop/ns-abc/partitioned-topic";
        String subscriptionName = "partitioned-topic-sub";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/partitioned-topic"}).subscriptionName("partitioned-topic-sub").subscribe();
        Assert.assertTrue((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-topic"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-topic-partition-" + i));
        }
    }

    @Test
    public void testAutoTopicCreationDisable() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        String topicName = "persistent://prop/ns-abc/test-topic";
        String subscriptionName = "test-topic-sub";
        try {
            this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/test-topic"}).subscriptionName("test-topic-sub").subscribe();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException));
        }
        Assert.assertFalse((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic"));
    }

    @Test
    public void testAutoTopicCreationDisableIfNonPartitionedTopicAlreadyExist() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(3);
        String topicName = "persistent://prop/ns-abc/test-topic-2";
        String subscriptionName = "partitioned-topic-sub";
        this.admin.topics().createNonPartitionedTopic("persistent://prop/ns-abc/test-topic-2");
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/test-topic-2"}).subscriptionName("partitioned-topic-sub").subscribe();
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-2"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-2-partition-" + i));
        }
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-2"));
    }

    @Test
    public void testGetPartitionedMetadataWithoutCheckAllowAutoCreation() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(3);
        String topicName = "persistent://prop/ns-abc/test-topic-3";
        int partitions = this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop/ns-abc/test-topic-3").partitions;
        Assert.assertEquals((int)partitions, (int)0);
        Assert.assertFalse((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-3"));
    }
}

