/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrokerTestBase
extends MockedPulsarServiceBaseTest {
    protected static final int ASYNC_EVENT_COMPLETION_WAIT = 100;
    private static final Logger LOG = LoggerFactory.getLogger(BrokerTestBase.class);

    protected PulsarService getPulsar() {
        return this.pulsar;
    }

    public void baseSetup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
        this.admin.tenants().createTenant("prop", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("prop/ns-abc");
        this.admin.namespaces().setNamespaceReplicationClusters("prop/ns-abc", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    void rolloverPerIntervalStats() {
        try {
            this.pulsar.getExecutor().submit(() -> this.pulsar.getBrokerService().updateRates()).get();
        }
        catch (Exception e) {
            LOG.error("Stats executor error", (Throwable)e);
        }
    }

    void runGC() {
        try {
            this.pulsar.getExecutor().submit(() -> this.pulsar.getBrokerService().checkGC(0)).get();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            LOG.error("GC executor error", (Throwable)e);
        }
    }

    void runMessageExpiryCheck() {
        try {
            this.pulsar.getExecutor().submit(() -> this.pulsar.getBrokerService().checkMessageExpiry()).get();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            LOG.error("Error running message expiry check", (Throwable)e);
        }
    }
}

