/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.pulsar.broker.service.DistributedIdGenerator;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class DistributedIdGeneratorTest {
    private MockZooKeeper zkc;

    @BeforeClass
    public void setup() throws Exception {
        this.zkc = MockZooKeeper.newInstance();
    }

    @AfterClass
    public void teardown() throws Exception {
        this.zkc.shutdown();
    }

    @Test
    public void simple() throws Exception {
        DistributedIdGenerator gen1 = new DistributedIdGenerator((ZooKeeper)this.zkc, "/my/test/simple", "p");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-0");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-1");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-2");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-3");
        DistributedIdGenerator gen2 = new DistributedIdGenerator((ZooKeeper)this.zkc, "/my/test/simple", "p");
        Assert.assertEquals((String)gen2.getNextId(), (String)"p-1-0");
        Assert.assertEquals((String)gen2.getNextId(), (String)"p-1-1");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-4");
        Assert.assertEquals((String)gen2.getNextId(), (String)"p-1-2");
    }

    @Test
    public void concurrent() throws Exception {
        int Threads = 10;
        int Iterations = 100;
        CyclicBarrier barrier = new CyclicBarrier(Threads);
        CountDownLatch counter = new CountDownLatch(Threads);
        ExecutorService executor = Executors.newCachedThreadPool();
        List results = Collections.synchronizedList(Lists.newArrayList());
        for (int i = 0; i < Threads; ++i) {
            executor.execute(() -> {
                try {
                    DistributedIdGenerator gen = new DistributedIdGenerator((ZooKeeper)this.zkc, "/my/test/concurrent", "prefix");
                    barrier.await();
                    for (int j = 0; j < Iterations; ++j) {
                        results.add(gen.getNextId());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    counter.countDown();
                }
            });
        }
        counter.await();
        Assert.assertEquals((int)results.size(), (int)(Threads * Iterations));
        HashSet set = Sets.newHashSet(results);
        Assert.assertEquals((int)set.size(), (int)results.size());
        executor.shutdown();
    }

    @Test
    public void invalidZnode() throws Exception {
        this.zkc.create("/my/test/invalid", "invalid-number".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        DistributedIdGenerator gen = new DistributedIdGenerator((ZooKeeper)this.zkc, "/my/test/invalid", "p");
        Assert.assertEquals((String)gen.getNextId(), (String)"p-0-0");
    }
}

