/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.UUID;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.HashRangeStickyKeyConsumerSelector;
import org.apache.pulsar.common.util.Murmur3_32Hash;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HashRangeStickyKeyConsumerSelectorTest {
    @Test
    public void testConsumerSelect() throws BrokerServiceException.ConsumerAssignException {
        int slot;
        String key;
        int i;
        HashRangeStickyKeyConsumerSelector selector = new HashRangeStickyKeyConsumerSelector();
        String key1 = "anyKey";
        Assert.assertNull((Object)selector.select(key1.getBytes()));
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        selector.addConsumer(consumer1);
        int consumer1Slot = 65536;
        Assert.assertEquals((Object)selector.select(key1.getBytes()), (Object)consumer1);
        Assert.assertEquals((int)selector.getConsumerRange().size(), (int)1);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)1);
        Consumer consumer2 = (Consumer)Mockito.mock(Consumer.class);
        selector.addConsumer(consumer2);
        Assert.assertEquals((int)selector.getConsumerRange().size(), (int)2);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)2);
        int consumer2Slot = consumer1Slot >> 1;
        for (int i2 = 0; i2 < 100; ++i2) {
            String key2 = UUID.randomUUID().toString();
            int slot2 = Murmur3_32Hash.getInstance().makeHash(key2.getBytes()) % 65536;
            if (slot2 < consumer2Slot) {
                Assert.assertEquals((Object)selector.select(key2.getBytes()), (Object)consumer2);
                continue;
            }
            Assert.assertEquals((Object)selector.select(key2.getBytes()), (Object)consumer1);
        }
        Consumer consumer3 = (Consumer)Mockito.mock(Consumer.class);
        selector.addConsumer(consumer3);
        Assert.assertEquals((int)selector.getConsumerRange().size(), (int)3);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)3);
        int consumer3Slot = consumer2Slot >> 1;
        for (int i3 = 0; i3 < 100; ++i3) {
            String key3 = UUID.randomUUID().toString();
            int slot3 = Murmur3_32Hash.getInstance().makeHash(key3.getBytes()) % 65536;
            if (slot3 < consumer3Slot) {
                Assert.assertEquals((Object)selector.select(key3.getBytes()), (Object)consumer3);
                continue;
            }
            if (slot3 < consumer2Slot) {
                Assert.assertEquals((Object)selector.select(key3.getBytes()), (Object)consumer2);
                continue;
            }
            Assert.assertEquals((Object)selector.select(key3.getBytes()), (Object)consumer1);
        }
        Consumer consumer4 = (Consumer)Mockito.mock(Consumer.class);
        selector.addConsumer(consumer4);
        Assert.assertEquals((int)selector.getConsumerRange().size(), (int)4);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)4);
        int consumer4Slot = consumer1Slot - (consumer1Slot - consumer2Slot >> 1);
        for (i = 0; i < 100; ++i) {
            key = UUID.randomUUID().toString();
            slot = Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
            if (slot < consumer3Slot) {
                Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer3);
                continue;
            }
            if (slot < consumer2Slot) {
                Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer2);
                continue;
            }
            if (slot < consumer4Slot) {
                Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer4);
                continue;
            }
            Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer1);
        }
        selector.removeConsumer(consumer1);
        Assert.assertEquals((int)selector.getConsumerRange().size(), (int)3);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)3);
        for (i = 0; i < 100; ++i) {
            key = UUID.randomUUID().toString();
            slot = Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
            if (slot < consumer3Slot) {
                Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer3);
                continue;
            }
            if (slot < consumer2Slot) {
                Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer2);
                continue;
            }
            Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer4);
        }
        selector.removeConsumer(consumer2);
        Assert.assertEquals((int)selector.getConsumerRange().size(), (int)2);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)2);
        for (i = 0; i < 100; ++i) {
            key = UUID.randomUUID().toString();
            slot = Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
            if (slot < consumer3Slot) {
                Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer3);
                continue;
            }
            Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer4);
        }
        selector.removeConsumer(consumer3);
        Assert.assertEquals((int)selector.getConsumerRange().size(), (int)1);
        Assert.assertEquals((int)selector.getRangeConsumer().size(), (int)1);
        for (i = 0; i < 100; ++i) {
            key = UUID.randomUUID().toString();
            Assert.assertEquals((Object)selector.select(key.getBytes()), (Object)consumer4);
        }
    }

    @Test(expectedExceptions={BrokerServiceException.ConsumerAssignException.class})
    public void testSplitExceed() throws BrokerServiceException.ConsumerAssignException {
        HashRangeStickyKeyConsumerSelector selector = new HashRangeStickyKeyConsumerSelector(16);
        for (int i = 0; i <= 16; ++i) {
            selector.addConsumer((Consumer)Mockito.mock(Consumer.class));
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRangeSizeLessThan2() {
        new HashRangeStickyKeyConsumerSelector(1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRangeSizePower2() {
        new HashRangeStickyKeyConsumerSelector(6);
    }
}

