/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.io.IOException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class MessageIdSerialization {
    @Test
    void testProtobufSerialization1() throws Exception {
        MessageIdImpl id = new MessageIdImpl(1L, 2L, 3);
        byte[] serializedId = id.toByteArray();
        Assert.assertEquals((Object)MessageId.fromByteArray((byte[])serializedId), (Object)id);
    }

    @Test
    void testProtobufSerialization2() throws Exception {
        MessageIdImpl id = new MessageIdImpl(1L, 2L, -1);
        byte[] serializedId = id.toByteArray();
        Assert.assertEquals((Object)MessageId.fromByteArray((byte[])serializedId), (Object)id);
    }

    @Test(expectedExceptions={NullPointerException.class})
    void testProtobufSerializationNull() throws Exception {
        MessageId.fromByteArray(null);
    }

    @Test(expectedExceptions={IOException.class})
    void testProtobufSerializationEmpty() throws Exception {
        MessageId.fromByteArray((byte[])new byte[0]);
    }
}

