/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class NonPersistentTopicE2ETest
extends BrokerTestBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    private Optional<Topic> getTopic(String topicName) {
        return this.pulsar.getBrokerService().getTopicReference(topicName);
    }

    private boolean topicHasSchema(String topicName) {
        String base = TopicName.get((String)topicName).getPartitionedTopicName();
        String schemaName = TopicName.get((String)base).getSchemaName();
        SchemaRegistry.SchemaAndMetadata result = (SchemaRegistry.SchemaAndMetadata)this.pulsar.getSchemaRegistryService().getSchema(schemaName).join();
        return result != null && !result.schema.isDeleted();
    }

    @Test
    public void testGCWillDeleteSchema() throws Exception {
        String topicName = "non-persistent://prop/ns-abc/topic-1";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        producer.close();
        Optional<Topic> topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        byte[] data = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build()).getSchemaInfo().getSchema();
        SchemaData schemaData = SchemaData.builder().data(data).type(SchemaType.BYTES).user("foo").build();
        topic.get().addSchema(schemaData).join();
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertFalse((boolean)topic.isPresent());
        Assert.assertFalse((boolean)this.topicHasSchema(topicName));
        topicName = "non-persistent://prop/ns-abc/topic-2";
        String subName = "sub1";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subName).subscribe();
        topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        topic.get().addSchema(schemaData).join();
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        consumer.close();
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        this.admin.topics().deleteSubscription(topicName, subName);
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertFalse((boolean)topic.isPresent());
        Assert.assertFalse((boolean)this.topicHasSchema(topicName));
    }

    private static class Foo {
        private String field1;
        private String field2;
        private int field3;

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public int getField3() {
            return this.field3;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public void setField3(int field3) {
            this.field3 = field3;
        }

        public String toString() {
            return "NonPersistentTopicE2ETest.Foo(field1=" + this.getField1() + ", field2=" + this.getField2() + ", field3=" + this.getField3() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Foo)) {
                return false;
            }
            Foo other = (Foo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$field1 = this.getField1();
            String other$field1 = other.getField1();
            if (this$field1 == null ? other$field1 != null : !this$field1.equals(other$field1)) {
                return false;
            }
            String this$field2 = this.getField2();
            String other$field2 = other.getField2();
            if (this$field2 == null ? other$field2 != null : !this$field2.equals(other$field2)) {
                return false;
            }
            return this.getField3() == other.getField3();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Foo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field1 = this.getField1();
            result = result * 59 + ($field1 == null ? 43 : $field1.hashCode());
            String $field2 = this.getField2();
            result = result * 59 + ($field2 == null ? 43 : $field2.hashCode());
            result = result * 59 + this.getField3();
            return result;
        }
    }
}

