/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.PortManager;
import org.apache.pulsar.broker.service.BrokerBkEnsemblesTests;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RackAwareTest
extends BrokerBkEnsemblesTests {
    private static final int NUM_BOOKIES = 6;
    private final List<BookieServer> bookies = new ArrayList<BookieServer>();
    private static final Logger log = LoggerFactory.getLogger(RackAwareTest.class);

    public RackAwareTest() {
        super(0);
    }

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.setup();
        for (int i = 0; i < 6; ++i) {
            File bkDataDir = Files.createTempDirectory("bk" + Integer.toString(i) + "test", new FileAttribute[0]).toFile();
            ServerConfiguration conf = new ServerConfiguration();
            int bookiePort = PortManager.nextFreePort();
            conf.setBookiePort(bookiePort);
            conf.setZkServers("127.0.0.1:" + this.bkEnsemble.getZkServer().getClientPort());
            conf.setJournalDirName(bkDataDir.getPath());
            conf.setLedgerDirNames(new String[]{bkDataDir.getPath()});
            conf.setAllowLoopback(true);
            String addr = String.format("10.0.0.%d", i + 1);
            conf.setAdvertisedAddress(addr);
            BookieServer bs = new BookieServer(conf, (StatsLogger)NullStatsLogger.INSTANCE);
            bs.start();
            this.bookies.add(bs);
            log.info("Local BK[{}] started (port: {}, adddress: {})", new Object[]{i, bookiePort, addr});
        }
    }

    @Override
    @AfterClass
    protected void shutdown() throws Exception {
        super.shutdown();
        for (BookieServer bs : this.bookies) {
            bs.shutdown();
        }
        this.bookies.clear();
    }

    @Test
    public void testPlacement() throws Exception {
        for (int i = 0; i < 6; ++i) {
            String bookie = this.bookies.get(i).getLocalAddress().toString();
            int rackId = i == 0 ? 1 : 2;
            BookieInfo bi = new BookieInfo("rack-" + rackId, "bookie-" + (i + 1));
            log.info("setting rack for bookie at {} -- {}", (Object)bookie, (Object)bi);
            this.admin.bookies().updateBookieRackInfo(bookie, "default", bi);
        }
        Thread.sleep(1000L);
        BookKeeper bkc = this.pulsar.getBookKeeperClient();
        BookieSocketAddress fistBookie = this.bookies.get(0).getLocalAddress();
        for (int i = 0; i < 100; ++i) {
            LedgerHandle lh = bkc.createLedger(2, 2, BookKeeper.DigestType.DUMMY, new byte[0]);
            log.info("Ledger: {} -- Ensemble: {}", (Object)i, (Object)lh.getLedgerMetadata().getEnsembleAt(0L));
            Assert.assertTrue((boolean)lh.getLedgerMetadata().getEnsembleAt(0L).contains(fistBookie), (String)"first bookie in rack 0 not included in ensemble");
            lh.close();
        }
    }

    @Override
    @Test(enabled=false)
    public void testCrashBrokerWithoutCursorLedgerLeak() throws Exception {
    }

    @Override
    @Test(enabled=false)
    public void testSkipCorruptDataLedger() throws Exception {
    }

    @Override
    @Test(enabled=false)
    public void testTopicWithWildCardChar() throws Exception {
    }
}

