/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.ReplicatorTestBase;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReplicatorGlobalNSTest
extends ReplicatorTestBase {
    protected String methodName;
    private static final Logger log = LoggerFactory.getLogger(ReplicatorGlobalNSTest.class);

    @BeforeMethod
    public void beforeMethod(Method m) {
        this.methodName = m.getName();
    }

    @Override
    @BeforeClass(timeOut=300000L)
    void setup() throws Exception {
        super.setup();
    }

    @Override
    @AfterClass(timeOut=300000L)
    void shutdown() throws Exception {
        super.shutdown();
    }

    @Test
    public void testRemoveLocalClusterOnGlobalNamespace() throws Exception {
        log.info("--- Starting ReplicatorTest::testRemoveLocalClusterOnGlobalNamespace ---");
        String namespace = "pulsar/global/removeClusterTest";
        this.admin1.namespaces().createNamespace("pulsar/global/removeClusterTest");
        this.admin1.namespaces().setNamespaceReplicationClusters("pulsar/global/removeClusterTest", (Set)Sets.newHashSet((Object[])new String[]{"r1", "r2", "r3"}));
        String topicName = "persistent://pulsar/global/removeClusterTest/topic";
        PulsarClient client1 = PulsarClient.builder().serviceUrl(this.url1.toString()).statsInterval(0L, TimeUnit.SECONDS).build();
        PulsarClient client2 = PulsarClient.builder().serviceUrl(this.url2.toString()).statsInterval(0L, TimeUnit.SECONDS).build();
        ProducerImpl producer1 = (ProducerImpl)client1.newProducer().topic("persistent://pulsar/global/removeClusterTest/topic").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        ConsumerImpl consumer1 = (ConsumerImpl)client1.newConsumer().topic(new String[]{"persistent://pulsar/global/removeClusterTest/topic"}).subscriptionName("sub1").subscribe();
        ConsumerImpl consumer2 = (ConsumerImpl)client2.newConsumer().topic(new String[]{"persistent://pulsar/global/removeClusterTest/topic"}).subscriptionName("sub1").subscribe();
        this.admin1.namespaces().setNamespaceReplicationClusters("pulsar/global/removeClusterTest", (Set)Sets.newHashSet((Object[])new String[]{"r2", "r3"}));
        MockedPulsarServiceBaseTest.retryStrategically(test -> !this.pulsar1.getBrokerService().getTopics().containsKey((Object)"persistent://pulsar/global/removeClusterTest/topic"), 5, 150L);
        Assert.assertFalse((boolean)this.pulsar1.getBrokerService().getTopics().containsKey((Object)"persistent://pulsar/global/removeClusterTest/topic"));
        Assert.assertFalse((boolean)producer1.isConnected());
        Assert.assertFalse((boolean)consumer1.isConnected());
        Assert.assertTrue((boolean)consumer2.isConnected());
        client1.close();
        client2.close();
    }

    @Test
    public void testForcefullyTopicDeletion() throws Exception {
        log.info("--- Starting ReplicatorTest::testForcefullyTopicDeletion ---");
        String namespace = "pulsar/removeClusterTest";
        this.admin1.namespaces().createNamespace("pulsar/removeClusterTest");
        this.admin1.namespaces().setNamespaceReplicationClusters("pulsar/removeClusterTest", (Set)Sets.newHashSet((Object[])new String[]{"r1"}));
        String topicName = "persistent://pulsar/removeClusterTest/topic";
        PulsarClient client1 = PulsarClient.builder().serviceUrl(this.url1.toString()).statsInterval(0L, TimeUnit.SECONDS).build();
        ProducerImpl producer1 = (ProducerImpl)client1.newProducer().topic("persistent://pulsar/removeClusterTest/topic").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        producer1.close();
        this.admin1.topics().delete("persistent://pulsar/removeClusterTest/topic", true);
        MockedPulsarServiceBaseTest.retryStrategically(test -> !this.pulsar1.getBrokerService().getTopics().containsKey((Object)"persistent://pulsar/removeClusterTest/topic"), 5, 150L);
        Assert.assertFalse((boolean)this.pulsar1.getBrokerService().getTopics().containsKey((Object)"persistent://pulsar/removeClusterTest/topic"));
        client1.close();
    }
}

