/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DelayedDeliveryTest
extends ProducerConsumerBase {
    @Override
    @BeforeClass
    public void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayedDelivery() throws Exception {
        String topic = "testNegativeAcks-" + System.nanoTime();
        Consumer failoverConsumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("failover-sub").subscriptionType(SubscriptionType.Failover).subscribe();
        try {
            Consumer sharedConsumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).subscribe();
            try {
                Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
                try {
                    int i;
                    for (int i2 = 0; i2 < 10; ++i2) {
                        producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).sendAsync();
                    }
                    producer.flush();
                    Message msg = sharedConsumer.receive(100, TimeUnit.MILLISECONDS);
                    Assert.assertNull((Object)msg);
                    for (int i3 = 0; i3 < 10; ++i3) {
                        msg = failoverConsumer.receive(100, TimeUnit.MILLISECONDS);
                        Assert.assertEquals((String)((String)msg.getValue()), (String)("msg-" + i3));
                    }
                    TreeSet<Object> receivedMsgs = new TreeSet<Object>();
                    for (i = 0; i < 10; ++i) {
                        msg = sharedConsumer.receive(10, TimeUnit.SECONDS);
                        receivedMsgs.add(msg.getValue());
                    }
                    Assert.assertEquals((int)receivedMsgs.size(), (int)10);
                    for (i = 0; i < 10; ++i) {
                        Assert.assertTrue((boolean)receivedMsgs.contains("msg-" + i));
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(sharedConsumer).get(0) != null) {
                    sharedConsumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(failoverConsumer).get(0) != null) {
                failoverConsumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterleavedMessages() throws Exception {
        String topic = "testInterleavedMessages-" + System.nanoTime();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
            try {
                int i;
                int i2;
                for (i2 = 0; i2 < 10; ++i2) {
                    producer.newMessage().value((Object)("immediate-msg-" + i2)).sendAsync();
                    producer.newMessage().value((Object)("delayed-msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).sendAsync();
                }
                producer.flush();
                for (i2 = 0; i2 < 10; ++i2) {
                    Message msg = consumer.receive(100, TimeUnit.MILLISECONDS);
                    Assert.assertEquals((String)((String)msg.getValue()), (String)("immediate-msg-" + i2));
                    consumer.acknowledge(msg);
                }
                TreeSet<Object> delayedMessages = new TreeSet<Object>();
                for (i = 0; i < 10; ++i) {
                    Message msg = consumer.receive(10, TimeUnit.SECONDS);
                    delayedMessages.add(msg.getValue());
                    consumer.acknowledge(msg);
                }
                for (i = 0; i < 10; ++i) {
                    Assert.assertTrue((boolean)delayedMessages.contains("delayed-msg-" + i));
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEverythingFilteredInMultipleReads() throws Exception {
        String topic = "testEverythingFilteredInMultipleReads-" + System.nanoTime();
        Consumer sharedConsumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
            try {
                int i;
                int i2;
                for (i2 = 0; i2 < 10; ++i2) {
                    producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).send();
                }
                Thread.sleep(1000L);
                for (i2 = 10; i2 < 20; ++i2) {
                    producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).send();
                }
                Message msg = sharedConsumer.receive(100, TimeUnit.MILLISECONDS);
                Assert.assertNull((Object)msg);
                TreeSet<Object> receivedMsgs = new TreeSet<Object>();
                for (i = 0; i < 20; ++i) {
                    msg = sharedConsumer.receive(10, TimeUnit.SECONDS);
                    receivedMsgs.add(msg.getValue());
                }
                Assert.assertEquals((int)receivedMsgs.size(), (int)20);
                for (i = 0; i < 10; ++i) {
                    Assert.assertTrue((boolean)receivedMsgs.contains("msg-" + i));
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(sharedConsumer).get(0) != null) {
                sharedConsumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayedDeliveryWithMultipleConcurrentReadEntries() throws Exception {
        String topic = "persistent://public/default/testDelayedDelivery-" + System.nanoTime();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).receiverQueueSize(1).subscribe();
        try {
            PersistentDispatcherMultipleConsumers d = (PersistentDispatcherMultipleConsumers)((PersistentTopic)this.pulsar.getBrokerService().getTopicReference(topic).get()).getSubscription("shared-sub").getDispatcher();
            Thread t = new Thread(() -> {
                while (true) {
                    PersistentDispatcherMultipleConsumers persistentDispatcherMultipleConsumers = d;
                    synchronized (persistentDispatcherMultipleConsumers) {
                        d.readMoreEntries();
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            });
            t.start();
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
            try {
                int i;
                int N = 1000;
                for (int i2 = 0; i2 < 1000; ++i2) {
                    producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).sendAsync();
                }
                producer.flush();
                Message msg = consumer.receive(100, TimeUnit.MILLISECONDS);
                Assert.assertNull((Object)msg);
                TreeSet<Object> receivedMsgs = new TreeSet<Object>();
                for (i = 0; i < 1000; ++i) {
                    msg = consumer.receive(10, TimeUnit.SECONDS);
                    receivedMsgs.add(msg.getValue());
                }
                Assert.assertEquals((int)receivedMsgs.size(), (int)1000);
                for (i = 0; i < 1000; ++i) {
                    Assert.assertTrue((boolean)receivedMsgs.contains("msg-" + i));
                }
                t.interrupt();
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }
}

