/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.Collections;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ReplicatedSubscriptionConfigTest
extends ProducerConsumerBase {
    @Override
    @BeforeClass
    public void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createReplicatedSubscription() throws Exception {
        String topic = "createReplicatedSubscription-" + System.nanoTime();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("sub1").replicateSubscriptionState(true).subscribe();
        try {
            TopicStats stats = this.admin.topics().getStats(topic);
            Assert.assertTrue((boolean)((SubscriptionStats)stats.subscriptions.get((Object)"sub1")).isReplicated);
            this.admin.topics().unload(topic);
            stats = this.admin.topics().getStats(topic);
            Assert.assertTrue((boolean)((SubscriptionStats)stats.subscriptions.get((Object)"sub1")).isReplicated);
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    @Test
    public void upgradeToReplicatedSubscription() throws Exception {
        String topic = "upgradeToReplicatedSubscription-" + System.nanoTime();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("sub").replicateSubscriptionState(false).subscribe();
        TopicStats stats = this.admin.topics().getStats(topic);
        Assert.assertFalse((boolean)((SubscriptionStats)stats.subscriptions.get((Object)"sub")).isReplicated);
        consumer.close();
        consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("sub").replicateSubscriptionState(true).subscribe();
        stats = this.admin.topics().getStats(topic);
        Assert.assertTrue((boolean)((SubscriptionStats)stats.subscriptions.get((Object)"sub")).isReplicated);
        consumer.close();
    }

    @Test
    public void upgradeToReplicatedSubscriptionAfterRestart() throws Exception {
        String topic = "upgradeToReplicatedSubscriptionAfterRestart-" + System.nanoTime();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("sub").replicateSubscriptionState(false).subscribe();
        TopicStats stats = this.admin.topics().getStats(topic);
        Assert.assertFalse((boolean)((SubscriptionStats)stats.subscriptions.get((Object)"sub")).isReplicated);
        consumer.close();
        this.admin.topics().unload(topic);
        consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("sub").replicateSubscriptionState(true).subscribe();
        stats = this.admin.topics().getStats(topic);
        Assert.assertTrue((boolean)((SubscriptionStats)stats.subscriptions.get((Object)"sub")).isReplicated);
        consumer.close();
    }
}

