/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.service.persistent.ReplicatedSubscriptionSnapshotCache;
import org.apache.pulsar.common.api.proto.PulsarMarkers;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReplicatedSubscriptionSnapshotCacheTest {
    @Test
    public void testSnashotCache() {
        ReplicatedSubscriptionSnapshotCache cache = new ReplicatedSubscriptionSnapshotCache("my-subscription", 10);
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(0L, 0L)));
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(100L, 0L)));
        cache.addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder().setSnapshotId("snapshot-1").setLocalMessageId(this.newMessageId(1L, 1L)).build());
        cache.addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder().setSnapshotId("snapshot-2").setLocalMessageId(this.newMessageId(2L, 2L)).build());
        cache.addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder().setSnapshotId("snapshot-5").setLocalMessageId(this.newMessageId(5L, 5L)).build());
        cache.addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder().setSnapshotId("snapshot-7").setLocalMessageId(this.newMessageId(7L, 7L)).build());
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(0L, 0L)));
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(1L, 0L)));
        PulsarMarkers.ReplicatedSubscriptionsSnapshot snapshot = cache.advancedMarkDeletePosition(new PositionImpl(1L, 1L));
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((String)snapshot.getSnapshotId(), (String)"snapshot-1");
        snapshot = cache.advancedMarkDeletePosition(new PositionImpl(5L, 6L));
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((String)snapshot.getSnapshotId(), (String)"snapshot-5");
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(2L, 2L)));
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(5L, 5L)));
    }

    @Test
    public void testSnashotCachePruning() {
        ReplicatedSubscriptionSnapshotCache cache = new ReplicatedSubscriptionSnapshotCache("my-subscription", 3);
        cache.addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder().setSnapshotId("snapshot-1").setLocalMessageId(this.newMessageId(1L, 1L)).build());
        cache.addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder().setSnapshotId("snapshot-2").setLocalMessageId(this.newMessageId(2L, 2L)).build());
        cache.addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder().setSnapshotId("snapshot-3").setLocalMessageId(this.newMessageId(3L, 3L)).build());
        cache.addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot.newBuilder().setSnapshotId("snapshot-4").setLocalMessageId(this.newMessageId(4L, 4L)).build());
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(1L, 1L)));
        PulsarMarkers.ReplicatedSubscriptionsSnapshot snapshot = cache.advancedMarkDeletePosition(new PositionImpl(2L, 2L));
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((String)snapshot.getSnapshotId(), (String)"snapshot-2");
        snapshot = cache.advancedMarkDeletePosition(new PositionImpl(5L, 5L));
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((String)snapshot.getSnapshotId(), (String)"snapshot-4");
    }

    private PulsarMarkers.MessageIdData newMessageId(long ledgerId, long entryId) {
        return PulsarMarkers.MessageIdData.newBuilder().setLedgerId(ledgerId).setEntryId(entryId).build();
    }
}

