/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import java.util.Arrays;
import java.util.Collections;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BaseAvroSchemaCompatibilityTest {
    SchemaCompatibilityCheck schemaCompatibilityCheck;
    private static final String schemaJson1 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}";
    private static final SchemaData schemaData1 = BaseAvroSchemaCompatibilityTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}");
    private static final String schemaJson2 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\",\"default\":\"foo\"}]}";
    private static final SchemaData schemaData2 = BaseAvroSchemaCompatibilityTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\",\"default\":\"foo\"}]}");
    private static final String schemaJson3 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\"}]}";
    private static final SchemaData schemaData3 = BaseAvroSchemaCompatibilityTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\"}]}");
    private static final String schemaJson4 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1_v2\",\"type\":\"string\",\"aliases\":[\"field1\"]}]}";
    private static final SchemaData schemaData4 = BaseAvroSchemaCompatibilityTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1_v2\",\"type\":\"string\",\"aliases\":[\"field1\"]}]}");
    private static final String schemaJson5 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":[\"null\",\"string\"]}]}";
    private static final SchemaData schemaData5 = BaseAvroSchemaCompatibilityTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":[\"null\",\"string\"]}]}");
    private static final String schemaJson6 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":[\"null\",\"string\",\"int\"]}]}";
    private static final SchemaData schemaData6 = BaseAvroSchemaCompatibilityTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":[\"null\",\"string\",\"int\"]}]}");
    private static final String schemaJson7 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\",\"default\":\"foo\"},{\"name\":\"field3\",\"type\":\"string\",\"default\":\"bar\"}]}";
    private static final SchemaData schemaData7 = BaseAvroSchemaCompatibilityTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\",\"default\":\"foo\"},{\"name\":\"field3\",\"type\":\"string\",\"default\":\"bar\"}]}");
    private static final String schemaJson8 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\"}]}";
    private static final SchemaData schemaData8 = BaseAvroSchemaCompatibilityTest.getSchemaData("{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\"}]}");

    public abstract SchemaCompatibilityCheck getSchemaCheck();

    @Test
    public void testBackwardCompatibility() {
        SchemaCompatibilityCheck schemaCompatibilityCheck = this.getSchemaCheck();
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData1, schemaData2, SchemaCompatibilityStrategy.BACKWARD), (String)"adding a field with default is backwards compatible");
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(schemaData1, schemaData3, SchemaCompatibilityStrategy.BACKWARD), (String)"adding a field without default is NOT backwards compatible");
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(schemaData1, schemaData4, SchemaCompatibilityStrategy.BACKWARD), (String)"Modifying a field name is not backwards compatible");
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData1, schemaData5, SchemaCompatibilityStrategy.BACKWARD), (String)"evolving field to a union is backwards compatible");
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(schemaData5, schemaData1, SchemaCompatibilityStrategy.BACKWARD), (String)"removing a field from a union is NOT backwards compatible");
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData5, schemaData6, SchemaCompatibilityStrategy.BACKWARD), (String)"adding a field to a union is backwards compatible");
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(schemaData6, schemaData5, SchemaCompatibilityStrategy.BACKWARD), (String)"removing a field a union is NOT backwards compatible");
    }

    @Test
    public void testForwardCompatibility() {
        SchemaCompatibilityCheck schemaCompatibilityCheck = this.getSchemaCheck();
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData1, schemaData2, SchemaCompatibilityStrategy.FORWARD), (String)"adding a field is forward compatible");
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData1, schemaData3, SchemaCompatibilityStrategy.FORWARD), (String)"adding a field is forward compatible");
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData2, schemaData3, SchemaCompatibilityStrategy.FORWARD), (String)"adding a field is forward compatible");
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData3, schemaData2, SchemaCompatibilityStrategy.FORWARD), (String)"adding a field is forward compatible");
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData3, schemaData2, SchemaCompatibilityStrategy.FORWARD), (String)"adding a field is forward compatible");
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData2, schemaData7, SchemaCompatibilityStrategy.FORWARD), (String)"removing fields is forward compatible");
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData2, schemaData1, SchemaCompatibilityStrategy.FORWARD), (String)"removing fields with defaults forward compatible");
    }

    @Test
    public void testFullCompatibility() {
        SchemaCompatibilityCheck schemaCompatibilityCheck = this.getSchemaCheck();
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(schemaData1, schemaData2, SchemaCompatibilityStrategy.FULL), (String)"adding a field with default fully compatible");
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(schemaData1, schemaData3, SchemaCompatibilityStrategy.FULL), (String)"adding a field without default is not fully compatible");
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(schemaData3, schemaData1, SchemaCompatibilityStrategy.FULL), (String)"adding a field without default is not fully compatible");
    }

    @Test
    public void testBackwardTransitive() {
        SchemaCompatibilityCheck schemaCompatibilityCheck = this.getSchemaCheck();
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2), schemaData5, SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE));
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2, schemaData5), schemaData6, SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE));
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(Collections.singletonList(schemaData2), schemaData8, SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE));
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2), schemaData8, SchemaCompatibilityStrategy.BACKWARD));
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2), schemaData8, SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE));
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2, schemaData5), schemaData8, SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE));
    }

    @Test
    public void testForwardTransitive() {
        SchemaCompatibilityCheck schemaCompatibilityCheck = this.getSchemaCheck();
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2), schemaData3, SchemaCompatibilityStrategy.FORWARD_TRANSITIVE));
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2, schemaData3), schemaData7, SchemaCompatibilityStrategy.FORWARD_TRANSITIVE));
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData3, schemaData2), schemaData1, SchemaCompatibilityStrategy.FORWARD));
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData3, schemaData2), schemaData1, SchemaCompatibilityStrategy.FORWARD_TRANSITIVE));
    }

    @Test
    public void testFullTransitive() {
        SchemaCompatibilityCheck schemaCompatibilityCheck = this.getSchemaCheck();
        Assert.assertTrue((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2), schemaData3, SchemaCompatibilityStrategy.FULL));
        Assert.assertFalse((boolean)schemaCompatibilityCheck.isCompatible(Arrays.asList(schemaData1, schemaData2), schemaData3, SchemaCompatibilityStrategy.FULL_TRANSITIVE));
    }

    private static SchemaData getSchemaData(String schemaJson) {
        return SchemaData.builder().data(schemaJson.getBytes()).type(SchemaType.AVRO).build();
    }
}

