/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ClientGetSchemaTest
extends ProducerConsumerBase {
    private static final String topicBytes = "my-property/my-ns/topic-bytes";
    private static final String topicString = "my-property/my-ns/topic-string";
    private static final String topicJson = "my-property/my-ns/topic-json";
    private static final String topicAvro = "my-property/my-ns/topic-avro";
    private static final String topicJsonNotNull = "my-property/my-ns/topic-json-not-null";
    private static final String topicAvroNotNull = "my-property/my-ns/topic-avro-not-null";
    List<Producer<?>> producers = new ArrayList();

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        this.producers.add(this.pulsarClient.newProducer(Schema.BYTES).topic(topicBytes).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.STRING).topic(topicString).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.AVRO(MyClass.class)).topic(topicAvro).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.JSON(MyClass.class)).topic(topicJson).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withPojo(MyClass.class).build())).topic(topicAvro).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.JSON((SchemaDefinition)SchemaDefinition.builder().withPojo(MyClass.class).build())).topic(topicJson).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withPojo(MyClass.class).withAlwaysAllowNull(false).build())).topic(topicAvroNotNull).create());
        this.producers.add(this.pulsarClient.newProducer(Schema.JSON((SchemaDefinition)SchemaDefinition.builder().withPojo(MyClass.class).withAlwaysAllowNull(false).build())).topic(topicJsonNotNull).create());
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        this.producers.forEach(t -> {
            try {
                t.close();
            }
            catch (PulsarClientException pulsarClientException) {
                // empty catch block
            }
        });
        super.internalCleanup();
    }

    @DataProvider(name="serviceUrl")
    public String[] serviceUrls() {
        return new String[]{"pulsar://" + this.pulsar.getAdvertisedAddress() + ":" + this.BROKER_PORT, "http://" + this.pulsar.getAdvertisedAddress() + ":" + this.BROKER_WEBSERVICE_PORT};
    }

    @Test(dataProvider="serviceUrl")
    public void testGetSchema(String serviceUrl) throws Exception {
        PulsarClientImpl client = (PulsarClientImpl)PulsarClient.builder().serviceUrl(serviceUrl).build();
        try {
            Assert.assertEquals(client.getSchema("non-existing-topic").join(), Optional.empty());
            Assert.assertEquals(client.getSchema(topicBytes).join(), Optional.empty());
            Assert.assertEquals(client.getSchema(topicString).join(), Optional.of(Schema.STRING.getSchemaInfo()));
            Assert.assertEquals(client.getSchema(topicJson).join(), Optional.of(Schema.JSON(MyClass.class).getSchemaInfo()));
            Assert.assertEquals(client.getSchema(topicAvro).join(), Optional.of(Schema.AVRO(MyClass.class).getSchemaInfo()));
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    private static class MyClass {
        public String name;
        public int age;

        private MyClass() {
        }
    }
}

