/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.service.schema.LongSchemaVersion;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryServiceImpl;
import org.apache.pulsar.broker.service.schema.SchemaStorage;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SchemaServiceTest
extends MockedPulsarServiceBaseTest {
    private static Clock MockClock = Clock.fixed(Instant.EPOCH, ZoneId.systemDefault());
    private String schemaId1 = "1/2/3/4";
    private String userId = "user";
    private SchemaData schema1 = SchemaData.builder().user(this.userId).type(SchemaType.JSON).timestamp(MockClock.millis()).isDeleted(false).data("message { required int64 a = 1};".getBytes()).props(new TreeMap()).build();
    private SchemaData schema2 = SchemaData.builder().user(this.userId).type(SchemaType.JSON).timestamp(MockClock.millis()).isDeleted(false).data("message { required int64 b = 1};".getBytes()).props(new TreeMap()).build();
    private SchemaData schema3 = SchemaData.builder().user(this.userId).type(SchemaType.JSON).timestamp(MockClock.millis()).isDeleted(false).data("message { required int64 c = 1};".getBytes()).props(new TreeMap()).build();
    private SchemaRegistryServiceImpl schemaRegistryService;

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        BookkeeperSchemaStorage storage = new BookkeeperSchemaStorage(this.pulsar);
        storage.init();
        storage.start();
        HashMap<SchemaType, AvroSchemaCompatibilityCheck> checkMap = new HashMap<SchemaType, AvroSchemaCompatibilityCheck>();
        checkMap.put(SchemaType.AVRO, new AvroSchemaCompatibilityCheck());
        this.schemaRegistryService = new SchemaRegistryServiceImpl((SchemaStorage)storage, checkMap, MockClock);
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
        this.schemaRegistryService.close();
    }

    @Test
    public void writeReadBackDeleteSchemaEntry() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        SchemaData latest = this.getLatestSchema(this.schemaId1, this.version(0L));
        AssertJUnit.assertEquals((Object)this.schema1, (Object)latest);
        this.deleteSchema(this.schemaId1, this.version(1L));
        AssertJUnit.assertNull(this.schemaRegistryService.getSchema(this.schemaId1).get());
    }

    @Test
    public void findSchemaVersionTest() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        AssertJUnit.assertEquals((long)0L, (long)((Long)this.schemaRegistryService.findSchemaVersion(this.schemaId1, this.schema1).get()));
    }

    @Test
    public void deleteSchemaAndAddSchema() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        SchemaData latest = this.getLatestSchema(this.schemaId1, this.version(0L));
        AssertJUnit.assertEquals((Object)this.schema1, (Object)latest);
        this.deleteSchema(this.schemaId1, this.version(1L));
        AssertJUnit.assertNull(this.schemaRegistryService.getSchema(this.schemaId1).get());
        this.putSchema(this.schemaId1, this.schema1, this.version(2L));
        latest = this.getLatestSchema(this.schemaId1, this.version(2L));
        AssertJUnit.assertEquals((Object)this.schema1, (Object)latest);
    }

    @Test
    public void getReturnsTheLastWrittenEntry() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        this.putSchema(this.schemaId1, this.schema2, this.version(1L));
        SchemaData latest = this.getLatestSchema(this.schemaId1, this.version(1L));
        AssertJUnit.assertEquals((Object)this.schema2, (Object)latest);
    }

    @Test
    public void getByVersionReturnsTheCorrectEntry() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        this.putSchema(this.schemaId1, this.schema2, this.version(1L));
        SchemaData version0 = this.getSchema(this.schemaId1, this.version(0L));
        AssertJUnit.assertEquals((Object)this.schema1, (Object)version0);
    }

    @Test
    public void getByVersionReturnsTheCorrectEntry2() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        this.putSchema(this.schemaId1, this.schema2, this.version(1L));
        SchemaData version1 = this.getSchema(this.schemaId1, this.version(1L));
        AssertJUnit.assertEquals((Object)this.schema2, (Object)version1);
    }

    @Test
    public void getByVersionReturnsTheCorrectEntry3() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        SchemaData version1 = this.getSchema(this.schemaId1, this.version(0L));
        AssertJUnit.assertEquals((Object)this.schema1, (Object)version1);
    }

    @Test
    public void getAllVersionSchema() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        this.putSchema(this.schemaId1, this.schema2, this.version(1L));
        this.putSchema(this.schemaId1, this.schema3, this.version(2L));
        List<SchemaData> allSchemas = this.getAllSchemas(this.schemaId1);
        AssertJUnit.assertEquals((Object)this.schema1, (Object)allSchemas.get(0));
        AssertJUnit.assertEquals((Object)this.schema2, (Object)allSchemas.get(1));
        AssertJUnit.assertEquals((Object)this.schema3, (Object)allSchemas.get(2));
    }

    @Test
    public void addLotsOfEntriesThenDelete() throws Exception {
        SchemaData randomSchema1 = this.randomSchema();
        SchemaData randomSchema2 = this.randomSchema();
        SchemaData randomSchema3 = this.randomSchema();
        SchemaData randomSchema4 = this.randomSchema();
        SchemaData randomSchema5 = this.randomSchema();
        SchemaData randomSchema6 = this.randomSchema();
        SchemaData randomSchema7 = this.randomSchema();
        this.putSchema(this.schemaId1, randomSchema1, this.version(0L));
        this.putSchema(this.schemaId1, randomSchema2, this.version(1L));
        this.putSchema(this.schemaId1, randomSchema3, this.version(2L));
        this.putSchema(this.schemaId1, randomSchema4, this.version(3L));
        this.putSchema(this.schemaId1, randomSchema5, this.version(4L));
        this.putSchema(this.schemaId1, randomSchema6, this.version(5L));
        this.putSchema(this.schemaId1, randomSchema7, this.version(6L));
        SchemaData version0 = this.getSchema(this.schemaId1, this.version(0L));
        AssertJUnit.assertEquals((Object)randomSchema1, (Object)version0);
        SchemaData version1 = this.getSchema(this.schemaId1, this.version(1L));
        AssertJUnit.assertEquals((Object)randomSchema2, (Object)version1);
        SchemaData version2 = this.getSchema(this.schemaId1, this.version(2L));
        AssertJUnit.assertEquals((Object)randomSchema3, (Object)version2);
        SchemaData version3 = this.getSchema(this.schemaId1, this.version(3L));
        AssertJUnit.assertEquals((Object)randomSchema4, (Object)version3);
        SchemaData version4 = this.getSchema(this.schemaId1, this.version(4L));
        AssertJUnit.assertEquals((Object)randomSchema5, (Object)version4);
        SchemaData version5 = this.getSchema(this.schemaId1, this.version(5L));
        AssertJUnit.assertEquals((Object)randomSchema6, (Object)version5);
        SchemaData version6 = this.getSchema(this.schemaId1, this.version(6L));
        AssertJUnit.assertEquals((Object)randomSchema7, (Object)version6);
        this.deleteSchema(this.schemaId1, this.version(7L));
        SchemaData version7 = this.getSchema(this.schemaId1, this.version(7L));
        AssertJUnit.assertTrue((boolean)version7.isDeleted());
    }

    @Test
    public void writeSchemasToDifferentIds() throws Exception {
        SchemaData schemaWithDifferentId = this.schema3;
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        String schemaId2 = "id2";
        this.putSchema(schemaId2, schemaWithDifferentId, this.version(0L));
        SchemaData withFirstId = this.getLatestSchema(this.schemaId1, this.version(0L));
        SchemaData withDifferentId = this.getLatestSchema(schemaId2, this.version(0L));
        AssertJUnit.assertEquals((Object)this.schema1, (Object)withFirstId);
        AssertJUnit.assertEquals((Object)this.schema3, (Object)withDifferentId);
    }

    @Test
    public void dontReAddExistingSchemaAtRoot() throws Exception {
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
        this.putSchema(this.schemaId1, this.schema1, this.version(0L));
    }

    @Test
    public void trimDeletedSchemaAndGetListTest() throws Exception {
        ArrayList<SchemaRegistry.SchemaAndMetadata> list = new ArrayList<SchemaRegistry.SchemaAndMetadata>();
        CompletableFuture put = this.schemaRegistryService.putSchemaIfAbsent(this.schemaId1, this.schema1, SchemaCompatibilityStrategy.FULL);
        SchemaVersion newVersion = (SchemaVersion)put.get();
        list.add(new SchemaRegistry.SchemaAndMetadata(this.schemaId1, this.schema1, newVersion));
        put = this.schemaRegistryService.putSchemaIfAbsent(this.schemaId1, this.schema2, SchemaCompatibilityStrategy.FULL);
        newVersion = (SchemaVersion)put.get();
        list.add(new SchemaRegistry.SchemaAndMetadata(this.schemaId1, this.schema2, newVersion));
        List list1 = (List)this.schemaRegistryService.trimDeletedSchemaAndGetList(this.schemaId1).get();
        AssertJUnit.assertEquals((int)list.size(), (int)list1.size());
        HashFunction hashFunction = Hashing.sha256();
        for (int i = 0; i < list.size(); ++i) {
            SchemaRegistry.SchemaAndMetadata schemaAndMetadata1 = (SchemaRegistry.SchemaAndMetadata)list.get(i);
            SchemaRegistry.SchemaAndMetadata schemaAndMetadata2 = (SchemaRegistry.SchemaAndMetadata)list1.get(i);
            AssertJUnit.assertEquals((byte[])hashFunction.hashBytes(schemaAndMetadata1.schema.getData()).asBytes(), (byte[])hashFunction.hashBytes(schemaAndMetadata2.schema.getData()).asBytes());
            AssertJUnit.assertEquals((long)((LongSchemaVersion)schemaAndMetadata1.version).getVersion(), (long)((LongSchemaVersion)schemaAndMetadata2.version).getVersion());
            AssertJUnit.assertEquals((String)schemaAndMetadata1.id, (String)schemaAndMetadata2.id);
        }
    }

    @Test
    public void dontReAddExistingSchemaInMiddle() throws Exception {
        this.putSchema(this.schemaId1, this.randomSchema(), this.version(0L));
        this.putSchema(this.schemaId1, this.schema2, this.version(1L));
        this.putSchema(this.schemaId1, this.randomSchema(), this.version(2L));
        this.putSchema(this.schemaId1, this.randomSchema(), this.version(3L));
        this.putSchema(this.schemaId1, this.randomSchema(), this.version(4L));
        this.putSchema(this.schemaId1, this.randomSchema(), this.version(5L));
        this.putSchema(this.schemaId1, this.schema2, this.version(1L));
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void checkIsCompatible() throws Exception {
        String schemaJson1 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}";
        SchemaData schemaData1 = this.getSchemaData(schemaJson1);
        String schemaJson2 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\",\"default\":\"foo\"}]}";
        SchemaData schemaData2 = this.getSchemaData(schemaJson2);
        String schemaJson3 = "{\"type\":\"record\",\"name\":\"DefaultTest\",\"namespace\":\"org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheckTest$\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"string\"}]}";
        SchemaData schemaData3 = this.getSchemaData(schemaJson3);
        this.putSchema(this.schemaId1, schemaData1, this.version(0L), SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE);
        this.putSchema(this.schemaId1, schemaData2, this.version(1L), SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE);
        AssertJUnit.assertTrue((boolean)((Boolean)this.schemaRegistryService.isCompatible(this.schemaId1, schemaData3, SchemaCompatibilityStrategy.BACKWARD).get()));
        AssertJUnit.assertFalse((boolean)((Boolean)this.schemaRegistryService.isCompatible(this.schemaId1, schemaData3, SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE).get()));
        this.putSchema(this.schemaId1, schemaData3, this.version(2L), SchemaCompatibilityStrategy.BACKWARD_TRANSITIVE);
    }

    private void putSchema(String schemaId, SchemaData schema, SchemaVersion expectedVersion) throws Exception {
        this.putSchema(schemaId, schema, expectedVersion, SchemaCompatibilityStrategy.FULL);
    }

    private void putSchema(String schemaId, SchemaData schema, SchemaVersion expectedVersion, SchemaCompatibilityStrategy strategy) throws ExecutionException, InterruptedException {
        CompletableFuture put = this.schemaRegistryService.putSchemaIfAbsent(schemaId, schema, strategy);
        SchemaVersion newVersion = (SchemaVersion)put.get();
        AssertJUnit.assertEquals((Object)expectedVersion, (Object)newVersion);
    }

    private SchemaData getLatestSchema(String schemaId, SchemaVersion expectedVersion) throws Exception {
        SchemaRegistry.SchemaAndMetadata schemaAndVersion = (SchemaRegistry.SchemaAndMetadata)this.schemaRegistryService.getSchema(schemaId).get();
        AssertJUnit.assertEquals((Object)expectedVersion, (Object)schemaAndVersion.version);
        AssertJUnit.assertEquals((String)schemaId, (String)schemaAndVersion.id);
        return schemaAndVersion.schema;
    }

    private SchemaData getSchema(String schemaId, SchemaVersion version) throws Exception {
        SchemaRegistry.SchemaAndMetadata schemaAndVersion = (SchemaRegistry.SchemaAndMetadata)this.schemaRegistryService.getSchema(schemaId, version).get();
        AssertJUnit.assertEquals((Object)version, (Object)schemaAndVersion.version);
        AssertJUnit.assertEquals((String)schemaId, (String)schemaAndVersion.id);
        return schemaAndVersion.schema;
    }

    private List<SchemaData> getAllSchemas(String schemaId) throws Exception {
        ArrayList<SchemaData> result = new ArrayList<SchemaData>();
        for (CompletableFuture schema : (List)this.schemaRegistryService.getAllSchemas(schemaId).get()) {
            result.add(((SchemaRegistry.SchemaAndMetadata)schema.get()).schema);
        }
        return result;
    }

    private void deleteSchema(String schemaId, SchemaVersion expectedVersion) throws Exception {
        SchemaVersion version = (SchemaVersion)this.schemaRegistryService.deleteSchema(schemaId, this.userId).get();
        AssertJUnit.assertEquals((Object)expectedVersion, (Object)version);
    }

    private SchemaData randomSchema() {
        UUID randomString = UUID.randomUUID();
        return SchemaData.builder().user(this.userId).type(SchemaType.JSON).timestamp(MockClock.millis()).isDeleted(false).data(randomString.toString().getBytes()).props(new TreeMap()).build();
    }

    private SchemaData getSchemaData(String schemaJson) {
        return SchemaData.builder().data(schemaJson.getBytes()).type(SchemaType.AVRO).user(this.userId).build();
    }

    private SchemaVersion version(long version) {
        return new LongSchemaVersion(version);
    }
}

