/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.utils;

import com.google.common.collect.Queues;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.util.Queue;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.protocol.PulsarDecoder;

public class ClientChannelHelper {
    private EmbeddedChannel channel;
    private Queue<Object> queue = Queues.newArrayDeque();
    private PulsarDecoder decoder = new PulsarDecoder(){

        protected void messageReceived() {
        }

        protected void handleConnect(PulsarApi.CommandConnect connect) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandConnect.newBuilder((PulsarApi.CommandConnect)connect).build());
        }

        protected void handleConnected(PulsarApi.CommandConnected connected) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandConnected.newBuilder((PulsarApi.CommandConnected)connected).build());
        }

        protected void handleSubscribe(PulsarApi.CommandSubscribe subscribe) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandSubscribe.newBuilder((PulsarApi.CommandSubscribe)subscribe).build());
        }

        protected void handleProducer(PulsarApi.CommandProducer producer) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandProducer.newBuilder((PulsarApi.CommandProducer)producer).build());
        }

        protected void handleSend(PulsarApi.CommandSend send, ByteBuf headersAndPayload) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandSend.newBuilder((PulsarApi.CommandSend)send).build());
        }

        protected void handleSendReceipt(PulsarApi.CommandSendReceipt sendReceipt) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandSendReceipt.newBuilder((PulsarApi.CommandSendReceipt)sendReceipt).build());
        }

        protected void handleSendError(PulsarApi.CommandSendError sendError) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandSendError.newBuilder((PulsarApi.CommandSendError)sendError).build());
        }

        protected void handleMessage(PulsarApi.CommandMessage cmdMessage, ByteBuf headersAndPayload) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandMessage.newBuilder((PulsarApi.CommandMessage)cmdMessage).build());
        }

        protected void handleAck(PulsarApi.CommandAck ack) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandAck.newBuilder((PulsarApi.CommandAck)ack).build());
        }

        protected void handleFlow(PulsarApi.CommandFlow flow) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandFlow.newBuilder((PulsarApi.CommandFlow)flow).build());
        }

        protected void handleUnsubscribe(PulsarApi.CommandUnsubscribe unsubscribe) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandUnsubscribe.newBuilder((PulsarApi.CommandUnsubscribe)unsubscribe));
        }

        protected void handleSuccess(PulsarApi.CommandSuccess success) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandSuccess.newBuilder((PulsarApi.CommandSuccess)success).build());
        }

        protected void handleError(PulsarApi.CommandError error) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandError.newBuilder((PulsarApi.CommandError)error).build());
        }

        protected void handleCloseProducer(PulsarApi.CommandCloseProducer closeProducer) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandCloseProducer.newBuilder((PulsarApi.CommandCloseProducer)closeProducer).build());
        }

        protected void handleCloseConsumer(PulsarApi.CommandCloseConsumer closeConsumer) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandCloseConsumer.newBuilder((PulsarApi.CommandCloseConsumer)closeConsumer).build());
        }

        protected void handleProducerSuccess(PulsarApi.CommandProducerSuccess success) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandProducerSuccess.newBuilder((PulsarApi.CommandProducerSuccess)success).build());
        }

        protected void handleLookupResponse(PulsarApi.CommandLookupTopicResponse connection) {
            ClientChannelHelper.this.queue.offer(PulsarApi.CommandLookupTopicResponse.newBuilder((PulsarApi.CommandLookupTopicResponse)connection).build());
        }
    };

    public ClientChannelHelper() {
        int MaxMessageSize = 0x500000;
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(MaxMessageSize, 0, 4, 0, 4), this.decoder});
    }

    public Object getCommand(Object obj) {
        this.channel.writeInbound(new Object[]{obj});
        return this.queue.poll();
    }
}

