/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGenerator;
import org.apache.pulsar.client.api.Producer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PrometheusMetricsTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testPerTopicStats() throws Exception {
        Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (OutputStream)statsOut);
        String metricsStr = new String(statsOut.toByteArray());
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
        List cm = (List)metrics.get((Object)"pulsar_storage_write_latency_le_1");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_producers_count");
        Assert.assertEquals((int)cm.size(), (int)3);
        Assert.assertEquals((Object)((Metric)cm.get((int)1)).value, (Object)1.0);
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((Object)((Metric)cm.get((int)2)).value, (Object)1.0);
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"topic_load_times_count");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((Object)((Metric)cm.get((int)0)).value, (Object)2.0);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        p1.close();
        p2.close();
    }

    @Test
    public void testPerNamespaceStats() throws Exception {
        Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = new String(statsOut.toByteArray());
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
        List cm = (List)metrics.get((Object)"pulsar_storage_write_latency_le_1");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertNull((Object)((Metric)cm.get((int)0)).tags.get("topic"));
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_producers_count");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((Object)((Metric)cm.get((int)1)).value, (Object)2.0);
        Assert.assertNull((Object)((Metric)cm.get((int)1)).tags.get("topic"));
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        p1.close();
        p2.close();
    }

    @Test(invocationCount=2)
    public void testDuplicateMetricTypeDefinitions() throws Exception {
        Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = new String(statsOut.toByteArray());
        HashMap typeDefs = new HashMap();
        HashMap metricNames = new HashMap();
        Pattern typePattern = Pattern.compile("^#\\s+TYPE\\s+(\\w+)\\s+(\\w+)");
        Pattern metricNamePattern = Pattern.compile("^(\\w+)\\{.+");
        Splitter.on((String)"\n").split((CharSequence)metricsStr).forEach(line -> {
            if (line.isEmpty()) {
                return;
            }
            if (line.startsWith("#")) {
                Matcher typeMatcher = typePattern.matcher((CharSequence)line);
                Preconditions.checkArgument((boolean)typeMatcher.matches());
                String metricName = typeMatcher.group(1);
                String type = typeMatcher.group(2);
                if (!typeDefs.containsKey(metricName)) {
                    typeDefs.put(metricName, type);
                } else {
                    Assert.fail((String)("Duplicate type definition found for TYPE definition " + metricName));
                    System.out.println(metricsStr);
                }
                if (metricNames.containsKey(metricName)) {
                    System.out.println(metricsStr);
                    Assert.fail((String)("TYPE definition for " + metricName + " appears after first sample"));
                }
            } else {
                Matcher metricMatcher = metricNamePattern.matcher((CharSequence)line);
                Preconditions.checkArgument((boolean)metricMatcher.matches());
                String metricName = metricMatcher.group(1);
                metricNames.put(metricName, metricName);
            }
        });
        for (String metricName : metricNames.keySet()) {
            String summaryMetricName;
            if (typeDefs.containsKey(metricName)) continue;
            if (metricName.endsWith("_sum")) {
                summaryMetricName = metricName.substring(0, metricName.indexOf("_sum"));
                if (typeDefs.containsKey(summaryMetricName)) continue;
                Assert.fail((String)("Metric " + metricName + " does not have a corresponding summary type definition"));
                continue;
            }
            if (metricName.endsWith("_count")) {
                summaryMetricName = metricName.substring(0, metricName.indexOf("_count"));
                if (typeDefs.containsKey(summaryMetricName)) continue;
                Assert.fail((String)("Metric " + metricName + " does not have a corresponding summary type definition"));
                continue;
            }
            Assert.fail((String)("Metric " + metricName + " does not have a type definition"));
        }
        p1.close();
        p2.close();
    }

    private static Multimap<String, Metric> parseMetrics(String metrics) {
        ArrayListMultimap parsed = ArrayListMultimap.create();
        Pattern pattern = Pattern.compile("^(\\w+)\\{([^\\}]+)\\}\\s(-?[\\d\\w\\.]+)(\\s(\\d+))?$");
        Pattern tagsPattern = Pattern.compile("(\\w+)=\"([^\"]+)\"(,\\s?)?");
        Splitter.on((String)"\n").split((CharSequence)metrics).forEach(arg_0 -> PrometheusMetricsTest.lambda$parseMetrics$3(pattern, tagsPattern, (Multimap)parsed, arg_0));
        return parsed;
    }

    private static /* synthetic */ void lambda$parseMetrics$3(Pattern pattern, Pattern tagsPattern, Multimap parsed, String line) {
        if (line.isEmpty() || line.startsWith("#")) {
            return;
        }
        Matcher matcher = pattern.matcher(line);
        Preconditions.checkArgument((boolean)matcher.matches());
        String name = matcher.group(1);
        Metric m = new Metric();
        m.value = Double.valueOf(matcher.group(3));
        String tags = matcher.group(2);
        Matcher tagsMatcher = tagsPattern.matcher(tags);
        while (tagsMatcher.find()) {
            String tag = tagsMatcher.group(1);
            String value = tagsMatcher.group(2);
            m.tags.put(tag, value);
        }
        parsed.put((Object)name, (Object)m);
    }

    static class Metric {
        Map<String, String> tags = new TreeMap<String, String>();
        double value;

        Metric() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tags", this.tags).add("value", this.value).toString();
        }
    }
}

