/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.zookeeper;

import com.google.common.collect.Sets;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.zookeeper.KeeperException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ZooKeeperSessionExpireRecoveryTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testSessionExpired() throws Exception {
        this.admin.clusters().createCluster("my-cluster", new ClusterData("test-url"));
        Assert.assertTrue((boolean)Sets.newHashSet((Iterable)this.admin.clusters().getClusters()).contains("my-cluster"));
        this.mockZookKeeper.failNow(KeeperException.Code.SESSIONEXPIRED);
        Assert.assertTrue((boolean)Sets.newHashSet((Iterable)this.admin.clusters().getClusters()).contains("my-cluster"));
        try {
            this.admin.clusters().createCluster("my-cluster-2", new ClusterData("test-url"));
            Assert.fail((String)"Should have failed, because global zk is down");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        this.admin.clusters().createCluster("cluster-2", new ClusterData("test-url"));
    }
}

