/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataCommand;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authorization.AuthorizationProvider;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class AuthorizationProducerConsumerTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationProducerConsumerTest.class);
    private static final String clientRole = "plugbleRole";
    private static final Set<String> clientAuthProviderSupportedRoles = Sets.newHashSet((Object[])new String[]{"plugbleRole"});

    @Override
    protected void setup() throws Exception {
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthorizationEnabled(true);
        HashSet<String> superUserRoles = new HashSet<String>();
        superUserRoles.add("superUser");
        this.conf.setSuperUserRoles(superUserRoles);
        HashSet<String> providers = new HashSet<String>();
        providers.add(TestAuthenticationProvider.class.getName());
        this.conf.setAuthenticationProviders(providers);
        this.conf.setClusterName("test");
        super.init();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testProducerAndConsumerAuthorization() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(TestAuthorizationProvider.class.getName());
        this.setup();
        ClientAuthentication adminAuthentication = new ClientAuthentication("superUser");
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)adminAuthentication).build());
        String lookupUrl = new URI("pulsar://localhost:" + this.BROKER_PORT).toString();
        ClientAuthentication authentication = new ClientAuthentication(clientRole);
        ClientAuthentication authenticationInvalidRole = new ClientAuthentication("test-role");
        this.pulsarClient = PulsarClient.builder().serviceUrl(lookupUrl).authentication((Authentication)authentication).build();
        PulsarClient pulsarClientInvalidRole = PulsarClient.builder().serviceUrl(lookupUrl).authentication((Authentication)authenticationInvalidRole).build();
        this.admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
        this.admin.tenants().createTenant("my-property", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("my-property/my-ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscriber-name").subscribe();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://my-property/my-ns/my-topic").create();
        consumer.close();
        producer.close();
        try {
            consumer = pulsarClientInvalidRole.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscriber-name").subscribe();
            Assert.fail((String)"should have failed with authorization error");
        }
        catch (PulsarClientException.AuthorizationException authorizationException) {
            // empty catch block
        }
        try {
            producer = pulsarClientInvalidRole.newProducer().topic("persistent://my-property/my-ns/my-topic").create();
            Assert.fail((String)"should have failed with authorization error");
        }
        catch (PulsarClientException.AuthorizationException authorizationException) {
            // empty catch block
        }
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test
    public void testSubscriberPermission() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(PulsarAuthorizationProvider.class.getName());
        this.setup();
        String tenantRole = "tenant-role";
        String subscriptionRole = "sub1-role";
        String subscriptionName = "sub1";
        String namespace = "my-property/my-ns-sub-auth";
        String topicName = "persistent://my-property/my-ns-sub-auth/my-topic";
        ClientAuthentication adminAuthentication = new ClientAuthentication("superUser");
        clientAuthProviderSupportedRoles.add("sub1-role");
        PulsarAdmin superAdmin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)adminAuthentication).build());
        ClientAuthentication tenantAdminAuthentication = new ClientAuthentication("tenant-role");
        PulsarAdmin tenantAdmin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)tenantAdminAuthentication).build());
        ClientAuthentication subAdminAuthentication = new ClientAuthentication("sub1-role");
        PulsarAdmin sub1Admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)subAdminAuthentication).build());
        String lookupUrl = new URI("pulsar://localhost:" + this.BROKER_PORT).toString();
        ClientAuthentication authentication = new ClientAuthentication("sub1-role");
        superAdmin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
        superAdmin.tenants().createTenant("my-property", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"tenant-role"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        superAdmin.namespaces().createNamespace("my-property/my-ns-sub-auth", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        tenantAdmin.namespaces().grantPermissionOnNamespace("my-property/my-ns-sub-auth", "sub1-role", Collections.singleton(AuthAction.consume));
        this.pulsarClient = PulsarClient.builder().serviceUrl(lookupUrl).authentication((Authentication)authentication).build();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns-sub-auth/my-topic"}).subscriptionName("sub1").subscribe();
        consumer.close();
        tenantAdmin.topics().skipAllMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1");
        tenantAdmin.topics().skipMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 1L);
        tenantAdmin.topics().expireMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
        tenantAdmin.topics().peekMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 1);
        tenantAdmin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
        tenantAdmin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", MessageId.earliest);
        tenantAdmin.namespaces().grantPermissionOnNamespace("my-property/my-ns-sub-auth", "sub1-role", Collections.singleton(AuthAction.consume));
        sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
        String otherPrincipal = "Principal-1-to-access-sub";
        superAdmin.namespaces().grantPermissionOnSubscription("my-property/my-ns-sub-auth", "sub1", Collections.singleton(otherPrincipal));
        try {
            sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
            Assert.fail((String)"should have fail with authorization exception");
        }
        catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
        superAdmin.namespaces().grantPermissionOnSubscription("my-property/my-ns-sub-auth", "sub1", (Set)Sets.newHashSet((Object[])new String[]{otherPrincipal, "sub1-role"}));
        sub1Admin.topics().skipAllMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1");
        sub1Admin.topics().skipMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 1L);
        sub1Admin.topics().expireMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
        sub1Admin.topics().peekMessages("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 1);
        sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
        sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", MessageId.earliest);
        superAdmin.namespaces().revokePermissionOnSubscription("my-property/my-ns-sub-auth", "sub1", "sub1-role");
        try {
            sub1Admin.topics().resetCursor("persistent://my-property/my-ns-sub-auth/my-topic", "sub1", 10L);
            Assert.fail((String)"should have fail with authorization exception");
        }
        catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test
    public void testSubscriptionPrefixAuthorization() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(TestAuthorizationProviderWithSubscriptionPrefix.class.getName());
        this.setup();
        ClientAuthentication adminAuthentication = new ClientAuthentication("superUser");
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl.toString()).authentication((Authentication)adminAuthentication).build());
        String lookupUrl = new URI("pulsar://localhost:" + this.BROKER_PORT).toString();
        ClientAuthentication authentication = new ClientAuthentication(clientRole);
        this.pulsarClient = PulsarClient.builder().serviceUrl(lookupUrl).authentication((Authentication)authentication).build();
        this.admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
        this.admin.tenants().createTenant("prop-prefix", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("prop-prefix/ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-prefix/ns/t1"}).subscriptionName("plugbleRole-sub1").subscribe();
        consumer.close();
        try {
            consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-prefix/ns/t1"}).subscriptionName("sub1").subscribe();
            Assert.fail((String)"should have failed with authorization error");
        }
        catch (PulsarClientException.AuthorizationException authorizationException) {
            // empty catch block
        }
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test
    public void testGrantPermission() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(TestAuthorizationProviderWithGrantPermission.class.getName());
        this.setup();
        AuthorizationService authorizationService = new AuthorizationService(this.conf, null);
        TopicName topicName = TopicName.get((String)"persistent://prop/cluster/ns/t1");
        String role = "test-role";
        Assert.assertFalse((boolean)authorizationService.canProduce(topicName, role, null));
        Assert.assertFalse((boolean)authorizationService.canConsume(topicName, role, null, "sub1"));
        authorizationService.grantPermissionAsync(topicName, null, role, "auth-json").get();
        Assert.assertTrue((boolean)authorizationService.canProduce(topicName, role, null));
        Assert.assertTrue((boolean)authorizationService.canConsume(topicName, role, null, "sub1"));
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test
    public void testAuthData() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setAuthorizationProvider(TestAuthorizationProviderWithGrantPermission.class.getName());
        this.setup();
        AuthorizationService authorizationService = new AuthorizationService(this.conf, null);
        TopicName topicName = TopicName.get((String)"persistent://prop/cluster/ns/t1");
        String role = "test-role";
        authorizationService.grantPermissionAsync(topicName, null, role, "auth-json").get();
        Assert.assertEquals((String)TestAuthorizationProviderWithGrantPermission.authDataJson, (String)"auth-json");
        Assert.assertTrue((boolean)authorizationService.canProduce(topicName, role, (AuthenticationDataSource)new AuthenticationDataCommand("prod-auth")));
        Assert.assertEquals((String)TestAuthorizationProviderWithGrantPermission.authenticationData.getCommandData(), (String)"prod-auth");
        Assert.assertTrue((boolean)authorizationService.canConsume(topicName, role, (AuthenticationDataSource)new AuthenticationDataCommand("cons-auth"), "sub1"));
        Assert.assertEquals((String)TestAuthorizationProviderWithGrantPermission.authenticationData.getCommandData(), (String)"cons-auth");
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    public static class TestAuthorizationProviderWithGrantPermission
    extends TestAuthorizationProvider {
        private Set<String> grantRoles = Sets.newHashSet();
        static AuthenticationDataSource authenticationData;
        static String authDataJson;

        @Override
        public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            TestAuthorizationProviderWithGrantPermission.authenticationData = authenticationData;
            return CompletableFuture.completedFuture(this.grantRoles.contains(role));
        }

        @Override
        public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
            TestAuthorizationProviderWithGrantPermission.authenticationData = authenticationData;
            return CompletableFuture.completedFuture(this.grantRoles.contains(role));
        }

        @Override
        public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            TestAuthorizationProviderWithGrantPermission.authenticationData = authenticationData;
            return CompletableFuture.completedFuture(this.grantRoles.contains(role));
        }

        @Override
        public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespace, Set<AuthAction> actions, String role, String authData) {
            authDataJson = authData;
            this.grantRoles.add(role);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> grantPermissionAsync(TopicName topicname, Set<AuthAction> actions, String role, String authData) {
            authDataJson = authData;
            this.grantRoles.add(role);
            return CompletableFuture.completedFuture(null);
        }
    }

    public static class TestAuthorizationProviderWithSubscriptionPrefix
    extends TestAuthorizationProvider {
        @Override
        public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            if (StringUtils.isNotBlank((CharSequence)subscription) && !subscription.startsWith(role)) {
                future.completeExceptionally(new PulsarServerException("The subscription name needs to be prefixed by the authentication role"));
            }
            future.complete(AuthorizationProducerConsumerTest.clientRole.equals(role));
            return future;
        }
    }

    public static class TestAuthorizationProvider2
    extends TestAuthorizationProvider {
        @Override
        public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(true);
        }

        @Override
        public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
            return CompletableFuture.completedFuture(false);
        }

        @Override
        public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(true);
        }
    }

    public static class TestAuthorizationProvider
    implements AuthorizationProvider {
        public ServiceConfiguration conf;

        public void close() throws IOException {
        }

        public CompletableFuture<Boolean> isSuperUser(String role, ServiceConfiguration serviceConfiguration) {
            Set superUserRoles = serviceConfiguration.getSuperUserRoles();
            return CompletableFuture.completedFuture(role != null && superUserRoles.contains(role));
        }

        public void initialize(ServiceConfiguration conf, ConfigurationCacheService configCache) throws IOException {
            this.conf = conf;
        }

        public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(clientAuthProviderSupportedRoles.contains(role));
        }

        public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
            return CompletableFuture.completedFuture(clientAuthProviderSupportedRoles.contains(role));
        }

        public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
            return CompletableFuture.completedFuture(clientAuthProviderSupportedRoles.contains(role));
        }

        public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
            return null;
        }

        public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespace, Set<AuthAction> actions, String role, String authenticationData) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> grantPermissionAsync(TopicName topicname, Set<AuthAction> actions, String role, String authenticationData) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, String authDataJson) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, String role, String authDataJson) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public static class TestAuthenticationProvider
    implements AuthenticationProvider {
        public void close() throws IOException {
        }

        public void initialize(ServiceConfiguration config) throws IOException {
        }

        public String getAuthMethodName() {
            return "test";
        }

        public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
            return authData.getCommandData() != null ? authData.getCommandData() : authData.getHttpHeader("user");
        }
    }

    public static class ClientAuthentication
    implements Authentication {
        String user;

        public ClientAuthentication(String user) {
            this.user = user;
        }

        public void close() throws IOException {
        }

        public String getAuthMethodName() {
            return "test";
        }

        public AuthenticationDataProvider getAuthData() throws PulsarClientException {
            AuthenticationDataProvider provider = new AuthenticationDataProvider(){

                public boolean hasDataForHttp() {
                    return true;
                }

                public Set<Map.Entry<String, String>> getHttpHeaders() {
                    return Sets.newHashSet((Object[])new Map.Entry[]{Maps.immutableEntry((Object)"user", (Object)user)});
                }

                public boolean hasDataFromCommand() {
                    return true;
                }

                public String getCommandData() {
                    return user;
                }
            };
            return provider;
        }

        public void configure(Map<String, String> authParams) {
        }

        public void start() throws PulsarClientException {
        }
    }
}

