/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ConsumerRedeliveryTest
extends ProducerConsumerBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        this.conf.setManagedLedgerCacheEvictionFrequency(0.1);
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testOrderedRedelivery() throws Exception {
        String topic = "persistent://my-property/my-ns/redelivery";
        this.conf.setManagedLedgerMaxEntriesPerLedger(2);
        this.conf.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
        ProducerBuilder producerBuilder = this.pulsarClient.newProducer().topic(topic).producerName("my-producer-name");
        Producer producer = producerBuilder.create();
        ConsumerBuilder consumerBuilder = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("s1").subscriptionType(SubscriptionType.Shared);
        ConsumerImpl consumer1 = (ConsumerImpl)consumerBuilder.subscribe();
        int totalMsgs = 100;
        for (int i = 0; i < 100; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        int consumedCount = 0;
        HashSet messageIds = Sets.newHashSet();
        for (int i = 0; i < 100; ++i) {
            Message message = consumer1.receive(5, TimeUnit.SECONDS);
            if (message != null && consumedCount % 2 == 0) {
                consumer1.acknowledge(message);
            } else {
                messageIds.add(message.getMessageId());
            }
            ++consumedCount;
        }
        Assert.assertEquals((int)100, (int)consumedCount);
        consumer1.redeliverUnacknowledgedMessages((Set)messageIds);
        MessageIdImpl lastMsgId = null;
        for (int i = 0; i < 50; ++i) {
            Message message = consumer1.receive(5, TimeUnit.SECONDS);
            MessageIdImpl msgId = (MessageIdImpl)message.getMessageId();
            if (lastMsgId != null) {
                Assert.assertTrue((lastMsgId.getLedgerId() <= msgId.getLedgerId() ? 1 : 0) != 0, (String)("lastMsgId: " + lastMsgId + " -- msgId: " + msgId));
            }
            lastMsgId = msgId;
        }
        consumer1.close();
        Consumer consumer2 = consumerBuilder.subscribe();
        lastMsgId = null;
        for (int i = 0; i < 50; ++i) {
            Message message = consumer2.receive(5, TimeUnit.SECONDS);
            MessageIdImpl msgId = (MessageIdImpl)message.getMessageId();
            if (lastMsgId != null) {
                Assert.assertTrue((lastMsgId.getLedgerId() <= msgId.getLedgerId() ? 1 : 0) != 0);
            }
            lastMsgId = msgId;
        }
        producer.close();
        consumer2.close();
    }

    @Test
    public void testUnAckMessageRedeliveryWithReceiveAsync() throws PulsarClientException, ExecutionException, InterruptedException {
        int i;
        String topic = "persistent://my-property/my-ns/async-unack-redelivery";
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("s1").ackTimeout(3L, TimeUnit.SECONDS).subscribe();
        Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).enableBatching(true).batchingMaxMessages(5).batchingMaxPublishDelay(1L, TimeUnit.SECONDS).create();
        int messages = 10;
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(10);
        for (i = 0; i < 10; ++i) {
            futures.add(consumer.receiveAsync());
        }
        for (i = 0; i < 10; ++i) {
            producer.sendAsync((Object)("my-message-" + i));
        }
        int messageReceived = 0;
        for (CompletableFuture future : futures) {
            Message message = (Message)future.get();
            Assert.assertNotNull((Object)message);
            ++messageReceived;
        }
        Assert.assertEquals((int)10, (int)messageReceived);
        for (int i2 = 0; i2 < 10; ++i2) {
            Message message = consumer.receive();
            Assert.assertNotNull((Object)message);
            ++messageReceived;
            consumer.acknowledge(message);
        }
        Assert.assertEquals((int)20, (int)messageReceived);
        producer.close();
        consumer.close();
    }
}

