/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.util.Murmur3_32Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class KeySharedSubscriptionTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(KeySharedSubscriptionTest.class);
    private static final List<String> keys = Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");

    @DataProvider(name="batch")
    public Object[][] batchProvider() {
        return new Object[][]{{false}, {true}};
    }

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testSendAndReceiveWithHashRangeStickyKeyConsumerSelector(boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        int consumer1Slot = 65536;
                        int consumer2Slot = consumer1Slot >> 1;
                        int consumer3Slot = consumer2Slot >> 1;
                        int consumer1ExpectMessages = 0;
                        int consumer2ExpectMessages = 0;
                        int consumer3ExpectMessages = 0;
                        for (int i = 0; i < 10; ++i) {
                            for (String key : keys) {
                                int slot = Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
                                if (slot < consumer3Slot) {
                                    ++consumer3ExpectMessages;
                                } else if (slot < consumer2Slot) {
                                    ++consumer2ExpectMessages;
                                } else {
                                    ++consumer1ExpectMessages;
                                }
                                producer.newMessage().key(key).value((Object)i).send();
                            }
                        }
                        ArrayList<KeyValue<Consumer<Integer>, Integer>> checkList = new ArrayList<KeyValue<Consumer<Integer>, Integer>>();
                        checkList.add(new KeyValue(consumer1, (Object)consumer1ExpectMessages));
                        checkList.add(new KeyValue(consumer2, (Object)consumer2ExpectMessages));
                        checkList.add(new KeyValue(consumer3, (Object)consumer3ExpectMessages));
                        this.receiveAndCheck(checkList);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testConsumerCrashSendAndReceiveWithHashRangeStickyKeyConsumerSelector(boolean enableBatch) throws PulsarClientException, InterruptedException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared_consumer_crash-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        int consumer1Slot = 65536;
                        int consumer2Slot = consumer1Slot >> 1;
                        int consumer3Slot = consumer2Slot >> 1;
                        int consumer1ExpectMessages = 0;
                        int consumer2ExpectMessages = 0;
                        int consumer3ExpectMessages = 0;
                        for (int i = 0; i < 10; ++i) {
                            for (String key : keys) {
                                int slot = Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
                                if (slot < consumer3Slot) {
                                    ++consumer3ExpectMessages;
                                } else if (slot < consumer2Slot) {
                                    ++consumer2ExpectMessages;
                                } else {
                                    ++consumer1ExpectMessages;
                                }
                                producer.newMessage().key(key).value((Object)i).send();
                            }
                        }
                        ArrayList<Object> checkList = new ArrayList<KeyValue<Consumer<Integer>, Integer>>();
                        checkList.add(new KeyValue(consumer1, (Object)consumer1ExpectMessages));
                        checkList.add(new KeyValue(consumer2, (Object)consumer2ExpectMessages));
                        checkList.add(new KeyValue(consumer3, (Object)consumer3ExpectMessages));
                        this.receiveAndCheck(checkList);
                        Thread.sleep(1000L);
                        consumer1.close();
                        consumer2.close();
                        for (int i = 0; i < 10; ++i) {
                            for (String key : keys) {
                                producer.newMessage().key(key).value((Object)i).send();
                            }
                        }
                        checkList = new ArrayList();
                        checkList.add((KeyValue<Consumer<Integer>, Integer>)new KeyValue(consumer3, (Object)100));
                        this.receiveAndCheck(checkList);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testNonKeySendAndReceiveWithHashRangeStickyKeyConsumerSelector(boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared_none_key-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        int consumer1Slot = 65536;
                        int consumer2Slot = consumer1Slot >> 1;
                        int consumer3Slot = consumer2Slot >> 1;
                        for (int i = 0; i < 100; ++i) {
                            producer.newMessage().value((Object)i).send();
                        }
                        int slot = Murmur3_32Hash.getInstance().makeHash("NONE_KEY".getBytes()) % 65536;
                        ArrayList<KeyValue<Consumer<Integer>, Integer>> checkList = new ArrayList<KeyValue<Consumer<Integer>, Integer>>();
                        if (slot < consumer3Slot) {
                            checkList.add(new KeyValue(consumer3, (Object)100));
                        } else if (slot < consumer2Slot) {
                            checkList.add(new KeyValue(consumer2, (Object)100));
                        } else {
                            checkList.add(new KeyValue(consumer1, (Object)100));
                        }
                        this.receiveAndCheck(checkList);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testOrderingKeyWithHashRangeStickyKeyConsumerSelector(boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared_ordering_key-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        int consumer1Slot = 65536;
                        int consumer2Slot = consumer1Slot >> 1;
                        int consumer3Slot = consumer2Slot >> 1;
                        int consumer1ExpectMessages = 0;
                        int consumer2ExpectMessages = 0;
                        int consumer3ExpectMessages = 0;
                        for (int i = 0; i < 10; ++i) {
                            for (String key : keys) {
                                int slot = Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
                                if (slot < consumer3Slot) {
                                    ++consumer3ExpectMessages;
                                } else if (slot < consumer2Slot) {
                                    ++consumer2ExpectMessages;
                                } else {
                                    ++consumer1ExpectMessages;
                                }
                                producer.newMessage().key("any key").orderingKey(key.getBytes()).value((Object)i).send();
                            }
                        }
                        ArrayList<KeyValue<Consumer<Integer>, Integer>> checkList = new ArrayList<KeyValue<Consumer<Integer>, Integer>>();
                        checkList.add(new KeyValue(consumer1, (Object)consumer1ExpectMessages));
                        checkList.add(new KeyValue(consumer2, (Object)consumer2ExpectMessages));
                        checkList.add(new KeyValue(consumer3, (Object)consumer3ExpectMessages));
                        this.receiveAndCheck(checkList);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    @Test(expectedExceptions={PulsarClientException.class})
    public void testDisableKeySharedSubscription() throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(false);
        String topic = "persistent://public/default/key_shared_disabled";
        this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).ackTimeout(10L, TimeUnit.SECONDS).subscribe();
    }

    private Producer<Integer> createProducer(String topic, boolean enableBatch) throws PulsarClientException {
        Producer producer = null;
        producer = enableBatch ? this.pulsarClient.newProducer(Schema.INT32).topic(topic).enableBatching(true).batcherBuilder(BatcherBuilder.KEY_BASED).create() : this.pulsarClient.newProducer(Schema.INT32).topic(topic).enableBatching(false).create();
        return producer;
    }

    private Consumer<Integer> createConsumer(String topic) throws PulsarClientException {
        return this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).ackTimeout(3L, TimeUnit.SECONDS).subscribe();
    }

    private void receiveAndCheck(List<KeyValue<Consumer<Integer>, Integer>> checkList) throws PulsarClientException {
        HashMap<Object, Set> consumerKeys = new HashMap<Object, Set>();
        for (KeyValue<Consumer<Integer>, Integer> check : checkList) {
            if ((Integer)check.getValue() % 2 != 0) {
                throw new IllegalArgumentException();
            }
            int received = 0;
            HashMap<String, Message> lastMessageForKey = new HashMap<String, Message>();
            Integer i = 0;
            while (i < (Integer)check.getValue()) {
                Object message = ((Consumer)check.getKey()).receive();
                if (i % 2 == 0) {
                    ((Consumer)check.getKey()).acknowledge(message);
                }
                Object key = message.hasOrderingKey() ? new String(message.getOrderingKey()) : message.getKey();
                log.info("[{}] Receive message key: {} value: {} messageId: {}", new Object[]{((Consumer)check.getKey()).getConsumerName(), key, message.getValue(), message.getMessageId()});
                if (lastMessageForKey.get(key) == null) {
                    Assert.assertNotNull((Object)message);
                } else {
                    Assert.assertTrue((((Integer)message.getValue()).compareTo((Integer)((Message)lastMessageForKey.get(key)).getValue()) > 0 ? 1 : 0) != 0);
                }
                lastMessageForKey.put((String)key, (Message)message);
                consumerKeys.putIfAbsent(check.getKey(), Sets.newHashSet());
                ((Set)consumerKeys.get(check.getKey())).add(key);
                ++received;
                message = i;
                i = i + 1;
                key = i;
            }
            Assert.assertEquals((int)((Integer)check.getValue()), (int)received);
            int redeliveryCount = (Integer)check.getValue() / 2;
            log.info("[{}] Consumer wait for {} messages redelivery ...", (Object)redeliveryCount);
            lastMessageForKey = new HashMap();
            for (int i2 = 0; i2 < redeliveryCount; ++i2) {
                Message message = ((Consumer)check.getKey()).receive();
                ++received;
                ((Consumer)check.getKey()).acknowledge(message);
                String key = message.hasOrderingKey() ? new String(message.getOrderingKey()) : message.getKey();
                log.info("[{}] Receive redeliver message key: {} value: {} messageId: {}", new Object[]{((Consumer)check.getKey()).getConsumerName(), key, message.getValue(), message.getMessageId()});
                if (lastMessageForKey.get(key) == null) {
                    Assert.assertNotNull((Object)message);
                } else {
                    Assert.assertTrue((((Integer)message.getValue()).compareTo((Integer)((Message)lastMessageForKey.get(key)).getValue()) > 0 ? 1 : 0) != 0);
                }
                lastMessageForKey.put(key, message);
            }
            Message noMessages = null;
            try {
                noMessages = ((Consumer)check.getKey()).receive(100, TimeUnit.MILLISECONDS);
            }
            catch (PulsarClientException pulsarClientException) {
                // empty catch block
            }
            Assert.assertNull(noMessages, (String)"redeliver too many messages.");
            Assert.assertEquals((int)((Integer)check.getValue() + redeliveryCount), (int)received);
        }
        HashSet allKeys = Sets.newHashSet();
        consumerKeys.forEach((k, v) -> v.forEach(key -> Assert.assertTrue((boolean)allKeys.add(key), (String)("Key " + key + "is distributed to multiple consumers."))));
    }
}

