/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.bookkeeper.test.PortManager;
import org.apache.pulsar.client.api.MockBrokerServiceHooks;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.PulsarDecoder;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockBrokerService {
    private final Server server;
    EventLoopGroup workerGroup;
    private final int webServicePort;
    private final int brokerServicePort;
    private final int brokerServicePortTls;
    private MockBrokerServiceHooks.CommandConnectHook handleConnect = null;
    private MockBrokerServiceHooks.CommandTopicLookupHook handleTopiclookup = null;
    private MockBrokerServiceHooks.CommandPartitionLookupHook handlePartitionlookup = null;
    private MockBrokerServiceHooks.CommandSubscribeHook handleSubscribe = null;
    private MockBrokerServiceHooks.CommandProducerHook handleProducer = null;
    private MockBrokerServiceHooks.CommandSendHook handleSend = null;
    private MockBrokerServiceHooks.CommandAckHook handleAck = null;
    private MockBrokerServiceHooks.CommandFlowHook handleFlow = null;
    private MockBrokerServiceHooks.CommandUnsubscribeHook handleUnsubscribe = null;
    private MockBrokerServiceHooks.CommandCloseProducerHook handleCloseProducer = null;
    private MockBrokerServiceHooks.CommandCloseConsumerHook handleCloseConsumer = null;
    private static final Logger log = LoggerFactory.getLogger(MockBrokerService.class);

    public MockBrokerService() {
        this(PortManager.nextFreePort(), PortManager.nextFreePort(), PortManager.nextFreePort(), PortManager.nextFreePort());
    }

    public MockBrokerService(int webServicePort, int webServicePortTls, int brokerServicePort, int brokerServicePortTls) {
        this.webServicePort = webServicePort;
        this.brokerServicePort = brokerServicePort;
        this.brokerServicePortTls = brokerServicePortTls;
        this.server = new Server(webServicePort);
        this.server.setHandler((Handler)new genericResponseHandler());
    }

    public void start() {
        try {
            this.server.start();
            log.info("Started web service on http://127.0.0.1:{}", (Object)this.webServicePort);
            this.startMockBrokerService();
            log.info("Started mock Pulsar service on http://127.0.0.1:{}", (Object)this.brokerServicePort);
        }
        catch (Exception e) {
            log.error("Error starting mock service", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
            this.workerGroup.shutdownGracefully();
        }
        catch (Exception e) {
            log.error("Error stopping mock service", (Throwable)e);
        }
    }

    public void startMockBrokerService() throws Exception {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("mock-pulsar-%s").build();
        int numThreads = 2;
        int MaxMessageSize = 0x500000;
        this.workerGroup = EventLoopUtil.newEventLoopGroup((int)2, (ThreadFactory)threadFactory);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.workerGroup, this.workerGroup);
        bootstrap.channel(EventLoopUtil.getServerSocketChannelClass((EventLoopGroup)this.workerGroup));
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
                ch.pipeline().addLast("handler", (ChannelHandler)new MockServerCnx());
            }
        });
        bootstrap.bind(this.brokerServicePort).sync();
    }

    public void setHandleConnect(MockBrokerServiceHooks.CommandConnectHook hook) {
        this.handleConnect = hook;
    }

    public void resetHandleConnect() {
        this.handleConnect = null;
    }

    public void setHandlePartitionLookup(MockBrokerServiceHooks.CommandPartitionLookupHook hook) {
        this.handlePartitionlookup = hook;
    }

    public void resetHandlePartitionLookup() {
        this.handlePartitionlookup = null;
    }

    public void setHandleLookup(MockBrokerServiceHooks.CommandTopicLookupHook hook) {
        this.handleTopiclookup = hook;
    }

    public void resetHandleLookup() {
        this.handleTopiclookup = null;
    }

    public void setHandleSubscribe(MockBrokerServiceHooks.CommandSubscribeHook hook) {
        this.handleSubscribe = hook;
    }

    public void resetHandleSubscribe() {
        this.handleSubscribe = null;
    }

    public void setHandleProducer(MockBrokerServiceHooks.CommandProducerHook hook) {
        this.handleProducer = hook;
    }

    public void resetHandleProducer() {
        this.handleProducer = null;
    }

    public void setHandleSend(MockBrokerServiceHooks.CommandSendHook hook) {
        this.handleSend = hook;
    }

    public void resetHandleSend() {
        this.handleSend = null;
    }

    public void setHandleAck(MockBrokerServiceHooks.CommandAckHook hook) {
        this.handleAck = hook;
    }

    public void resetHandleAck() {
        this.handleAck = null;
    }

    public void setHandleFlow(MockBrokerServiceHooks.CommandFlowHook hook) {
        this.handleFlow = hook;
    }

    public void resetHandleFlow() {
        this.handleFlow = null;
    }

    public void setHandleUnsubscribe(MockBrokerServiceHooks.CommandUnsubscribeHook hook) {
        this.handleUnsubscribe = hook;
    }

    public void resetHandleUnsubscribe() {
        this.handleUnsubscribe = null;
    }

    public void setHandleCloseProducer(MockBrokerServiceHooks.CommandCloseProducerHook hook) {
        this.handleCloseProducer = hook;
    }

    public void resetHandleCloseProducer() {
        this.handleCloseProducer = null;
    }

    public void setHandleCloseConsumer(MockBrokerServiceHooks.CommandCloseConsumerHook hook) {
        this.handleCloseConsumer = hook;
    }

    public void resetHandleCloseConsumer() {
        this.handleCloseConsumer = null;
    }

    static /* synthetic */ int access$100(MockBrokerService x0) {
        return x0.brokerServicePortTls;
    }

    static /* synthetic */ int access$200(MockBrokerService x0) {
        return x0.webServicePort;
    }

    private class MockServerCnx
    extends PulsarDecoder {
        ChannelHandlerContext ctx;
        long producerId = 0L;

        private MockServerCnx() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.ctx = ctx;
        }

        protected void messageReceived() {
        }

        protected void handleConnect(PulsarApi.CommandConnect connect) {
            if (MockBrokerService.this.handleConnect != null) {
                MockBrokerService.this.handleConnect.apply(this.ctx, connect);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newConnected((int)connect.getProtocolVersion()));
        }

        protected void handlePartitionMetadataRequest(PulsarApi.CommandPartitionedTopicMetadata request) {
            if (MockBrokerService.this.handlePartitionlookup != null) {
                MockBrokerService.this.handlePartitionlookup.apply(this.ctx, request);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newPartitionMetadataResponse((int)0, (long)request.getRequestId()));
        }

        protected void handleLookup(PulsarApi.CommandLookupTopic lookup) {
            if (MockBrokerService.this.handleTopiclookup != null) {
                MockBrokerService.this.handleTopiclookup.apply(this.ctx, lookup);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newLookupResponse((String)("pulsar://127.0.0.1:" + MockBrokerService.this.brokerServicePort), null, (boolean)true, (PulsarApi.CommandLookupTopicResponse.LookupType)PulsarApi.CommandLookupTopicResponse.LookupType.Connect, (long)lookup.getRequestId(), (boolean)false));
        }

        protected void handleSubscribe(PulsarApi.CommandSubscribe subscribe) {
            if (MockBrokerService.this.handleSubscribe != null) {
                MockBrokerService.this.handleSubscribe.apply(this.ctx, subscribe);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newSuccess((long)subscribe.getRequestId()));
        }

        protected void handleProducer(PulsarApi.CommandProducer producer) {
            this.producerId = producer.getProducerId();
            if (MockBrokerService.this.handleProducer != null) {
                MockBrokerService.this.handleProducer.apply(this.ctx, producer);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newProducerSuccess((long)producer.getRequestId(), (String)"default-producer", (SchemaVersion)SchemaVersion.Empty));
        }

        protected void handleSend(PulsarApi.CommandSend send, ByteBuf headersAndPayload) {
            if (MockBrokerService.this.handleSend != null) {
                MockBrokerService.this.handleSend.apply(this.ctx, send, headersAndPayload);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newSendReceipt((long)this.producerId, (long)send.getSequenceId(), (long)0L, (long)0L));
        }

        protected void handleAck(PulsarApi.CommandAck ack) {
            if (MockBrokerService.this.handleAck != null) {
                MockBrokerService.this.handleAck.apply(this.ctx, ack);
            }
        }

        protected void handleFlow(PulsarApi.CommandFlow flow) {
            if (MockBrokerService.this.handleFlow != null) {
                MockBrokerService.this.handleFlow.apply(this.ctx, flow);
            }
        }

        protected void handleUnsubscribe(PulsarApi.CommandUnsubscribe unsubscribe) {
            if (MockBrokerService.this.handleUnsubscribe != null) {
                MockBrokerService.this.handleUnsubscribe.apply(this.ctx, unsubscribe);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newSuccess((long)unsubscribe.getRequestId()));
        }

        protected void handleCloseProducer(PulsarApi.CommandCloseProducer closeProducer) {
            if (MockBrokerService.this.handleCloseProducer != null) {
                MockBrokerService.this.handleCloseProducer.apply(this.ctx, closeProducer);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newSuccess((long)closeProducer.getRequestId()));
        }

        protected void handleCloseConsumer(PulsarApi.CommandCloseConsumer closeConsumer) {
            if (MockBrokerService.this.handleCloseConsumer != null) {
                MockBrokerService.this.handleCloseConsumer.apply(this.ctx, closeConsumer);
                return;
            }
            this.ctx.writeAndFlush((Object)Commands.newSuccess((long)closeConsumer.getRequestId()));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            log.warn("Got exception", cause);
            ctx.close();
        }
    }

    private class genericResponseHandler
    extends AbstractHandler {
        private final ObjectMapper objectMapper = new ObjectMapper();
        private final String lookupURI = "/lookup/v2/destination/persistent";
        private final String partitionMetadataURI = "/admin/persistent";
        private final LookupData lookupData = new LookupData("pulsar://127.0.0.1:" + MockBrokerService.access$000(MockBrokerService.this), "pulsar://127.0.0.1:" + MockBrokerService.access$100(MockBrokerService.this), "http://127.0.0.1:" + MockBrokerService.access$200(MockBrokerService.this), null);
        private final PartitionedTopicMetadata singlePartitionedTopicMetadata = new PartitionedTopicMetadata(1);
        private final PartitionedTopicMetadata multiPartitionedTopicMetadata = new PartitionedTopicMetadata(4);
        private final PartitionedTopicMetadata nonPartitionedTopicMetadata = new PartitionedTopicMetadata();
        private final Pattern singlePartPattern = Pattern.compile(".*/part-.*");
        private final Pattern multiPartPattern = Pattern.compile(".*/multi-part-.*");

        private genericResponseHandler() {
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String responseString;
            log.info("Received HTTP request {}", (Object)baseRequest.getRequestURI());
            if (baseRequest.getRequestURI().startsWith("/lookup/v2/destination/persistent")) {
                response.setContentType("application/json;charset=utf-8");
                response.setStatus(200);
                responseString = this.objectMapper.writeValueAsString((Object)this.lookupData);
            } else if (baseRequest.getRequestURI().startsWith("/admin/persistent")) {
                response.setContentType("application/json;charset=utf-8");
                response.setStatus(200);
                responseString = this.singlePartPattern.matcher(baseRequest.getRequestURI()).matches() ? this.objectMapper.writeValueAsString((Object)this.singlePartitionedTopicMetadata) : (this.multiPartPattern.matcher(baseRequest.getRequestURI()).matches() ? this.objectMapper.writeValueAsString((Object)this.multiPartitionedTopicMetadata) : this.objectMapper.writeValueAsString((Object)this.nonPartitionedTopicMetadata));
            } else {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(404);
                responseString = "URI NOT DEFINED";
            }
            baseRequest.setHandled(true);
            response.getWriter().println(responseString);
            log.info("Sent response: {}", (Object)responseString);
        }
    }
}

