/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MutualAuthenticationTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(MutualAuthenticationTest.class);
    private MutualAuthentication mutualAuth;
    private static String[] clientAuthStrings = new String[]{"MutualClientAuthInit", "MutualClientStep1"};
    private static String[] serverAuthStrings = new String[]{"ResponseMutualClientAuthInit"};

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.mutualAuth = new MutualAuthentication();
        HashSet<String> superUserRoles = new HashSet<String>();
        superUserRoles.add("admin");
        this.conf.setSuperUserRoles(superUserRoles);
        this.conf.setAuthorizationEnabled(true);
        this.conf.setAuthenticationEnabled(true);
        HashSet providersClassNames = Sets.newHashSet((Object[])new String[]{MutualAuthenticationProvider.class.getName()});
        this.conf.setAuthenticationProviders((Set)providersClassNames);
        super.init();
        URI brokerServiceUrl = new URI("pulsar://localhost:" + this.BROKER_PORT);
        this.pulsarClient = PulsarClient.builder().serviceUrl(brokerServiceUrl.toString()).authentication((Authentication)this.mutualAuth).build();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testAuthentication() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscribe();
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://my-property/my-ns/my-topic1").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        Message msg = null;
        HashSet messageSet = Sets.newHashSet();
        for (int i = 0; i < 10; ++i) {
            msg = consumer.receive(5, TimeUnit.SECONDS);
            String receivedMessage = new String(msg.getData());
            log.debug("Received message: [{}]", (Object)receivedMessage);
            String expectedMessage = "my-message-" + i;
            this.testMessageOrderAndDuplicates(messageSet, receivedMessage, expectedMessage);
        }
        consumer.acknowledgeCumulative(msg);
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    public static class MutualAuthenticationProvider
    implements AuthenticationProvider {
        public void close() throws IOException {
        }

        public void initialize(ServiceConfiguration config) throws IOException {
        }

        public String getAuthMethodName() {
            return "MutualAuthentication";
        }

        public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
            return "admin";
        }

        public AuthenticationState newAuthState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession) {
            return new MutualAuthenticationState();
        }
    }

    public static class MutualAuthenticationState
    implements AuthenticationState {
        private boolean isComplete = false;

        public String getAuthRole() throws AuthenticationException {
            return "admin";
        }

        public AuthData authenticate(AuthData authData) throws AuthenticationException {
            AuthData toSend;
            String dataString = new String(authData.getBytes(), StandardCharsets.UTF_8);
            if (Arrays.equals(dataString.getBytes(), clientAuthStrings[0].getBytes(StandardCharsets.UTF_8))) {
                toSend = AuthData.of((byte[])serverAuthStrings[0].getBytes(StandardCharsets.UTF_8));
            } else if (Arrays.equals(dataString.getBytes(), clientAuthStrings[1].getBytes(StandardCharsets.UTF_8))) {
                this.isComplete = true;
                toSend = AuthData.of(null);
            } else {
                throw new AuthenticationException();
            }
            log.debug("authenticate in server. passed in :{}, send: {}", (Object)dataString, (Object)(toSend.getBytes() == null ? "null" : new String(toSend.getBytes(), StandardCharsets.UTF_8)));
            return toSend;
        }

        public AuthenticationDataSource getAuthDataSource() {
            return null;
        }

        public boolean isComplete() {
            return this.isComplete;
        }
    }

    public static class MutualAuthentication
    implements Authentication {
        public void close() throws IOException {
        }

        public String getAuthMethodName() {
            return "MutualAuthentication";
        }

        public AuthenticationDataProvider getAuthData(String broker) throws PulsarClientException {
            try {
                return new MutualAuthenticationDataProvider();
            }
            catch (Exception e) {
                throw new PulsarClientException((Throwable)e);
            }
        }

        public void configure(Map<String, String> authParams) {
        }

        public void start() throws PulsarClientException {
        }
    }

    public static class MutualAuthenticationDataProvider
    implements AuthenticationDataProvider {
        public boolean hasDataFromCommand() {
            return true;
        }

        public AuthData authenticate(AuthData data) throws AuthenticationException {
            AuthData toSend;
            String dataString = new String(data.getBytes(), StandardCharsets.UTF_8);
            if (Arrays.equals(dataString.getBytes(), AuthData.INIT_AUTH_DATA)) {
                toSend = AuthData.of((byte[])clientAuthStrings[0].getBytes(StandardCharsets.UTF_8));
            } else if (Arrays.equals(dataString.getBytes(), serverAuthStrings[0].getBytes(StandardCharsets.UTF_8))) {
                toSend = AuthData.of((byte[])clientAuthStrings[1].getBytes(StandardCharsets.UTF_8));
            } else {
                throw new AuthenticationException();
            }
            log.debug("authenticate in client. passed in :{}, send: {}", (Object)dataString, (Object)new String(toSend.getBytes(), StandardCharsets.UTF_8));
            return toSend;
        }
    }
}

