/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.nio.charset.StandardCharsets;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

public class SimpleSchemaTest
extends ProducerConsumerBase {
    private final boolean schemaValidationEnforced;

    @DataProvider(name="batchingModes")
    public static Object[][] batchingModes() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider(name="schemaValidationModes")
    public static Object[][] schemaValidationModes() {
        return new Object[][]{{true}, {false}};
    }

    @Factory(dataProvider="schemaValidationModes")
    public SimpleSchemaTest(boolean schemaValidationEnforced) {
        this.schemaValidationEnforced = schemaValidationEnforced;
    }

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setSchemaValidationEnforced(this.schemaValidationEnforced);
        this.isTcpLookup = true;
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testString() throws Exception {
        try (Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://my-property/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscribe();
             Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://my-property/my-ns/my-topic1").create();){
            int i;
            int N = 10;
            for (i = 0; i < N; ++i) {
                producer.send((Object)("my-message-" + i));
            }
            for (i = 0; i < N; ++i) {
                Message msg = consumer.receive();
                Assert.assertEquals((String)((String)msg.getValue()), (String)("my-message-" + i));
                consumer.acknowledge(msg);
            }
        }
    }

    @Test
    public void newProducerNewTopicNewSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();){
            p.send((Object)new V1Data(0));
        }
    }

    @Test
    public void newProducerTopicExistsWithoutSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer().topic(topic).create();){
            p.send((Object)topic.getBytes(StandardCharsets.UTF_8));
        }
        p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
        var3_3 = null;
        try {
            p.send((Object)new V1Data(0));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var3_3 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
    }

    @Test
    public void newProducerTopicExistsWithSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();){
            p.send((Object)new V1Data(1));
        }
        p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
        var3_3 = null;
        try {
            p.send((Object)new V1Data(0));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var3_3 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
    }

    @Test
    public void newProducerWithoutSchemaOnTopicWithSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();){
            p.send((Object)new V1Data(0));
        }
        try {
            p = this.pulsarClient.newProducer(Schema.BYTES).topic(topic).create();
            var3_5 = null;
            try {
                if (!this.schemaValidationEnforced) {
                    p.send((Object)"junkdata".getBytes(StandardCharsets.UTF_8));
                } else {
                    Assert.fail((String)"Shouldn't be able to connect to a schema'd topic with no schema if SchemaValidationEnabled is enabled");
                }
            }
            catch (Throwable throwable) {
                var3_5 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var3_5 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var3_5.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            if (this.schemaValidationEnforced) {
                Assert.assertTrue((boolean)(e instanceof PulsarClientException.IncompatibleSchemaException));
            }
            Assert.fail((String)"Shouldn't throw IncompatibleSchemaException if SchemaValidationEnforced is disabled");
        }
        try {
            p = this.pulsarClient.newProducer(Schema.AUTO_PRODUCE_BYTES()).topic(topic).create();
            var3_5 = null;
            try {
                p.send((Object)"junkdata".getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                var3_5 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var3_5 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var3_5.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SchemaSerializationException));
        }
    }

    @Test
    public void newConsumerWithSchemaOnNewTopic() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V1Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();
             Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();){
            V1Data toSend = new V1Data(1);
            p.send((Object)toSend);
            Assert.assertEquals((Object)toSend, (Object)c.receive().getValue());
        }
    }

    @Test
    public void newConsumerWithSchemaOnExistingTopicWithoutSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer().topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V1Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            Assert.fail((String)"Shouldn't be able to consume with a schema from a topic which has no schema set");
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException.IncompatibleSchemaException));
        }
    }

    @Test
    public void newConsumerWithSchemaTopicHasSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V1Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            V1Data toSend = new V1Data(1);
            p.send((Object)toSend);
            Assert.assertEquals((Object)toSend, (Object)c.receive().getValue());
        }
    }

    @Test
    public void newBytesConsumerWithTopicWithSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            p.send((Object)new V1Data(1));
            Assert.assertTrue((((byte[])c.receive().getValue()).length > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void getSchemaVersionFromMessagesBatchingDisabled() throws Exception {
        this.getSchemaVersionFromMessages(false);
    }

    @Test
    public void getSchemaVersionFromMessagesBatchingEnabled() throws Exception {
        this.getSchemaVersionFromMessages(true);
    }

    private void getSchemaVersionFromMessages(boolean batching) throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).enableBatching(batching).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V1Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
            p.send((Object)new V1Data(1));
            Message data = c.receive();
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertEquals((Object)data.getValue(), (Object)new V1Data(1));
        }
    }

    @Test(dataProvider="batchingModes")
    public void testAutoConsume(boolean batching) throws Exception {
        String topic = "my-property/my-ns/schema-test-auto-consume-" + batching;
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).enableBatching(batching).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{topic}).subscriptionName("sub1").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
            int i;
            int numMessages = 10;
            for (i = 0; i < numMessages; ++i) {
                p.sendAsync((Object)new V1Data(i));
            }
            p.flush();
            for (i = 0; i < numMessages; ++i) {
                Message data = c.receive();
                Assert.assertNotNull((Object)data.getSchemaVersion());
                Assert.assertEquals((Object)((GenericRecord)data.getValue()).getField("i"), (Object)i);
            }
        }
    }

    @Test(dataProvider="batchingModes")
    public void testAutoKeyValueConsume(boolean batching) throws Exception {
        String topic = "my-property/my-ns/schema-test-auto-keyvalue-consume-" + batching;
        Schema pojoSchema = Schema.KeyValue((Schema)Schema.AVRO(V1Data.class), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)KeyValueEncodingType.SEPARATED);
        try (Producer p = this.pulsarClient.newProducer(pojoSchema).topic(topic).enableBatching(batching).create();
             Consumer c1 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AUTO_CONSUME(), (KeyValueEncodingType)KeyValueEncodingType.SEPARATED)).topic(new String[]{topic}).subscriptionName("sub1").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
             Consumer c2 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AVRO(V1Data.class), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)KeyValueEncodingType.SEPARATED)).topic(new String[]{topic}).subscriptionName("sub2").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
             Consumer c3 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)KeyValueEncodingType.SEPARATED)).topic(new String[]{topic}).subscriptionName("sub3").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
             Consumer c4 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AVRO(V1Data.class), (Schema)Schema.AUTO_CONSUME(), (KeyValueEncodingType)KeyValueEncodingType.SEPARATED)).topic(new String[]{topic}).subscriptionName("sub4").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
            Message data;
            int i;
            int numMessages = 10;
            for (i = 0; i < numMessages; ++i) {
                p.sendAsync((Object)new KeyValue((Object)new V1Data(i * 100), (Object)new V1Data(i * 1000)));
            }
            p.flush();
            for (i = 0; i < numMessages; ++i) {
                data = c1.receive();
                Assert.assertNotNull((Object)data.getSchemaVersion());
                Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("i"), (Object)(i * 100));
                Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getValue()).getField("i"), (Object)(i * 1000));
            }
            for (i = 0; i < numMessages; ++i) {
                data = c2.receive();
                Assert.assertNotNull((Object)data.getSchemaVersion());
                Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getKey()).i, (int)(i * 100));
                Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getValue()).i, (int)(i * 1000));
            }
            for (i = 0; i < numMessages; ++i) {
                data = c3.receive();
                Assert.assertNotNull((Object)data.getSchemaVersion());
                Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("i"), (Object)(i * 100));
                Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getValue()).i, (int)(i * 1000));
            }
            for (i = 0; i < numMessages; ++i) {
                data = c4.receive();
                Assert.assertNotNull((Object)data.getSchemaVersion());
                Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getKey()).i, (int)(i * 100));
                Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getValue()).getField("i"), (Object)(i * 1000));
            }
        }
    }

    static class V1Data {
        int i;

        V1Data() {
            this.i = 0;
        }

        V1Data(int i) {
            this.i = i;
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object other) {
            return other instanceof V1Data && this.i == ((V1Data)other).i;
        }
    }
}

