/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.HashMap;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.TlsProducerConsumerBase;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TlsHostVerification
extends TlsProducerConsumerBase {
    @Test
    public void testTlsHostVerificationAdminClient() throws Exception {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        PulsarAdmin adminClientTls = PulsarAdmin.builder().serviceHttpUrl("https://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT_TLS).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").allowTlsInsecureConnection(false).authentication(AuthenticationTls.class.getName(), authParams).enableTlsHostnameVerification(true).build();
        try {
            adminClientTls.tenants().getTenants();
            Assert.fail((String)"Admin call should be failed due to hostnameVerification enabled");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
    }

    @Test
    public void testTlsHostVerificationDisabledAdminClient() throws Exception {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        PulsarAdmin adminClient = PulsarAdmin.builder().serviceHttpUrl("https://127.0.0.1:" + this.BROKER_WEBSERVICE_PORT_TLS).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").allowTlsInsecureConnection(false).authentication(AuthenticationTls.class.getName(), authParams).enableTlsHostnameVerification(false).build();
        adminClient.tenants().getTenants();
    }
}

