/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class TlsProducerConsumerBase
extends ProducerConsumerBase {
    protected final String TLS_TRUST_CERT_FILE_PATH = "./src/test/resources/authentication/tls/cacert.pem";
    protected final String TLS_CLIENT_CERT_FILE_PATH = "./src/test/resources/authentication/tls/client-cert.pem";
    protected final String TLS_CLIENT_KEY_FILE_PATH = "./src/test/resources/authentication/tls/client-key.pem";
    protected final String TLS_SERVER_CERT_FILE_PATH = "./src/test/resources/authentication/tls/broker-cert.pem";
    protected final String TLS_SERVER_KEY_FILE_PATH = "./src/test/resources/authentication/tls/broker-key.pem";
    private final String clusterName = "use";

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.internalSetUpForBroker();
        super.init();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    protected void internalSetUpForBroker() throws Exception {
        this.conf.setBrokerServicePortTls(Optional.of(this.BROKER_PORT_TLS));
        this.conf.setWebServicePortTls(Optional.of(this.BROKER_WEBSERVICE_PORT_TLS));
        this.conf.setTlsCertificateFilePath("./src/test/resources/authentication/tls/broker-cert.pem");
        this.conf.setTlsKeyFilePath("./src/test/resources/authentication/tls/broker-key.pem");
        this.conf.setTlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.conf.setClusterName("use");
        this.conf.setTlsRequireTrustedClientCertOnConnect(true);
        Set tlsProtocols = Sets.newConcurrentHashSet();
        tlsProtocols.add("TLSv1.2");
        this.conf.setTlsProtocols(tlsProtocols);
    }

    protected void internalSetUpForClient(boolean addCertificates, String lookupUrl) throws Exception {
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(lookupUrl).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").enableTls(true).allowTlsInsecureConnection(false);
        if (addCertificates) {
            HashMap<String, String> authParams = new HashMap<String, String>();
            authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
            authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
            clientBuilder.authentication(AuthenticationTls.class.getName(), authParams);
        }
        this.pulsarClient = clientBuilder.build();
    }

    protected void internalSetUpForNamespace() throws Exception {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerUrlTls.toString()).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").allowTlsInsecureConnection(false).authentication(AuthenticationTls.class.getName(), authParams).build());
        this.admin.clusters().createCluster("use", new ClusterData(this.brokerUrl.toString(), this.brokerUrlTls.toString(), "pulsar://localhost:" + this.BROKER_PORT, "pulsar+ssl://localhost:" + this.BROKER_PORT_TLS));
        this.admin.tenants().createTenant("my-property", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        this.admin.namespaces().createNamespace("my-property/my-ns");
    }
}

