/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.TlsProducerConsumerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TlsProducerConsumerTest
extends TlsProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(TlsProducerConsumerTest.class);

    @Test(timeOut=30000L)
    public void testTlsLargeSizeMessage() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        int MESSAGE_SIZE = 16385;
        log.info("-- message size --", (Object)16385);
        this.internalSetUpForClient(true, "pulsar+ssl://localhost:" + this.BROKER_PORT_TLS);
        this.internalSetUpForNamespace();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscribe();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        for (int i = 0; i < 10; ++i) {
            byte[] message = new byte[16385];
            Arrays.fill(message, (byte)i);
            producer.send((Object)message);
        }
        Message msg = null;
        for (int i = 0; i < 10; ++i) {
            msg = consumer.receive(5, TimeUnit.SECONDS);
            byte[] expected = new byte[16385];
            Arrays.fill(expected, (byte)i);
            Assert.assertEquals((byte[])expected, (byte[])msg.getData());
        }
        consumer.acknowledgeCumulative(msg);
        consumer.close();
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test(timeOut=30000L)
    public void testTlsClientAuthOverBinaryProtocol() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        int MESSAGE_SIZE = 16385;
        log.info("-- message size --", (Object)16385);
        this.internalSetUpForNamespace();
        this.internalSetUpForClient(false, "pulsar+ssl://localhost:" + this.BROKER_PORT_TLS);
        try {
            this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Exclusive).subscribe();
            Assert.fail((String)"Server should have failed the TLS handshake since client didn't .");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.internalSetUpForClient(true, "pulsar+ssl://localhost:" + this.BROKER_PORT_TLS);
        try {
            this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Exclusive).subscribe();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not fail since certs are sent.");
        }
    }

    @Test(timeOut=30000L)
    public void testTlsClientAuthOverHTTPProtocol() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        int MESSAGE_SIZE = 16385;
        log.info("-- message size --", (Object)16385);
        this.internalSetUpForNamespace();
        this.internalSetUpForClient(false, "https://localhost:" + this.BROKER_WEBSERVICE_PORT_TLS);
        try {
            this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Exclusive).subscribe();
            Assert.fail((String)"Server should have failed the TLS handshake since client didn't .");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.internalSetUpForClient(true, "https://localhost:" + this.BROKER_WEBSERVICE_PORT_TLS);
        try {
            this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Exclusive).subscribe();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not fail since certs are sent.");
        }
    }
}

