/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class BatchMessageIdImplSerializationTest {
    @Test
    void testSerialization1() throws Exception {
        BatchMessageIdImpl id = new BatchMessageIdImpl(1L, 2L, 3, 4);
        byte[] serializedId = id.toByteArray();
        Assert.assertEquals((Object)BatchMessageIdImpl.fromByteArray((byte[])serializedId), (Object)id);
    }

    @Test
    void testSerialization2() throws Exception {
        BatchMessageIdImpl id = new BatchMessageIdImpl(1L, 2L, -1, 3);
        byte[] serializedId = id.toByteArray();
        Assert.assertEquals((Object)BatchMessageIdImpl.fromByteArray((byte[])serializedId), (Object)id);
    }

    @Test(expectedExceptions={NullPointerException.class})
    void testSerializationNull() throws Exception {
        BatchMessageIdImpl.fromByteArray(null);
    }

    @Test(expectedExceptions={IOException.class})
    void testSerializationEmpty() throws Exception {
        BatchMessageIdImpl.fromByteArray((byte[])new byte[0]);
    }
}

