/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.impl.ConnectionPool;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.mockito.Mockito;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ConnectionPoolTest
extends MockedPulsarServiceBaseTest {
    String serviceUrl;

    public ConnectionPoolTest() {
        this.serviceUrl = "pulsar://non-existing-dns-name:" + this.BROKER_PORT;
    }

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testSingleIpAddress() throws Exception {
        ClientConfigurationData conf = new ClientConfigurationData();
        EventLoopGroup eventLoop = EventLoopUtil.newEventLoopGroup((int)1, (ThreadFactory)new DefaultThreadFactory("test"));
        ConnectionPool pool = (ConnectionPool)Mockito.spy((Object)new ConnectionPool(conf, eventLoop));
        conf.setServiceUrl(this.serviceUrl);
        PulsarClientImpl client = new PulsarClientImpl(conf, eventLoop, pool);
        ArrayList result = Lists.newArrayList();
        result.add(InetAddress.getByName("127.0.0.1"));
        Mockito.when((Object)pool.resolveName("non-existing-dns-name")).thenReturn(CompletableFuture.completedFuture(result));
        client.newProducer().topic("persistent://sample/standalone/ns/my-topic").create();
        client.close();
    }

    @Test
    public void testDoubleIpAddress() throws Exception {
        String serviceUrl = "pulsar://non-existing-dns-name:" + this.BROKER_PORT;
        ClientConfigurationData conf = new ClientConfigurationData();
        EventLoopGroup eventLoop = EventLoopUtil.newEventLoopGroup((int)1, (ThreadFactory)new DefaultThreadFactory("test"));
        ConnectionPool pool = (ConnectionPool)Mockito.spy((Object)new ConnectionPool(conf, eventLoop));
        conf.setServiceUrl(serviceUrl);
        PulsarClientImpl client = new PulsarClientImpl(conf, eventLoop, pool);
        ArrayList result = Lists.newArrayList();
        result.add(InetAddress.getByName("127.0.0.99"));
        result.add(InetAddress.getByName("127.0.0.1"));
        Mockito.when((Object)pool.resolveName("non-existing-dns-name")).thenReturn(CompletableFuture.completedFuture(result));
        client.newProducer().topic("persistent://sample/standalone/ns/my-topic").create();
        client.close();
    }
}

